package com.ejianc.foundation.file.hystrix;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.file.vo.WaterMarketConfigVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;

import feign.Response;

/**
 * 附件服务降级
 *
 * @author guominga
 *
 */
@Component
public class AttachmentHystrix implements IAttachmentApi {

	@Override
	public CommonResponse<List<AttachmentVO>> pdfFileToImg(JSONObject params) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<List<AttachmentVO>> queryAllBySourceIdList(JSONObject paramStr) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<List<AttachmentVO>> queryListBySourceId(Long sourceId, String billType, String sourceType, String orderType) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<String> updateAttachArchiveStatus(String jsonParam) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<AttachmentVO> queryAttachmentDetail(Long fileId) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<String> updateAttachRef(Long sourceId, List<Long> attachIds) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<String> delete(String ids) {
		return CommonResponse.error("文件服务器开小差了");
	}

	/***
	 * @Author mrsir_wxp
	 * @Date 2020/9/4 将文件
	 * @Description copyFilesFromSourceBillToTargetBill
	 * @Param [
	 * sourceBillId,从此id单据复制
	 * targetBillId 复制到目的单据id
	 * targetBillType 新的单据类型编码
	 * targetBillSourceType 新的文件类型标识
	 * ]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@Override
	public CommonResponse<String> copyFilesFromSourceBillToTargetBill(String sourceBillId, String sourceBillType, String sourceBillSourceType,String targetBillId, String targetBillType, String targetBillSourceType) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<List<AttachmentVO>> copyFiles(String sourceBillId, String sourceBillType, String sourceBillSourceType, String targetBillId, String targetBillType, String targetBillSourceType, boolean clearTargetFile) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<AttachmentVO> copyFile(String sourceFileId, String targetBillId, String targetBillType, String targetBillSourceType, boolean clearTargetFile) {
		return CommonResponse.error("文件服务器开小差了");
	}

	/***
	 * 批量复制sourceFileIds文件到指定目标单据
	 *
	 * @param sourceFileIds  源文件id
	 * @param targetBillId 复制到目的单据id
	 * @param targetBillType 新的单据类型编码
	 * @param targetBillSourceType 新的文件类型标识
	 * @return
	 */
	@Override
	public CommonResponse<List<AttachmentVO>> copyFileBeach(List<String> sourceFileIds, String targetBillId, String targetBillType, String targetBillSourceType ) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<List<AttachmentVO>> uploadForBase64(AttachmentRequestVO request) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<List<AttachmentVO>> uploadSignatureForBase64(AttachmentRequestVO request) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<List<AttachmentVO>> queryNoAuthListBySourceId(Long sourceId, String billType,
			String sourceType, String orderType) {
		return CommonResponse.error("文件服务器开小差了");
	}

	/**
	 * @param id
	 * @Author mrsir_wxp
	 * @Date 2021/6/3 查询附件详情
	 * @Description queryDetail
	 * @Param [id]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.file.vo.AttachmentVO>
	 */
	@Override
	public CommonResponse<AttachmentVO> queryDetail(String id) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<String> insertBatch(List<AttachmentVO> AttachmentVOs) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public Response downloadFileById(Long fileId) {
		throw new BusinessException("文件服务器开小差了");
	}

	@Override
	public CommonResponse<String> deleteFileByParams(Long sourceId, String billType, String sourceType, List<String> fileNames) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<String> deleteFileByParam(Long sourceId, String billType, String sourceType) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<List<AttachmentVO>> copyFromSourceBillToTargetBill(String sourceBillId, String sourceBillType, String sourceBillSourceType, String targetBillId, String targetBillType, String targetBillSourceType) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<String> makeWatermarkToFile(Long fileId, String watermarkText, String waterWay) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<Map<Long, Integer>> queryNumberBySourceId(List<Long> sourceIds, String billType, String sourceType) {
		return CommonResponse.error("文件服务器开小差了");
	}


	/**
	 * 全量更新文件信息
	 * ！！！！！注意，是全量更新，请自行查询到vo，修改相关字段后再调用该接口！！！！
	 * */
	@Override
	public CommonResponse<String> updateFileInfo(AttachmentVO vo) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<AttachmentVO> addMakeWatermark(WaterMarketConfigVO waterMarketConfig) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<String> uploadFileFormNet(UploadFileForNetParam param) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<List<AttachmentVO>> queryAllByIds(List<Long> fileIds) {
		return CommonResponse.error("文件服务器开小差了");
	}

	@Override
	public CommonResponse<Integer> queryPageNumber(Long fileId) {
		return CommonResponse.error("文件服务器开小差了");
	}

}
