package com.ejianc.foundation.file.service.impl;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

import com.ejianc.foundation.file.service.FilePreview;
import com.ejianc.foundation.file.vo.AttachmentVO;


@Service
public class MediaFilePreviewImpl implements FilePreview {
    @Value("${common.env.base-host:#{null}}")
    private String baseHost;

    @Override
    public String filePreviewHandle(HttpServletRequest req, AttachmentVO attachmentVo, Model model) {
        String modiaUrl = null;
        String url = attachmentVo.getFilePath();
		if(url.indexOf("http") != -1) {
			modiaUrl = url;
		}else{
			modiaUrl = baseHost + "ejc-file-web/attachment/filePreview?filePath=" + url;
		}
        model.addAttribute("mediaUrl", modiaUrl);
        return "media";
    }


}
