/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.bean.AttachmentEntity;
import com.ejianc.foundation.file.bean.MyFavoriteEntity;
import com.ejianc.foundation.file.bean.NetStoreCategoryEntity;
import com.ejianc.foundation.file.bean.ViewLogEntity;
import com.ejianc.foundation.file.config.MinioCommonConts;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.service.IMyFavoriteService;
import com.ejianc.foundation.file.service.INetStoreCategoryService;
import com.ejianc.foundation.file.service.IViewLogService;
import com.ejianc.foundation.file.util.FolderParam;
import com.ejianc.foundation.file.util.NetStoreAsTree;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IModuleApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"netstore"})
public class NetStoreController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private INetStoreCategoryService netStoreCategoryService;
    @Autowired
    private IModuleApi moduleApi;
    @Autowired
    private IAttachmentService attachmentService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private MinioConfiguration minioConfiguration;
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IMyFavoriteService myFavoriteService;
    @Autowired
    private IViewLogService viewLogService;

    @RequestMapping(value={"/folders"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FolderParam> folders() {
        Long tenantId;
        List<NetStoreCategoryEntity> categoryEntities;
        List<FolderParam> storeCategories;
        CommonResponse moduleResponse = this.moduleApi.queryModuleTree();
        ArrayList<FolderParam> folderParams = new ArrayList<FolderParam>();
        if (moduleResponse.isSuccess()) {
            List moduleVoList = (List)moduleResponse.getData();
            List<FolderParam> moduleParams = NetStoreAsTree.createModuleTreeDataVO(moduleVoList);
            FolderParam folderParam = new FolderParam();
            folderParam.setId(20230109L);
            folderParam.setType("folder");
            folderParam.setValue("\u4e1a\u52a1\u6587\u6863");
            folderParam.setLabel(2);
            folderParam.setData(moduleParams);
            folderParams.add(folderParam);
        }
        if ((storeCategories = NetStoreAsTree.createTreeDataVO(categoryEntities = this.netStoreCategoryService.queryStoreCategoryList(tenantId = InvocationInfoProxy.getTenantid()))) != null && storeCategories.size() > 0) {
            folderParams.addAll(storeCategories);
        }
        return folderParams;
    }

    @RequestMapping(value={"/makedir"}, method={RequestMethod.POST})
    @ResponseBody
    public FolderParam makedir(@RequestParam(value="id") String id, @RequestParam(value="name") String name) {
        NetStoreCategoryEntity categoryEntity = new NetStoreCategoryEntity();
        Long pkId = IdWorker.getId();
        categoryEntity.setId(pkId);
        categoryEntity.setCategoryName(name);
        if ("/".equals(id)) {
            categoryEntity.setInnerCode(pkId + "");
        } else {
            categoryEntity.setParentId(Long.parseLong(id));
            NetStoreCategoryEntity parentBean = (NetStoreCategoryEntity)((Object)this.netStoreCategoryService.getById((Serializable)((Object)id)));
            categoryEntity.setInnerCode(parentBean.getInnerCode() + "|" + pkId);
        }
        categoryEntity.setCreateTime(new Date());
        this.netStoreCategoryService.save((Object)categoryEntity);
        FolderParam folderParam = new FolderParam();
        folderParam.setId(pkId);
        folderParam.setParentId(categoryEntity.getParentId());
        folderParam.setType("folder");
        folderParam.setValue(name);
        folderParam.setLabel(1);
        return folderParam;
    }

    @RequestMapping(value={"/rename"}, method={RequestMethod.POST})
    @ResponseBody
    public FolderParam rename(@RequestParam(value="id") String id, @RequestParam(value="name") String name) {
        NetStoreCategoryEntity categoryEntity = (NetStoreCategoryEntity)((Object)this.netStoreCategoryService.getById((Serializable)((Object)id)));
        FolderParam folderParam = new FolderParam();
        if (categoryEntity != null) {
            categoryEntity.setCategoryName(name);
            this.netStoreCategoryService.saveOrUpdate((Object)categoryEntity);
            folderParam.setId(categoryEntity.getId());
            folderParam.setParentId(categoryEntity.getParentId());
            folderParam.setType("folder");
            folderParam.setValue(name);
            folderParam.setLabel(1);
        } else {
            AttachmentEntity attachmentEntity = (AttachmentEntity)((Object)this.attachmentService.getById((Serializable)((Object)id)));
            String suffix = attachmentEntity.getFileName().substring(attachmentEntity.getFileName().lastIndexOf("."));
            if (StringUtils.isNotBlank((CharSequence)name)) {
                name = name.lastIndexOf(".") != -1 ? name.substring(0, name.lastIndexOf(".")) + suffix : name + suffix;
                attachmentEntity.setFileName(name);
                this.attachmentService.updateById((Object)attachmentEntity);
            }
            folderParam.setId(attachmentEntity.getId());
            folderParam.setType("file");
            folderParam.setValue(attachmentEntity.getFileName());
            folderParam.setLabel(1);
        }
        return folderParam;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean delete(@RequestParam(value="id") String id) {
        NetStoreCategoryEntity categoryEntity = (NetStoreCategoryEntity)((Object)this.netStoreCategoryService.getById((Serializable)((Object)id)));
        if (categoryEntity != null) {
            QueryWrapper categoryWrapper = new QueryWrapper();
            categoryWrapper.eq((Object)"parent_id", (Object)categoryEntity.getId());
            List childrenCategory = this.netStoreCategoryService.list((Wrapper)categoryWrapper);
            if (childrenCategory != null && childrenCategory.size() > 0) {
                return false;
            }
            QueryWrapper attachWrapper = new QueryWrapper();
            attachWrapper.eq((Object)"bill_type", (Object)id);
            List attachList = this.attachmentService.list((Wrapper)attachWrapper);
            if (attachList != null && attachList.size() > 0) {
                return false;
            }
            this.netStoreCategoryService.removeById((Serializable)((Object)id));
            return true;
        }
        this.attachmentService.removeById((Serializable)((Object)id));
        return true;
    }

    @RequestMapping(value={"/files"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FolderParam> files(@RequestParam(required=false, value="id") String id, @RequestParam(required=false, value="source") String source, @RequestParam(required=false, value="search") String search) {
        ArrayList<FolderParam> folderParams;
        block15: {
            BillTypeVO billTypeVo;
            block21: {
                List billTypeVoList;
                CommonResponse billTypeResponse;
                List moduleList;
                block20: {
                    Long tenantId;
                    List<AttachmentVO> attachmentVos;
                    block19: {
                        List moduleVoList;
                        block18: {
                            Long tenantId2;
                            List<NetStoreCategoryEntity> categoryEntities;
                            List<FolderParam> storeCategories;
                            block17: {
                                block16: {
                                    block14: {
                                        folderParams = new ArrayList<FolderParam>();
                                        if (!StringUtils.isNotBlank((CharSequence)search)) break block14;
                                        Long tenantId3 = InvocationInfoProxy.getTenantid();
                                        List<AttachmentVO> attachmentVos2 = this.attachmentService.queryListByBillType(null, tenantId3, search);
                                        if (attachmentVos2 == null || attachmentVos2.size() <= 0) break block15;
                                        for (AttachmentVO attachmentVo : attachmentVos2) {
                                            FolderParam folderParam = new FolderParam();
                                            folderParam.setId(attachmentVo.getId());
                                            folderParam.setValue(attachmentVo.getFileName());
                                            folderParam.setFileId(attachmentVo.getId());
                                            String filePath = this.baseHost + "ejc-file-web/attachment/no_auth/download?fileId=" + attachmentVo.getId();
                                            folderParam.setFilePath(filePath);
                                            folderParam.setSize(attachmentVo.getFileSize());
                                            folderParam.setLabel(1);
                                            folderParam.setQueryFrom("recent");
                                            folderParam.setDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)attachmentVo.getCreateTime()));
                                            String fileType = attachmentVo.getFileName().substring(attachmentVo.getFileName().lastIndexOf(".") + 1);
                                            folderParam.setType(this.getType(fileType));
                                            folderParam.setStar(attachmentVo.getStar());
                                            folderParams.add(folderParam);
                                        }
                                        break block15;
                                    }
                                    if ((!"/".equals(id) || !"favorite".equals(source)) && !"favorite".equals(id)) break block16;
                                    String userCode = InvocationInfoProxy.getUsercode();
                                    List<AttachmentVO> attachmentList = this.attachmentService.queryMyFavoriteList(userCode, null);
                                    if (attachmentList == null || attachmentList.size() <= 0) break block15;
                                    for (AttachmentVO attachmentVo : attachmentList) {
                                        FolderParam folderParam = new FolderParam();
                                        folderParam.setId(attachmentVo.getId());
                                        folderParam.setValue(attachmentVo.getFileName());
                                        folderParam.setFileId(attachmentVo.getId());
                                        String filePath = this.baseHost + "ejc-file-web/attachment/no_auth/download?fileId=" + attachmentVo.getId();
                                        folderParam.setFilePath(filePath);
                                        folderParam.setSize(attachmentVo.getFileSize());
                                        folderParam.setLabel(1);
                                        folderParam.setQueryFrom("favorite");
                                        folderParam.setDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)attachmentVo.getCreateTime()));
                                        String fileType = attachmentVo.getFileName().substring(attachmentVo.getFileName().lastIndexOf(".") + 1);
                                        folderParam.setType(this.getType(fileType));
                                        folderParam.setStar(attachmentVo.getStar());
                                        folderParams.add(folderParam);
                                    }
                                    break block15;
                                }
                                if ((!"/".equals(id) || !"recent".equals(source)) && !"recent".equals(id)) break block17;
                                String userCode = InvocationInfoProxy.getUsercode();
                                List<AttachmentVO> attachmentList = this.attachmentService.queryRecentList(userCode, null);
                                if (attachmentList == null || attachmentList.size() <= 0) break block15;
                                for (AttachmentVO attachmentVo : attachmentList) {
                                    FolderParam folderParam = new FolderParam();
                                    folderParam.setId(attachmentVo.getId());
                                    folderParam.setValue(attachmentVo.getFileName());
                                    folderParam.setFileId(attachmentVo.getId());
                                    String filePath = this.baseHost + "ejc-file-web/attachment/no_auth/download?fileId=" + attachmentVo.getId();
                                    folderParam.setFilePath(filePath);
                                    folderParam.setSize(attachmentVo.getFileSize());
                                    folderParam.setLabel(1);
                                    folderParam.setQueryFrom("recent");
                                    folderParam.setDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)attachmentVo.getCreateTime()));
                                    String fileType = attachmentVo.getFileName().substring(attachmentVo.getFileName().lastIndexOf(".") + 1);
                                    folderParam.setType(this.getType(fileType));
                                    folderParam.setStar(attachmentVo.getStar());
                                    folderParams.add(folderParam);
                                }
                                break block15;
                            }
                            if (!"/".equals(id)) break block18;
                            CommonResponse moduleResponse = this.moduleApi.queryModuleTree();
                            if (moduleResponse.isSuccess()) {
                                List moduleVoList2 = (List)moduleResponse.getData();
                                List<FolderParam> moduleParams = NetStoreAsTree.createModuleTreeDataVO(moduleVoList2);
                                FolderParam folderParam = new FolderParam();
                                folderParam.setId(20230109L);
                                folderParam.setType("folder");
                                folderParam.setValue("\u4e1a\u52a1\u6587\u6863");
                                folderParam.setLabel(2);
                                folderParam.setData(moduleParams);
                                folderParams.add(folderParam);
                            }
                            if ((storeCategories = NetStoreAsTree.createTreeDataVO(categoryEntities = this.netStoreCategoryService.queryStoreCategoryList(tenantId2 = InvocationInfoProxy.getTenantid()))) == null || storeCategories.size() <= 0) break block15;
                            folderParams.addAll(storeCategories);
                            break block15;
                        }
                        if (!"20230109".equals(id)) break block19;
                        CommonResponse moduleResponse = this.moduleApi.queryAllTopModuleList();
                        if (!moduleResponse.isSuccess() || (moduleVoList = (List)moduleResponse.getData()) == null || moduleVoList.size() <= 0) break block15;
                        for (ModuleVO moduleVo : moduleVoList) {
                            FolderParam folderParam = new FolderParam();
                            folderParam.setId(moduleVo.getId());
                            folderParam.setType("folder");
                            folderParam.setValue(moduleVo.getModuleName());
                            folderParam.setLabel(2);
                            folderParams.add(folderParam);
                        }
                        break block15;
                    }
                    NetStoreCategoryEntity categoryEntity = (NetStoreCategoryEntity)((Object)this.netStoreCategoryService.getById((Serializable)((Object)id)));
                    if (categoryEntity == null) break block20;
                    QueryWrapper categoryWrapper = new QueryWrapper();
                    categoryWrapper.eq((Object)"parent_id", (Object)categoryEntity.getId());
                    List childCategoryList = this.netStoreCategoryService.list((Wrapper)categoryWrapper);
                    if (childCategoryList != null && childCategoryList.size() > 0) {
                        for (NetStoreCategoryEntity entity : childCategoryList) {
                            FolderParam folderParam = new FolderParam();
                            folderParam.setId(entity.getId());
                            folderParam.setParentId(entity.getParentId());
                            folderParam.setType("folder");
                            folderParam.setValue(entity.getCategoryName());
                            folderParam.setLabel(1);
                            folderParams.add(folderParam);
                        }
                    }
                    if ((attachmentVos = this.attachmentService.queryListByBillType(id, tenantId = InvocationInfoProxy.getTenantid(), null)) == null || attachmentVos.size() <= 0) break block15;
                    for (AttachmentVO attachmentVo : attachmentVos) {
                        FolderParam folderParam = new FolderParam();
                        folderParam.setId(attachmentVo.getId());
                        folderParam.setValue(attachmentVo.getFileName());
                        folderParam.setFileId(attachmentVo.getId());
                        String filePath = this.baseHost + "ejc-file-web/attachment/no_auth/download?fileId=" + attachmentVo.getId();
                        folderParam.setFilePath(filePath);
                        folderParam.setSize(Long.parseLong(attachmentVo.getFileSize() + ""));
                        folderParam.setLabel(1);
                        folderParam.setDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)attachmentVo.getCreateTime()));
                        String fileType = attachmentVo.getFileName().substring(attachmentVo.getFileName().lastIndexOf(".") + 1);
                        folderParam.setType(this.getType(fileType));
                        folderParam.setStar(attachmentVo.getStar());
                        folderParams.add(folderParam);
                    }
                    break block15;
                }
                CommonResponse moduleResponse = this.moduleApi.getModuleById(Long.valueOf(Long.parseLong(id)));
                if (!moduleResponse.isSuccess()) break block15;
                ModuleVO moduleVo = (ModuleVO)moduleResponse.getData();
                if (moduleVo == null || moduleVo.getId() == null) break block21;
                CommonResponse childModuleResponse = this.moduleApi.queryModuleListByPid(moduleVo.getId());
                if (childModuleResponse.isSuccess() && (moduleList = (List)childModuleResponse.getData()) != null && moduleList.size() > 0) {
                    for (Object childModule : moduleList) {
                        if (moduleVo.getId().equals(childModule.getId())) continue;
                        FolderParam folderParam = new FolderParam();
                        folderParam.setId(childModule.getId());
                        folderParam.setParentId(childModule.getParentId());
                        folderParam.setType("folder");
                        folderParam.setValue(childModule.getModuleName());
                        folderParam.setLabel(2);
                        folderParams.add(folderParam);
                    }
                }
                if (!(billTypeResponse = this.billTypeApi.queryBillTypeByModuleId(moduleVo.getId())).isSuccess() || (billTypeVoList = (List)billTypeResponse.getData()) == null || billTypeVoList.size() <= 0) break block15;
                for (BillTypeVO billTypeVo2 : billTypeVoList) {
                    FolderParam folderParam = new FolderParam();
                    folderParam.setId(billTypeVo2.getId());
                    folderParam.setParentId(billTypeVo2.getModuleId());
                    folderParam.setType("folder");
                    folderParam.setValue(billTypeVo2.getBillName());
                    folderParam.setLabel(2);
                    folderParams.add(folderParam);
                }
                break block15;
            }
            CommonResponse billTypeResponse = this.billTypeApi.getById(Long.valueOf(Long.parseLong(id)));
            if (billTypeResponse.isSuccess() && (billTypeVo = (BillTypeVO)billTypeResponse.getData()) != null) {
                Long tenantId = InvocationInfoProxy.getTenantid();
                List<AttachmentVO> attachmentVos = this.attachmentService.queryListByBillType(billTypeVo.getBillCode(), tenantId, null);
                if (attachmentVos != null && attachmentVos.size() > 0) {
                    for (AttachmentVO attachmentVo : attachmentVos) {
                        FolderParam folderParam = new FolderParam();
                        folderParam.setId(attachmentVo.getId());
                        folderParam.setValue(attachmentVo.getFileName());
                        folderParam.setFileId(attachmentVo.getId());
                        String filePath = this.baseHost + "ejc-file-web/attachment/no_auth/download?fileId=" + attachmentVo.getId();
                        folderParam.setFilePath(filePath);
                        folderParam.setSize(Long.parseLong(attachmentVo.getFileSize() + ""));
                        folderParam.setLabel(2);
                        folderParam.setDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)attachmentVo.getCreateTime()));
                        String fileType = attachmentVo.getFileName().substring(attachmentVo.getFileName().lastIndexOf(".") + 1);
                        folderParam.setType(this.getType(fileType));
                        folderParam.setStar(attachmentVo.getStar());
                        folderParams.add(folderParam);
                    }
                }
            }
        }
        return folderParams;
    }

    @RequestMapping(value={"info"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONObject info() {
        JSONObject info = new JSONObject();
        JSONObject features = new JSONObject();
        JSONObject meta = new JSONObject();
        meta.putIfAbsent((Object)"audio", (Object)true);
        meta.putIfAbsent((Object)"image", (Object)true);
        features.putIfAbsent((Object)"meta", (Object)meta);
        JSONObject preview = new JSONObject();
        preview.putIfAbsent((Object)"code", (Object)true);
        preview.putIfAbsent((Object)"document", (Object)true);
        preview.putIfAbsent((Object)"image", (Object)true);
        features.putIfAbsent((Object)"preview", (Object)preview);
        info.putIfAbsent((Object)"features", (Object)features);
        return info;
    }

    @RequestMapping(value={"meta"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONObject meta(@RequestParam(value="id") String id) {
        AttachmentEntity attachmentEntity = (AttachmentEntity)((Object)this.attachmentService.getById((Serializable)((Object)id)));
        JSONObject info = new JSONObject();
        info.putIfAbsent((Object)"\u521b\u5efa\u4eba", (Object)attachmentEntity.getCreateUserCode());
        info.putIfAbsent((Object)"\u521b\u5efa\u65f6\u95f4", (Object)attachmentEntity.getCreateTime());
        return info;
    }

    @RequestMapping(value={"comments"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray comments(@RequestParam(value="id") String id) {
        return new JSONArray();
    }

    @RequestMapping(value={"tags"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray tags(@RequestParam(value="id") String id) {
        return new JSONArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"upload"}, method={RequestMethod.POST})
    @ResponseBody
    public FolderParam upload(@RequestParam(value="id") String id, HttpServletRequest request) {
        FolderParam folderParam = new FolderParam();
        String billType = id;
        String sourceId = id;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MultipartFile> fileList = new ArrayList<MultipartFile>();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile mf = (MultipartFile)entity.getValue();
            String originalFilename = mf.getOriginalFilename();
            if (mf.getSize() == 0L) {
                throw new BusinessException("\u4e0a\u4f20\u4e86\u7a7a\u6587\u4ef6");
            }
            originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFilename.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFilename, (Boolean)false);
            if (this.fileExtInBlackList(extName)) {
                throw new BusinessException("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
            }
            Integer sizeLimit = this.minioConfiguration.getSizeLimit();
            if (mf.getSize() > (long)sizeLimit.intValue()) {
                throw new BusinessException("\u4e0a\u4f20\u4e86\u5927\u4e8e\u9650\u5b9a\u5927\u5c0f\u7684\u6587\u4ef6");
            }
            fileList.add(mf);
        }
        InputStream mfInputStream = null;
        try {
            ArrayList<AttachmentEntity> resultEntity = new ArrayList<AttachmentEntity>();
            for (MultipartFile mf : fileList) {
                String bucketName = this.minioConfiguration.getBucketName();
                SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                String fileName = mf.getOriginalFilename();
                String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
                originalFilename.replaceAll("00.", "");
                String extName = FileUtils.getFileExt((String)originalFilename, (Boolean)false);
                String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
                mfInputStream = mf.getInputStream();
                ObjectWriteResponse objectResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(mfInputStream, (long)mfInputStream.available(), (long)MinioCommonConts.DEFAULT_PART_SIZE.intValue()).build());
                if (!StringUtils.isNotBlank((CharSequence)objectResponse.etag())) continue;
                AttachmentVO attachment = new AttachmentVO();
                attachment.setBillType(billType);
                if (StringUtils.isNotBlank((CharSequence)sourceId)) {
                    attachment.setSourceId(Long.valueOf(Long.parseLong(sourceId)));
                }
                attachment.setSourceType("netstore");
                attachment.setFileName(fileName);
                attachment.setFilePath(objectName);
                attachment.setFileSize(Long.valueOf(mf.getSize()));
                Long userId = InvocationInfoProxy.getUserid();
                CommonResponse employeeResponse = this.employeeApi.queryEmployeByUserId(userId);
                if (employeeResponse.isSuccess()) {
                    attachment.setUploadUserName(((EmployeeVO)employeeResponse.getData()).getName());
                }
                AttachmentEntity entity = (AttachmentEntity)((Object)BeanMapper.map((Object)attachment, AttachmentEntity.class));
                this.attachmentService.saveOrUpdate((Object)entity, false);
                resultEntity.add(entity);
                folderParam.setId(entity.getId());
                folderParam.setValue(entity.getFileName());
                folderParam.setFileId(entity.getId());
                String filePath = this.baseHost + "ejc-file-web/attachment/no_auth/download?fileId=" + entity.getId();
                folderParam.setFilePath(filePath);
                folderParam.setSize(Long.parseLong(entity.getFileSize() + ""));
                folderParam.setDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)entity.getCreateTime()));
                String fileType = entity.getFileName().substring(entity.getFileName().lastIndexOf(".") + 1);
                folderParam.setType(this.getType(fileType));
                FolderParam folderParam2 = folderParam;
                return folderParam2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (mfInputStream != null) {
                try {
                    mfInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @RequestMapping(value={"favorite"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONObject AddFavorite(@RequestParam(value="id") String id, @RequestParam(value="type") String type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"file_id", (Object)id);
        queryWrapper.eq((Object)"create_user_code", (Object)InvocationInfoProxy.getUsercode());
        List myFavoriteEntities = this.myFavoriteService.list((Wrapper)queryWrapper);
        if (myFavoriteEntities != null && myFavoriteEntities.size() > 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.putIfAbsent((Object)"id", (Object)id);
            jsonObject.putIfAbsent((Object)"error", (Object)"");
            jsonObject.putIfAbsent((Object)"invalid", (Object)false);
            return jsonObject;
        }
        MyFavoriteEntity entity = new MyFavoriteEntity();
        entity.setFileId(Long.parseLong(id));
        entity.setFileType(type);
        this.myFavoriteService.saveOrUpdate((Object)entity, false);
        JSONObject jsonObject = new JSONObject();
        jsonObject.putIfAbsent((Object)"id", (Object)id);
        jsonObject.putIfAbsent((Object)"error", (Object)"");
        jsonObject.putIfAbsent((Object)"invalid", (Object)false);
        return jsonObject;
    }

    @RequestMapping(value={"delfavorite"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONObject delFavorite(@RequestParam(value="id") String id) {
        QueryParam param = new QueryParam();
        param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        param.getParams().put("fileId", new Parameter("eq", (Object)id));
        List favoriteEntities = this.myFavoriteService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)favoriteEntities)) {
            favoriteEntities.forEach(f -> this.myFavoriteService.removeById(f.getId()));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.putIfAbsent((Object)"id", (Object)id);
        jsonObject.putIfAbsent((Object)"error", (Object)"");
        jsonObject.putIfAbsent((Object)"invalid", (Object)false);
        return jsonObject;
    }

    @RequestMapping(value={"addRecent"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean addRecent(@RequestParam(value="fileId") String fileId) {
        QueryWrapper viewLogWrapper = new QueryWrapper();
        viewLogWrapper.eq((Object)"file_id", (Object)fileId);
        viewLogWrapper.eq((Object)"create_user_code", (Object)InvocationInfoProxy.getUsercode());
        List viewLogEntities = this.viewLogService.list((Wrapper)viewLogWrapper);
        if (viewLogEntities != null && viewLogEntities.size() > 0) {
            return true;
        }
        ViewLogEntity viewLogEntity = new ViewLogEntity();
        viewLogEntity.setFileId(Long.parseLong(fileId));
        AttachmentEntity attachmentEntity = (AttachmentEntity)((Object)this.attachmentService.getById((Serializable)((Object)fileId)));
        String fileType = attachmentEntity.getFileName().substring(attachmentEntity.getFileName().lastIndexOf(".") + 1);
        viewLogEntity.setFileType(this.getType(fileType));
        this.viewLogService.save((Object)viewLogEntity);
        return true;
    }

    @RequestMapping(value={"users/all"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray usersAll() {
        return new JSONArray();
    }

    @RequestMapping(value={"tags/all"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray tagsAll() {
        return new JSONArray();
    }

    private boolean fileExtInBlackList(String fileExt) {
        String blackFileExt = this.minioConfiguration.getBlackFileExt();
        if (StringUtils.isNotEmpty((CharSequence)blackFileExt) && fileExt != null) {
            String[] blackFileExtArr;
            for (String blackExt : blackFileExtArr = blackFileExt.split(",")) {
                if (!fileExt.equals(blackExt)) continue;
                return true;
            }
        }
        return false;
    }

    private String getType(String fileName) {
        String type = "txt".equals(fileName.toLowerCase()) ? "code" : ("xls".equals(fileName.toLowerCase()) || "xlsx".equals(fileName.toLowerCase()) || "bat".equals(fileName.toLowerCase()) || "doc".equals(fileName.toLowerCase()) || "docx".equals(fileName.toLowerCase()) || "zip".equals(fileName.toLowerCase()) || "csv".equals(fileName.toLowerCase()) || "exe".equals(fileName.toLowerCase()) || "jar".equals(fileName.toLowerCase()) || "log".equals(fileName.toLowerCase()) || "msi".equals(fileName.toLowerCase()) || "iso".equals(fileName.toLowerCase()) || "pdf".equals(fileName.toLowerCase()) || "rar".equals(fileName.toLowerCase()) || "swf".equals(fileName.toLowerCase()) || "ppt".equals(fileName.toLowerCase()) || "pptx".equals(fileName.toLowerCase()) ? "document" : ("mp3".equals(fileName.toLowerCase()) || "wma".equals(fileName.toLowerCase()) || "aac".equals(fileName.toLowerCase()) ? "audio" : ("3gp".equals(fileName.toLowerCase()) || "mp4".equals(fileName.toLowerCase()) || "avi".equals(fileName.toLowerCase()) || "mkv".equals(fileName.toLowerCase()) || "rm".equals(fileName.toLowerCase()) || "rmvb".equals(fileName.toLowerCase()) || "mov".equals(fileName.toLowerCase()) || "mod".equals(fileName.toLowerCase()) || "wmv".equals(fileName.toLowerCase()) || "ogg".equals(fileName.toLowerCase()) ? "video" : ("jpg".equals(fileName.toLowerCase()) || "png".equals(fileName.toLowerCase()) || "gif".equals(fileName.toLowerCase()) || "jpeg".equals(fileName.toLowerCase()) || "bmp".equals(fileName.toLowerCase()) ? "image" : "unknown"))));
        return type;
    }
}

