package com.ejianc.foundation.file.service;

import java.io.InputStream;
import java.util.List;

import com.ejianc.foundation.file.bean.AttachmentEntity;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.WaterMarketConfigVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IAttachmentService extends IBaseService<AttachmentEntity> {

	/**
	 * 修改附件业务关联
	 * 
	 * @param sourceId
	 * @param attachIds
	 */
	void updateAttachRef(Long sourceId, List<Long> attachIds);

	/**
	 * 根据主键查询bean
	 * 
	 * @param fileId
	 * @return
	 */
	AttachmentVO selectById(String fileId);

	/**
	 *
	 * 保存缩略图
	 *
	 * */
	InputStream getThumbnailPath(AttachmentEntity entity);

	/**
	 * 根据fileIds查询附件List
	 * 
	 * @param fileIds
	 * @return
	 */
	List<AttachmentVO> queryListByIds(String fileIds);

	/**
	 * 根据ids删除附件（包括oss服务器中的文件）
	 * 
	 * @param ids
	 * @return
	 */
	CommonResponse<String> delete(String ids);

	/**
	 * 根据传参查询附件List
	 * 
	 * @param 
	 * @return
	 */
	List<AttachmentVO> queryListByParams(QueryParam queryParam);

	/**
	 * 更新附件归档状态
	 *
	 * @param attachIds
	 * @param status
	 */
    void updateAttachArchiveStatus(List<Long> attachIds, String status);

	/**
	 * 查询匹配的附件列表
	 *
	 * @param tenantId
	 * @param sourceId
	 * @param sourceType
	 * @param billType
	 * @return
	 */
    List<AttachmentVO> findFileList(Long tenantId, String sourceId, String sourceType, String billType);

    /**
     * 根据参数删除附件
     * 
     * @param sourceId
     * @param billType
     * @param sourceType
     * @param fileName
     */
	void deleteFileByParams(Long sourceId, String billType, String sourceType, List<String> fileNames);

	/**
	 * 根据参数删除附件
	 *
	 * @param sourceId
	 * @param billType
	 * @param sourceType
	 */
	void deleteFileByParam(Long sourceId, String billType, String sourceType);

	/**
	 * 文件批量保存
	 *
	 * @param resultEntity 待保存文件信息
	 * @param clearBeforeSave 是否保存前删除已有对应类型文件信息
	 */
	void saveOrUpdateFileList(List<AttachmentEntity> resultEntity, Boolean clearBeforeSave);

	String makeWatermarkToFile(Long fileId, String watermarkText, String waterWay);

	/**
	 * 查询我的收藏
	 * 
	 * @param userCode
	 * @return
	 */
	List<AttachmentVO> queryMyFavoriteList(String userCode, String search);

	/**
	 * 查询我最近访问
	 * 
	 * @param userCode
	 * @return
	 */
	List<AttachmentVO> queryRecentList(String userCode, String search);

	/**
	 * 查询单据类型下的所有附件
	 * 
	 * @param billCode
	 * @param tenantId
	 * @return
	 */
	List<AttachmentVO> queryListByBillType(String billCode, Long tenantId, String search);

	/**
	 * 扩展css记录
	 * 
	 * @param fileId
	 * @param extcss
	 */
	void updateFileCss(String fileId, String extcss);

	/**
	 * 查询文件css记录
	 * 
	 * @param fileId
	 * @return
	 */
	String queryFileCss(String fileId);

    AttachmentVO addWaterMarket(WaterMarketConfigVO waterMarketConfig);

	List<AttachmentVO> queryAllByIds(List<Long> fileIds);

	Integer queryPageNumber(Long fileId);

	List<AttachmentVO> uploadByUrl(List<AttachmentVO> vos);

	/**
	 * 文件转化为图片并保存
	 * @param attachIds
	 */
	List<AttachmentVO> fileToImg(List<AttachmentVO> attaches, String imeType, Integer imgDpi, String imgSourceType);

}
