package com.ejianc.foundation.file.service.impl;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import com.ejianc.foundation.file.config.MinioCommonConts;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.web.multipart.MultipartFile;

import com.aspose.words.Document;
import com.aspose.words.FontSettings;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterType;
import com.aspose.words.HorizontalAlignment;
import com.aspose.words.NodeCollection;
import com.aspose.words.Paragraph;
import com.aspose.words.RelativeHorizontalPosition;
import com.aspose.words.RelativeVerticalPosition;
import com.aspose.words.SaveFormat;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.*;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.mapper.AttachmentMapper;
import com.ejianc.foundation.file.model.FileAttribute;
import com.ejianc.foundation.file.service.FilePreview;
import com.ejianc.foundation.file.util.FileUtils;
import com.ejianc.foundation.file.util.OfficeToPdf;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.awt.*;
import java.io.*;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Content :处理office文件
 */
@Service
public class OfficeFilePreviewImpl implements FilePreview {
	private Logger logger = LoggerFactory.getLogger(getClass());
	
    @Autowired
    FileUtils fileUtils;
    @Autowired
    private OfficeToPdf officeToPdf;
    @Autowired
    private AttachmentMapper attachmentMapper;
	@Autowired
	private MinioClient minioClient;
	@Autowired
	private MinioConfiguration minioConfiguration;
	@Value("${common.env.base-host:#{null}}")
	private String baseHost;

	@Override
    public String filePreviewHandle(HttpServletRequest req, AttachmentVO attach, Model model) {
		String watermarkText = req.getParameter("watermarkText");
		String waterWay = req.getParameter("waterWay");

    	FileAttribute fileAttribute=fileUtils.getFileAttribute(attach.getFilePath());
    	String suffix=fileAttribute.getSuffix();
    	String fileName=fileAttribute.getName();
		String newFileSuffix = "pdf";
		String newUrl= "";
    	String pdfName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + "pdf";
    	// 判断之前是否已转换过，如果转换过，直接返回，否则执行转换
    	InputStream in = null;
    	ByteArrayOutputStream bos = null;
    	ByteArrayInputStream bis = null;
    	InputStream fileInputStream = null;
    	try {
    		if(StringUtils.isNotBlank(attach.getOnlinePath())){
//    			newUrl = fileUtils.getUrl(attach.getOnlinePath()).toString();//有权限
    			if(attach.getOnlinePath().indexOf("http") != -1) {
    				newUrl = attach.getOnlinePath() + "?attachid="+attach.getId();
    			}else{
					newUrl = baseHost + "ejc-file-web/attachment/filePreview?filePath=" + attach.getOnlinePath();
    			}
    		}else{
				if(attach.getFilePath().contains("http")) {
					// 从远程URL下载文件
					URL url = new URL(attach.getFilePath());
					in = url.openStream(); // 打开输入流
				}else {
					in = fileUtils.downloadFileByKeyName(attach.getFilePath());
				}
        		bos = new ByteArrayOutputStream();
        		
        		Boolean convertFlag = false;
        		if("doc".equals(suffix) || "docx".equals(suffix) || "wps".equals(suffix)) {
        			BufferedInputStream bufferedInputStream = null;
        			try {
        				FontSettings fontSetting = FontSettings.getDefaultInstance();
        				fontSetting.setFontsFolder("/usr/share/fonts/", false);
        				bufferedInputStream = new BufferedInputStream(in);
        				Document document = new Document(bufferedInputStream);
        				document.setFontSettings(fontSetting);
        				document.acceptAllRevisions();
        				if (StringUtils.isNotBlank(watermarkText)) {
							if("single".equals(waterWay)){
								insertWatermarkText(document, watermarkText);
							}else if("more".equals(waterWay)) {
								insertWaterMarks(document, watermarkText);
							}
						}
        				document.save(bos, SaveFormat.PDF);
        			}catch(Exception e){
        				logger.info("文件转换失败："+e.getMessage());
        				return "fileNotSupported";
        			}finally {
        				if (bufferedInputStream != null) {
                            try {
                                bufferedInputStream.close();
                            } catch (IOException ignored) {
                                System.out.println("关闭流异常" + ignored);
                            }
                        }
        			}
        			convertFlag = true;
        		}else{
        			convertFlag = officeToPdf.converterFile(in, suffix, bos, newFileSuffix);
        		}
        		
        		if(convertFlag) {
        			bis = new ByteArrayInputStream(bos.toByteArray());
        			MultipartFile multipartFile = new MockMultipartFile(pdfName, bis);
        			
        			SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        			String objectName = attach.getFilePath().split("/")[0] + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + newFileSuffix;
					fileInputStream = multipartFile.getInputStream();
					minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(fileInputStream, fileInputStream.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());

					newUrl = baseHost + "ejc-file-web/attachment/filePreview?filePath=" + objectName;
					attachmentMapper.updateOnlinePath(attach.getFilePath(), objectName);
        		}else{
        			logger.info("文件转换失败");
    				return "fileNotSupported";
        		}
    		}
    		if(StringUtils.isBlank(newUrl)) {
    			return "fileNotSupported";
    		}
    		logger.info("pdfUrl123222 ======" + newUrl);
    		model.addAttribute("pdfUrl", newUrl);
		} catch (Exception e) {
			logger.info("文件转换失败："+e.getMessage());
			return "fileNotSupported";
		}finally{
			try {
				if(in != null) {
					in.close();
				}
				if(bos != null) {
					bos.flush();
					bos.close();
				}
				if(bis != null) {
					bis.close();
				}
				if(fileInputStream != null) {
					fileInputStream.close();
				}
			}catch(Exception e) {
				e.printStackTrace();
			}
		}
    	
		return "mobilepdf";
    }
	
	private static void insertWatermarkText(Document doc, String watermarkText) throws Exception {
		System.out.println("开始添加水印...");
		Shape watermark = new Shape(doc, ShapeType.TEXT_PLAIN_TEXT);
		// 水印内容
		watermark.getTextPath().setText(watermarkText);
		// 水印字体
		watermark.getTextPath().setFontFamily("宋体");
		// 水印宽度
		watermark.setWidth(500);
		// 水印高度
		watermark.setHeight(100);
		// 旋转水印
		watermark.setRotation(-40);
		// 水印颜色
		watermark.getFill().setColor(Color.lightGray);
		watermark.setStrokeColor(Color.lightGray);

		watermark.setRelativeHorizontalPosition(RelativeHorizontalPosition.PAGE);
		watermark.setRelativeVerticalPosition(RelativeVerticalPosition.PAGE);
		watermark.setWrapType(WrapType.NONE);
		watermark.setVerticalAlignment(VerticalAlignment.CENTER);
		watermark.setHorizontalAlignment(HorizontalAlignment.CENTER);

		Paragraph watermarkPara = new Paragraph(doc);
		watermarkPara.appendChild(watermark);

		for (Section sect : doc.getSections()) {
			insertWatermarkIntoHeader(watermarkPara, sect, HeaderFooterType.HEADER_PRIMARY);
			insertWatermarkIntoHeader(watermarkPara, sect, HeaderFooterType.HEADER_FIRST);
			insertWatermarkIntoHeader(watermarkPara, sect, HeaderFooterType.HEADER_EVEN);
		}
		System.out.println("结束添加水印...");
	}

	private static void insertWatermarkIntoHeader(Paragraph watermarkPara, Section sect, int headerType)
			throws Exception {
		HeaderFooter header = sect.getHeadersFooters().getByHeaderFooterType(headerType);
		if (header == null) {
			header = new HeaderFooter(sect.getDocument(), headerType);
			sect.getHeadersFooters().add(header);
		}
		header.appendChild(watermarkPara.deepClone(true));
	}

	/**
	 * 插入多个水印
	 *
	 * @param doc
	 * @param waterMark
	 * @throws Exception
	 */
	public static void insertWaterMarks(Document doc, String waterMark) throws Exception {
		Paragraph watermarkPara = new Paragraph(doc);
		for (int j = 0; j < 500; j = j + 200) {
			for (int i = 0; i < 700; i = i + 200) {
				Shape waterShape = ShapeMore(doc, waterMark, j-100, i);
				watermarkPara.appendChild(waterShape);
			}
		}
		String text = watermarkPara.getText();
		System.out.println("++++++++++" + text);
		System.out.println("______________" + watermarkPara);
		NodeCollection<?> childNodes = watermarkPara.getChildNodes();
		String text1 = childNodes.get(0).getText();
		System.out.println("111111" + text1);
		/*
		 * Shape waterShape = ShapeMore(mdoc, wmText, 155, 300);
		 * watermarkPara.appendChild(waterShape);
		 */
		for (Section sect : doc.getSections()) {
			insertWatermarkIntoHeader(watermarkPara, sect, HeaderFooterType.HEADER_PRIMARY);
			insertWatermarkIntoHeader(watermarkPara, sect, HeaderFooterType.HEADER_FIRST);
			insertWatermarkIntoHeader(watermarkPara, sect, HeaderFooterType.HEADER_EVEN);
		}
	}

	/**
	 * 设置水印属性
	 *
	 * @param doc
	 * @param waterMark
	 * @param left
	 * @param top
	 * @return
	 * @throws Exception
	 */
	public static Shape ShapeMore(Document doc, String waterMark, double left, double top) throws Exception {
		Shape waterShape = new Shape(doc, ShapeType.TEXT_PLAIN_TEXT);
		waterShape.getTextPath().setText(waterMark);
		waterShape.getTextPath().setFontFamily("宋体");
		waterShape.setWidth(waterMark.length()*14);
		waterShape.setHeight(10);
		waterShape.setRotation(-30);
		waterShape.setDistanceLeft(0);
		waterShape.setFilled(true);

		waterShape.getFill().setColor(Color.lightGray);
		waterShape.setStrokeColor(Color.lightGray);
		// 将水印放置在页面中心
		waterShape.setLeft(left);
		waterShape.setTop(top);
		// 设置包装类型
		waterShape.setWrapType(WrapType.NONE);
		return waterShape;
	}
}
