package com.ejianc.foundation.file.service.impl;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

import com.ejianc.foundation.file.model.FileAttribute;
import com.ejianc.foundation.file.service.FilePreview;
import com.ejianc.foundation.file.util.FileUtils;
import com.ejianc.foundation.file.vo.AttachmentVO;

/**
 * Content :其他文件
 */
@Service
public class OtherFilePreviewImpl implements FilePreview {
	@Autowired
	FileUtils fileUtils;

	@Override
	public String filePreviewHandle(HttpServletRequest req, AttachmentVO attach, Model model) {
		FileAttribute fileAttribute = fileUtils.getFileAttribute(attach.getFilePath());

		model.addAttribute("fileType", fileAttribute.getSuffix());
		model.addAttribute("msg", "系统还不支持该格式文件的在线预览，" + "如有需要请按下方显示的邮箱地址联系系统维护人员");
		return "fileNotSupported";
	}
}
