/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.service.impl;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.FontSettings;
import com.aspose.words.HeaderFooter;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.Paragraph;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.mapper.AttachmentMapper;
import com.ejianc.foundation.file.model.FileAttribute;
import com.ejianc.foundation.file.service.FilePreview;
import com.ejianc.foundation.file.util.FileUtils;
import com.ejianc.foundation.file.util.OfficeToPdf;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class OfficeFilePreviewImpl
implements FilePreview {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    FileUtils fileUtils;
    @Autowired
    private OfficeToPdf officeToPdf;
    @Autowired
    private AttachmentMapper attachmentMapper;
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioConfiguration minioConfiguration;
    @Value(value="${fileUrl}")
    private String fileUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String filePreviewHandle(HttpServletRequest req, AttachmentVO attach, Model model) {
        String watermarkText = req.getParameter("watermarkText");
        String waterWay = req.getParameter("waterWay");
        FileAttribute fileAttribute = this.fileUtils.getFileAttribute(attach.getFilePath());
        String suffix = fileAttribute.getSuffix();
        String fileName = fileAttribute.getName();
        String newFileSuffix = "pdf";
        String newUrl = "";
        String pdfName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + "pdf";
        InputStream in = null;
        OutputStream bos = null;
        ByteArrayInputStream bis = null;
        InputStream fileInputStream = null;
        try {
            BufferedInputStream bufferedInputStream;
            Object convertFlag;
            if (StringUtils.isNotBlank((CharSequence)attach.getOnlinePath())) {
                newUrl = attach.getOnlinePath().indexOf("http") != -1 ? attach.getOnlinePath() + "?attachid=" + attach.getId() : this.fileUrl + attach.getOnlinePath() + "?attachid=" + attach.getId();
            } else {
                String multipartFile;
                in = this.fileUtils.downloadFileByKeyName(attach.getFilePath());
                bos = new ByteArrayOutputStream();
                convertFlag = false;
                if ("doc".equals(suffix) || "docx".equals(suffix) || "wps".equals(suffix)) {
                    bufferedInputStream = null;
                    try {
                        FontSettings fontSetting = FontSettings.getDefaultInstance();
                        fontSetting.setFontsFolder("/usr/share/fonts/", false);
                        bufferedInputStream = new BufferedInputStream(in);
                        Document document = new Document((InputStream)bufferedInputStream);
                        document.setFontSettings(fontSetting);
                        document.acceptAllRevisions();
                        if (StringUtils.isNotBlank((CharSequence)watermarkText)) {
                            if ("single".equals(waterWay)) {
                                OfficeFilePreviewImpl.insertWatermarkText(document, watermarkText);
                            } else if ("more".equals(waterWay)) {
                                OfficeFilePreviewImpl.insertWaterMarks(document, watermarkText);
                            }
                        }
                        document.save(bos, 40);
                    }
                    catch (Exception e) {
                        this.logger.info("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                        String document = "fileNotSupported";
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (bos != null) {
                                bos.flush();
                                ((ByteArrayOutputStream)bos).close();
                            }
                            if (bis != null) {
                                bis.close();
                            }
                            if (fileInputStream == null) return document;
                            fileInputStream.close();
                            return document;
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        return document;
                    }
                    convertFlag = true;
                } else {
                    convertFlag = this.officeToPdf.converterFile(in, suffix, bos, newFileSuffix);
                }
                if (((Boolean)convertFlag).booleanValue()) {
                    bis = new ByteArrayInputStream(((ByteArrayOutputStream)bos).toByteArray());
                    multipartFile = new MockMultipartFile(pdfName, (InputStream)bis);
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                    String objectName = attach.getFilePath().split("/")[0] + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + newFileSuffix;
                    fileInputStream = multipartFile.getInputStream();
                    this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(fileInputStream, (long)fileInputStream.available(), -1L).build());
                    newUrl = this.fileUrl + objectName + "?attachid=" + attach.getId();
                    this.attachmentMapper.updateOnlinePath(attach.getFilePath(), objectName);
                } else {
                    this.logger.info("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25");
                    multipartFile = "fileNotSupported";
                    return multipartFile;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)newUrl)) {
                newUrl = newUrl.replaceAll("=", "%3d");
                this.logger.info("pdfUrl123222 ======" + newUrl);
                model.addAttribute("pdfUrl", (Object)newUrl);
                return "mobilepdf";
            }
            convertFlag = "fileNotSupported";
            return convertFlag;
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException ignored) {
                        System.out.println("\u5173\u95ed\u6d41\u5f02\u5e38" + ignored);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.info("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            String string = "fileNotSupported";
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (bos != null) {
                    bos.flush();
                    ((ByteArrayOutputStream)bos).close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void insertWatermarkText(Document doc, String watermarkText) throws Exception {
        System.out.println("\u5f00\u59cb\u6dfb\u52a0\u6c34\u5370...");
        Shape watermark = new Shape((DocumentBase)doc, 136);
        watermark.getTextPath().setText(watermarkText);
        watermark.getTextPath().setFontFamily("\u5b8b\u4f53");
        watermark.setWidth(500.0);
        watermark.setHeight(100.0);
        watermark.setRotation(-40.0);
        watermark.getFill().setColor(Color.lightGray);
        watermark.setStrokeColor(Color.lightGray);
        watermark.setRelativeHorizontalPosition(1);
        watermark.setRelativeVerticalPosition(1);
        watermark.setWrapType(3);
        watermark.setVerticalAlignment(2);
        watermark.setHorizontalAlignment(2);
        Paragraph watermarkPara = new Paragraph((DocumentBase)doc);
        watermarkPara.appendChild((Node)watermark);
        for (Section sect : doc.getSections()) {
            OfficeFilePreviewImpl.insertWatermarkIntoHeader(watermarkPara, sect, 1);
            OfficeFilePreviewImpl.insertWatermarkIntoHeader(watermarkPara, sect, 4);
            OfficeFilePreviewImpl.insertWatermarkIntoHeader(watermarkPara, sect, 0);
        }
        System.out.println("\u7ed3\u675f\u6dfb\u52a0\u6c34\u5370...");
    }

    private static void insertWatermarkIntoHeader(Paragraph watermarkPara, Section sect, int headerType) throws Exception {
        HeaderFooter header = sect.getHeadersFooters().getByHeaderFooterType(headerType);
        if (header == null) {
            header = new HeaderFooter(sect.getDocument(), headerType);
            sect.getHeadersFooters().add((Node)header);
        }
        header.appendChild(watermarkPara.deepClone(true));
    }

    public static void insertWaterMarks(Document doc, String waterMark) throws Exception {
        Paragraph watermarkPara = new Paragraph((DocumentBase)doc);
        for (int j = 0; j < 500; j += 200) {
            for (int i = 0; i < 700; i += 200) {
                Shape waterShape = OfficeFilePreviewImpl.ShapeMore(doc, waterMark, j - 100, i);
                watermarkPara.appendChild((Node)waterShape);
            }
        }
        String text = watermarkPara.getText();
        System.out.println("++++++++++" + text);
        System.out.println("______________" + watermarkPara);
        NodeCollection childNodes = watermarkPara.getChildNodes();
        String text1 = childNodes.get(0).getText();
        System.out.println("111111" + text1);
        for (Section sect : doc.getSections()) {
            OfficeFilePreviewImpl.insertWatermarkIntoHeader(watermarkPara, sect, 1);
            OfficeFilePreviewImpl.insertWatermarkIntoHeader(watermarkPara, sect, 4);
            OfficeFilePreviewImpl.insertWatermarkIntoHeader(watermarkPara, sect, 0);
        }
    }

    public static Shape ShapeMore(Document doc, String waterMark, double left, double top) throws Exception {
        Shape waterShape = new Shape((DocumentBase)doc, 136);
        waterShape.getTextPath().setText(waterMark);
        waterShape.getTextPath().setFontFamily("\u5b8b\u4f53");
        waterShape.setWidth((double)(waterMark.length() * 14));
        waterShape.setHeight(10.0);
        waterShape.setRotation(-30.0);
        waterShape.setDistanceLeft(0.0);
        waterShape.setFilled(true);
        waterShape.getFill().setColor(Color.lightGray);
        waterShape.setStrokeColor(Color.lightGray);
        waterShape.setLeft(left);
        waterShape.setTop(top);
        waterShape.setWrapType(3);
        return waterShape;
    }
}

