package com.ejianc.foundation.file.config;

import com.ejianc.framework.core.util.EnvironmentTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;

/**
 * @Author: caojie
 * @CreateTime:2025-03-19 14:47
 * @Version: 1.0
 */
@Configuration
@EnableAsync
@ConfigurationProperties(prefix = "async.pdf")
public class TaskConfig {

    @Autowired
    private EnvironmentTools environmentTools;

    @Bean(name = "pdfTaskExecutor")
    public Executor pdfTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        //核心线程池大小
        executor.setCorePoolSize(2);
        //最大线程数
        executor.setMaxPoolSize(8);
        //队列容量
        executor.setQueueCapacity(50);
        executor.setThreadNamePrefix("pdf-processor-");
        //活跃时间
        executor.setKeepAliveSeconds(60);
        executor.setTaskDecorator(new ThreadContextDecorator(environmentTools.getBaseHost(), false));
        executor.initialize();
        return executor;
    }

}
