package com.ejianc.foundation.file.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

import com.ejianc.foundation.file.service.FilePreview;
import com.ejianc.foundation.file.vo.AttachmentVO;

/**
 * Content :图片文件处理
 */
@Service
public class PictureFilePreviewImpl implements FilePreview {
	@Value("${fileUrl}")
    private String fileUrl;

	@Override
	public String filePreviewHandle(HttpServletRequest req, AttachmentVO attach, Model model) {
		List<String> imgUrls = new ArrayList<>();
		String imgUrl = null;
		String url = attach.getFilePath();
		if(url.indexOf("http") != -1) {
			imgUrl = url;
		}else{
			imgUrl = fileUrl+url;
		}
		imgUrls.add(imgUrl);
		model.addAttribute("imgurls", imgUrls);
		model.addAttribute("currentUrl", imgUrl);
		return "picture";

	}
}
