/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Style;
import com.aspose.cells.Workbook;
import com.aspose.pdf.Document;
import com.aspose.words.FontSettings;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.bean.AttachmentEntity;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.define.BASE64MultipartFile;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.service.impl.PoiExcelToHtmlImpl;
import com.ejianc.foundation.file.util.MqQueueUtils;
import com.ejianc.foundation.file.util.MyX509TrustManager;
import com.ejianc.foundation.file.util.OfficeToPdf;
import com.ejianc.foundation.file.util.PdfProcessor;
import com.ejianc.foundation.file.util.ZipCompress;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.support.idworker.util.IdWorker;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"attachment"})
public class AttachmentController {
    private static Logger logger = LoggerFactory.getLogger(AttachmentController.class);
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioConfiguration minioConfiguration;
    @Autowired
    private IAttachmentService attachmentService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private com.ejianc.foundation.file.util.FileUtils fileUtils;
    @Autowired
    private IThirdSystemApi thirdSystemApi;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private OfficeToPdf officeToPdf;
    @Value(value="${fileUrl}")
    private String fileUrl;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private PdfProcessor pdfProcessor;
    @Autowired
    private MqQueueUtils mqQueueUtils;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    private final Integer DEFAULT_PART_SIZE = 0x8000000;

    @PostMapping(value={"queryBatchPrintImgFiles"})
    @ResponseBody
    public CommonResponse<Map<String, List<String>>> queryBatchPrintImgFiles(@RequestBody JSONObject param) {
        QueryParam queryParam = new QueryParam();
        Map<Object, Object> resp = new HashMap();
        if (null == param.get((Object)"sourceIds") && null == param.get((Object)"sourceTypes") && null == param.get((Object)"ids")) {
            return CommonResponse.error((String)"sourceIds\u3001sourceTypes\u3001ids\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (null != param.get((Object)"sourceIds")) {
            List sourceIdList = JSONArray.parseArray((String)param.getString("sourceIds"), Long.class);
            queryParam.getParams().put("source_id", Parameter.getInInstance((Object)sourceIdList));
        }
        if (null != param.get((Object)"sourceTypes")) {
            List<String> sourceTypes = Arrays.asList(StringUtils.split((String)param.getString("sourceTypes"), (String)","));
            queryParam.getParams().put("source_type", Parameter.getInInstance(sourceTypes));
        }
        if (null != param.get((Object)"ids")) {
            List ids = JSONArray.parseArray((String)param.getString("ids"), Long.class);
            queryParam.getParams().put("id", Parameter.getInInstance((Object)ids));
        }
        queryParam.getOrderMap().put("createTime", "desc");
        List attachList = this.attachmentService.queryList(queryParam);
        List<String> fileType = Arrays.asList("jpg", "bmp", "png", "jpeg");
        if (null != param.get((Object)"fileTypes")) {
            fileType.clear();
            fileType.addAll(JSONArray.parseArray((String)param.getString("fileTypes"), String.class));
        }
        if (CollectionUtils.isNotEmpty((Collection)attachList)) {
            resp = attachList.stream().filter(item -> fileType.contains(com.ejianc.foundation.file.util.FileUtils.getFileExt(item.getFileName(), false))).collect(Collectors.groupingBy(item -> item.getSourceId().toString(), Collectors.mapping(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getOnlinePath())) {
                    return item.getOnlinePath();
                }
                return this.fileUrl + item.getFilePath();
            }, Collectors.toList())));
        }
        return CommonResponse.success(resp);
    }

    @RequestMapping(value={"queryListBySourceId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryListBySourceId(@RequestParam(name="sourceId", required=false) Long sourceId, @RequestParam(name="billType", required=false) String billType, @RequestParam(name="sourceType", required=false) String sourceType, @RequestParam(name="orderType", required=false) String orderType) {
        JSONObject jsonObject = new JSONObject();
        QueryParam queryParam = new QueryParam();
        if (null == sourceId) {
            jsonObject.put("data", new ArrayList());
            return CommonResponse.success((String)"sourceId\u4e3a\u7a7a\uff0c\u67e5\u8be2\u4e0d\u5230\u5339\u914d\u7684\u6587\u4ef6\u4fe1\u606f\uff01", (Object)jsonObject);
        }
        if (StringUtils.isBlank((CharSequence)orderType)) {
            orderType = "desc";
        }
        queryParam.getOrderMap().put("createTime", orderType);
        queryParam.getOrderMap().put("id", "desc");
        Map params = queryParam.getParams();
        params.put("sourceId", new Parameter("eq", (Object)sourceId));
        if (StringUtils.isNotBlank((CharSequence)sourceType)) {
            params.put("sourceType", new Parameter("in", (Object)sourceType));
        }
        if (StringUtils.isNotBlank((CharSequence)billType)) {
            params.put("billType", new Parameter("eq", (Object)billType));
        }
        List<AttachmentVO> list = this.attachmentService.queryListByParams(queryParam);
        this.setFileTruePath(list);
        jsonObject.put("data", list);
        return CommonResponse.success((Object)jsonObject);
    }

    public void setFileTruePath(List<AttachmentVO> list) {
        if (!ListUtil.isEmpty(list)) {
            list.forEach(f -> {
                String filePath = f.getFilePath();
                if (StringUtils.isNotBlank((CharSequence)filePath) && filePath.indexOf("http") != -1) {
                    f.setTruePath(filePath);
                } else {
                    f.setTruePath(this.baseHost + "ejc-file-web/attachment/filePreview?fileId=" + f.getId());
                }
                if (StringUtils.isNotBlank((CharSequence)f.getFileFormatPathStr())) {
                    f.setFileFormatPath((List)JSONArray.parse((String)f.getFileFormatPathStr()));
                }
                f.setImgServerPath(this.fileUrl);
                f.setOnlinePath(this.baseHost + "ejc-file-web/attachment/filePreview?fileId=" + f.getId());
            });
        }
    }

    @RequestMapping(value={"getFileListByFileIds"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getFileListByFileIds(HttpServletRequest request) {
        JSONObject jsonObject = new JSONObject();
        String ids = request.getParameter("ids");
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
        List<AttachmentVO> list = this.attachmentService.queryListByIds(ids);
        this.setFileTruePath(list);
        jsonObject.put("data", list);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam(name="ids") String ids) {
        return this.attachmentService.delete(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"filePreview"}, method={RequestMethod.GET})
    @ResponseBody
    public void filePreview(@RequestParam(name="fileId", required=false) String fileId, @RequestParam(name="thumbnail", required=false) String thumbnail, @RequestParam(name="filePath", required=false) String filePath, HttpServletResponse response) throws UnsupportedEncodingException {
        Object inputStream = null;
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            filePath = URLDecoder.decode(filePath, "utf-8");
        } else {
            if (StringUtils.isBlank((CharSequence)fileId)) {
                return;
            }
            AttachmentEntity attachmentVo = (AttachmentEntity)((Object)this.attachmentService.getById((Serializable)((Object)fileId)));
            if (attachmentVo == null) {
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)thumbnail)) {
                inputStream = this.attachmentService.getThumbnailPath(attachmentVo);
            }
            filePath = attachmentVo.getFilePath();
        }
        if (inputStream == null) {
            inputStream = this.fileUtils.downloadFileByKeyName(filePath);
        }
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
                os.flush();
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean fileExtInBlackList(String fileExt) {
        String blackFileExt = this.minioConfiguration.getBlackFileExt();
        if (StringUtils.isNotEmpty((CharSequence)blackFileExt) && fileExt != null) {
            String[] blackFileExtArr;
            for (String blackExt : blackFileExtArr = blackFileExt.split(",")) {
                if (!fileExt.equals(blackExt)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"weixinee/upload"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AttachmentVO> weixinEEUpload(HttpServletRequest request) {
        block22: {
            String mediaId = request.getParameter("mediaId");
            String systemCode = request.getParameter("systemCode");
            String billType = request.getParameter("billType");
            String sourceId = request.getParameter("sourceId");
            String sourceType = request.getParameter("sourceType");
            String mark = request.getParameter("mark");
            String orgIdStr = request.getParameter("orgId");
            SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
            if (StringUtils.isBlank((CharSequence)billType)) {
                return CommonResponse.error((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u4ee5\u4f20\u5355\u636e\u7c7b\u578b\u7f16\u53f7\uff01");
            }
            CommonResponse thirdSystemResponse = this.thirdSystemApi.getOneByCode(systemCode);
            if (thirdSystemResponse.isSuccess()) {
                ThirdSystemVO thirdSystemVo = (ThirdSystemVO)thirdSystemResponse.getData();
                String configInfo = thirdSystemVo.getConfigInfo();
                JSONObject configJson = JSON.parseObject((String)configInfo);
                String corpAppId = configJson.getString("corp_appId");
                String corpSecret = configJson.getString("corp_secret");
                String accessToken = this.getWeixineeAccessToken(corpAppId, corpSecret);
                String weixinurl = "https://qyapi.weixin.qq.com/cgi-bin/media/get?access_token=" + accessToken + "&media_id=" + mediaId;
                InputStream inputStream = null;
                HttpURLConnection conn = null;
                try {
                    TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
                    SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
                    sslContext.init(null, tm, new SecureRandom());
                    SSLSocketFactory ssf = sslContext.getSocketFactory();
                    URL url = new URL(weixinurl);
                    conn = (HttpsURLConnection)url.openConnection();
                    ((HttpsURLConnection)conn).setSSLSocketFactory(ssf);
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod("GET");
                    inputStream = conn.getInputStream();
                    String fileName = IdWorker.getId() + ".jpg";
                    String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + fileName;
                    ObjectWriteResponse objectResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(inputStream, (long)inputStream.available(), (long)this.DEFAULT_PART_SIZE.intValue()).build());
                    if (!StringUtils.isNotBlank((CharSequence)objectResponse.etag())) break block22;
                    AttachmentVO attachment = new AttachmentVO();
                    attachment.setBillType(billType);
                    if (StringUtils.isNotBlank((CharSequence)sourceId)) {
                        attachment.setSourceId(Long.valueOf(Long.parseLong(sourceId)));
                    }
                    attachment.setSourceType(sourceType);
                    attachment.setMark(mark);
                    attachment.setFileName(fileName);
                    attachment.setFilePath(objectName);
                    attachment.setFileSize(Long.valueOf(0L));
                    Long orgId = null;
                    orgId = StringUtils.isBlank((CharSequence)orgIdStr) ? InvocationInfoProxy.getOrgId() : Long.valueOf(Long.parseLong(orgIdStr));
                    attachment.setOrgId(orgId);
                    Long userId = InvocationInfoProxy.getUserid();
                    CommonResponse employeeResponse = this.employeeApi.queryEmployeByUserId(userId);
                    if (employeeResponse.isSuccess()) {
                        attachment.setUploadUserName(((EmployeeVO)employeeResponse.getData()).getName());
                    }
                    AttachmentEntity entity = (AttachmentEntity)((Object)BeanMapper.map((Object)attachment, AttachmentEntity.class));
                    this.attachmentService.saveOrUpdate((Object)entity, false);
                    InputStream is = this.attachmentService.getThumbnailPath(entity);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    entity.setOnlinePath(this.fileUrl + objectName);
                    AttachmentVO attachmentVo = (AttachmentVO)BeanMapper.map((Object)((Object)entity), AttachmentVO.class);
                    CommonResponse commonResponse = CommonResponse.success((Object)attachmentVo);
                    return commonResponse;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
        }
        return CommonResponse.error((String)"\u4e0a\u4f20\u5931\u8d25");
    }

    private String getWeixineeAccessToken(String corpAppId, String corpSecret) {
        String key = corpAppId + "_" + corpSecret;
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)key);
        logger.info("redis----accessToken=" + accessToken);
        System.out.println("redis----accessToken=" + accessToken);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            HashMap<String, String> param = new HashMap<String, String>();
            String accessResult = null;
            param.put("corpid", corpAppId);
            param.put("corpsecret", corpSecret);
            try {
                accessResult = ReferHttpClientUtils.get((String)"https://qyapi.weixin.qq.com/cgi-bin/gettoken", param, new HashMap());
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            logger.info("accessResult=" + accessResult);
            System.out.println("accessResult=" + accessResult);
            if (StringUtils.isNotBlank((CharSequence)accessResult)) {
                JSONObject accessJson = JSON.parseObject((String)accessResult);
                accessToken = accessJson.getString("access_token");
                String errmsg = accessJson.getString("errmsg");
                if ("ok".equals(errmsg) && StringUtils.isNotBlank((CharSequence)accessToken)) {
                    this.redisTemplate.opsForValue().set((Object)key, (Object)accessToken, 7000L, TimeUnit.SECONDS);
                }
            }
        }
        return accessToken;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"no_auth/upload"})
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> uploadNoAuth(HttpServletRequest request) throws Exception {
        boolean fromWxMiniPm;
        String billType = request.getParameter("billType");
        String sourceId = request.getParameter("sourceId");
        String sourceType = request.getParameter("sourceType");
        String mark = request.getParameter("mark");
        String tenantId = request.getParameter("tenantId");
        String userCode = request.getParameter("userCode");
        String orgIdStr = request.getParameter("orgId");
        String originalFileNameStr = request.getParameter("originalFileName");
        boolean bl = fromWxMiniPm = StringUtils.isNotBlank((CharSequence)request.getParameter("fromWxMiniPm")) ? Boolean.valueOf(request.getParameter("fromWxMiniPm")) : false;
        if (StringUtils.isBlank((CharSequence)billType)) {
            return CommonResponse.error((String)"\u5355\u636e\u7c7b\u578b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)sourceType)) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u7c7b\u578b(\u56fe\u7247\u7c7b\u578b)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            tenantId = "999999";
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<Object> fileList = new ArrayList<Object>();
        for (Map.Entry entity : fileMap.entrySet()) {
            void var17_21;
            MultipartFile mf = (MultipartFile)entity.getValue();
            String string = mf.getOriginalFilename();
            if (string.indexOf(".") < 0) {
                String string2 = originalFileNameStr;
            }
            if (mf.getSize() == 0L) {
                logger.error(mf.getOriginalFilename() + "\u5927\u5c0f\u4e0d\u80fd\u4e3a0");
                throw new BusinessException("\u4e0a\u4f20\u4e86\u7a7a\u6587\u4ef6");
            }
            String commonResponse = var17_21.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            commonResponse.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)commonResponse, (Boolean)false);
            if (this.fileExtInBlackList(extName)) {
                logger.error("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
                throw new BusinessException("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
            }
            Integer sizeLimit = this.minioConfiguration.getSizeLimit();
            if (mf.getSize() > (long)sizeLimit.intValue()) {
                logger.error("\u9650\u5b9a\u5927\u5c0f\u4e3a\uff1a" + sizeLimit + "\uff0c\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1a" + mf.getSize());
                throw new BusinessException("\u4e0a\u4f20\u4e86\u5927\u4e8e\u9650\u5b9a\u5927\u5c0f\u7684\u6587\u4ef6");
            }
            fileList.add(mf);
        }
        try (InputStream mfInputStream = null;){
            ArrayList<AttachmentEntity> resultEntity = new ArrayList<AttachmentEntity>();
            for (MultipartFile multipartFile : fileList) {
                ObjectWriteResponse objectResponse;
                SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                String fileName = multipartFile.getOriginalFilename();
                if (fileName.indexOf(".") < 0) {
                    fileName = originalFileNameStr;
                }
                String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
                originalFilename.replaceAll("00.", "");
                String extName = FileUtils.getFileExt((String)originalFilename, (Boolean)false);
                String objectName = tenantId + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
                mfInputStream = multipartFile.getInputStream();
                if (fromWxMiniPm) {
                    fileName = "WXMiniPm-" + objectName;
                }
                if (!StringUtils.isNotBlank((CharSequence)(objectResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(mfInputStream, (long)mfInputStream.available(), (long)this.DEFAULT_PART_SIZE.intValue()).build())).etag())) continue;
                AttachmentVO attachment = new AttachmentVO();
                attachment.setBillType(billType);
                if (StringUtils.isNotBlank((CharSequence)sourceId)) {
                    attachment.setSourceId(Long.valueOf(Long.parseLong(sourceId)));
                }
                attachment.setSourceType(sourceType);
                attachment.setMark(mark);
                attachment.setFileName(fileName);
                attachment.setFilePath(objectName);
                attachment.setFileSize(Long.valueOf(multipartFile.getSize()));
                attachment.setTenantId(Long.valueOf(tenantId));
                attachment.setCreateUserCode(userCode);
                if (extName.toLowerCase().contains("pdf")) {
                    attachment.setMark(this.getPdfPages(multipartFile.getBytes()));
                }
                AttachmentEntity entity = (AttachmentEntity)((Object)BeanMapper.map((Object)attachment, AttachmentEntity.class));
                this.attachmentService.saveOrUpdate((Object)entity, false);
                this.attachmentService.saveOrUpdate((Object)entity, false);
                InputStream is = this.attachmentService.getThumbnailPath(entity);
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                entity.setOnlinePath(this.fileUrl + objectName);
                resultEntity.add(entity);
            }
            List resultList = BeanMapper.mapList(resultEntity, AttachmentVO.class);
            this.setFileTruePath(resultList);
            CommonResponse commonResponse = CommonResponse.success((Object)resultList);
            return commonResponse;
        }
    }

    @RequestMapping(value={"copyFileToBusiness"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> copyFileToBusiness(@RequestBody JSONObject jsonStr) {
        ArrayList<Object> attachVos = new ArrayList<Object>();
        String attachIds = jsonStr.getString("attachIds");
        if (StringUtils.isBlank((CharSequence)attachIds)) {
            return CommonResponse.error((String)"\u539f\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String billType = jsonStr.getString("billType");
        String sourceId = jsonStr.getString("sourceId");
        String sourceType = jsonStr.getString("sourceType");
        if (StringUtils.isBlank((CharSequence)billType)) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u4ee5\u4f20\u5355\u636e\u7c7b\u578b\u7f16\u53f7\uff01");
        }
        QueryWrapper attachWrapper = new QueryWrapper();
        attachWrapper.in((Object)"id", new Object[]{attachIds});
        List attachEntities = this.attachmentService.list((Wrapper)attachWrapper);
        if (attachEntities != null && attachEntities.size() > 0) {
            for (AttachmentEntity attachmentEntity : attachEntities) {
                attachmentEntity.setId(IdWorker.getId());
                attachmentEntity.setBillType(billType);
                if (StringUtils.isNotBlank((CharSequence)sourceId)) {
                    attachmentEntity.setSourceId(Long.parseLong(sourceId));
                }
                attachmentEntity.setSourceType(sourceType);
                this.attachmentService.saveOrUpdate((Object)attachmentEntity);
                attachmentEntity.setOnlinePath(this.fileUrl + attachmentEntity.getFilePath());
                attachVos.add(BeanMapper.map((Object)((Object)attachmentEntity), AttachmentVO.class));
            }
        }
        return CommonResponse.success(attachVos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"uploadAndMerge2Pdf"})
    @ResponseBody
    public CommonResponse<AttachmentVO> uploadAndMerge2Pdf(HttpServletRequest request) {
        String extName;
        Object resp = null;
        String billType = request.getParameter("billType");
        String sourceId = request.getParameter("sourceId");
        String sourceType = request.getParameter("sourceType");
        String mark = request.getParameter("mark");
        String replace = request.getParameter("replace");
        String mainFileId = request.getParameter("mainFileId");
        String mergeSequenceStr = request.getParameter("mergeSequence");
        final HashMap mergeSequence = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)mergeSequenceStr)) {
            mergeSequence.putAll((Map)JSONObject.parseObject((String)mergeSequenceStr, Map.class));
        }
        String originalFileNameStr = request.getParameter("originalFileName");
        if (StringUtils.isBlank((CharSequence)billType)) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u4ee5\u4f20\u5355\u636e\u7c7b\u578b\u7f16\u53f7\uff01");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MultipartFile> fileList = new ArrayList<MultipartFile>();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile mf = (MultipartFile)entity.getValue();
            String originalFilename = mf.getOriginalFilename();
            if (originalFilename.indexOf(".") < 0) {
                originalFilename = originalFileNameStr;
            }
            if (mf.getSize() == 0L) {
                logger.error(mf.getOriginalFilename() + "\u5927\u5c0f\u4e0d\u80fd\u4e3a0");
                throw new BusinessException("\u4e0a\u4f20\u4e86\u7a7a\u6587\u4ef6");
            }
            originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFilename.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFilename, (Boolean)false);
            if (this.fileExtInBlackList(extName)) {
                logger.error("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
                throw new BusinessException("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
            }
            Integer sizeLimit = this.minioConfiguration.getSizeLimit();
            if (mf.getSize() > (long)sizeLimit.intValue()) {
                logger.error("\u9650\u5b9a\u5927\u5c0f\u4e3a\uff1a" + sizeLimit + "\uff0c\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1a" + mf.getSize());
                throw new BusinessException("\u4e0a\u4f20\u4e86\u5927\u4e8e\u9650\u5b9a\u5927\u5c0f\u7684\u6587\u4ef6");
            }
            fileList.add(mf);
        }
        Boolean onlyOneFile = true;
        String bucketName = this.minioConfiguration.getBucketName();
        Document mainFile = null;
        String mainFileName = null;
        extName = null;
        Object mergeFile = null;
        Object tempPdfFile = null;
        Object mainTempPdfFile = null;
        ByteArrayInputStream bis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ArrayList<Document> docList = new ArrayList<Document>();
        ArrayList tmpDocs = new ArrayList();
        Object tmpDoc = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        ArrayList pdfFiles = new ArrayList();
        try {
            Object attachmentVo;
            if (StringUtils.isNotBlank((CharSequence)mainFileId) && (attachmentVo = this.attachmentService.selectById(mainFileId)) != null) {
                GetObjectResponse commonResponse = this.fileUtils.downloadFileByKeyName(attachmentVo.getFilePath());
                mainFileName = attachmentVo.getFileName();
                extName = FileUtils.getFileExt((String)mainFileName, (Boolean)false);
                bos.reset();
                this.change2Pdf((InputStream)commonResponse, bos, extName);
                bis = new ByteArrayInputStream(bos.toByteArray());
                mainFile = new Document((InputStream)bis);
                bos.flush();
                bos.close();
                bis.close();
            }
            if (null != mergeSequence) {
                fileList.sort(new Comparator<MultipartFile>(){

                    @Override
                    public int compare(MultipartFile o1, MultipartFile o2) {
                        return (null != mergeSequence.get(o1.getName()) ? (Integer)mergeSequence.get(o1.getName()) : 0) - (null != mergeSequence.get(o2.getName()) ? (Integer)mergeSequence.get(o2.getName()) : 0);
                    }
                });
            }
            for (MultipartFile multipartFile : fileList) {
                extName = FileUtils.getFileExt((String)multipartFile.getOriginalFilename(), (Boolean)false);
                bos.reset();
                this.change2Pdf(multipartFile.getInputStream(), bos, extName);
                bis = new ByteArrayInputStream(bos.toByteArray());
                if (null == mainFile) {
                    mainFileName = multipartFile.getOriginalFilename();
                    mainFileName = mainFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
                    mainFile = new Document((InputStream)bis);
                } else {
                    docList.add(new Document((InputStream)bis));
                }
                if (fileList.size() <= 1) continue;
                bos.flush();
                bos.close();
                bis.close();
            }
            logger.info("\u5f85\u5408\u5e76\u6587\u4ef6\u5217\u8868\u6570\u91cf\uff1a{}", (Object)docList.size());
            if (CollectionUtils.isNotEmpty(docList)) {
                for (Document document : docList) {
                    mainFile.getPages().add((Iterable)document.getPages());
                }
                bos.reset();
                mainFile.save((OutputStream)bos);
                onlyOneFile = false;
            }
            if (null == bos || bos.size() == 0) {
                attachmentVo = CommonResponse.error((String)"\u6587\u4ef6\u5408\u5e76\u5931\u8d25\uff0c\u5408\u5e76\u540e\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
                return attachmentVo;
            }
            String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + ".pdf";
            bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectWriteResponse objectWriteResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream((InputStream)bis, (long)bis.available(), (long)this.DEFAULT_PART_SIZE.intValue()).build());
            if (StringUtils.isNotBlank((CharSequence)objectWriteResponse.etag())) {
                AttachmentVO attachment = null;
                if ("true".equals(replace) && StringUtils.isNotBlank((CharSequence)sourceId)) {
                    List<AttachmentVO> list = this.attachmentService.findFileList(InvocationInfoProxy.getTenantid(), sourceId, sourceType, billType);
                    if (CollectionUtils.isEmpty(list)) {
                        logger.info("\u672a\u5339\u914d\u5230\u8981\u66f4\u65b0\u7684\u9644\u4ef6sourceId-{},sourceType-{},billType-{}\uff0c\u521b\u5efa\u65b0\u7684\u9644\u4ef6\u4fe1\u606f\uff01", new Object[]{sourceId, sourceType, billType});
                        attachment = new AttachmentVO();
                    } else {
                        attachment = list.get(0);
                        attachment.setOnlinePath(null);
                    }
                } else {
                    attachment = new AttachmentVO();
                }
                attachment.setBillType(billType);
                if (StringUtils.isNotBlank((CharSequence)sourceId)) {
                    attachment.setSourceId(Long.valueOf(Long.parseLong(sourceId)));
                }
                attachment.setSourceType(sourceType);
                attachment.setMark(mark);
                attachment.setFileName(mainFileName.substring(0, mainFileName.lastIndexOf(".") + 1) + "pdf");
                attachment.setFilePath(objectName);
                attachment.setOrgId(InvocationInfoProxy.getOrgId());
                Long userId = InvocationInfoProxy.getUserid();
                CommonResponse employeeResponse = this.employeeApi.queryEmployeByUserId(userId);
                if (employeeResponse.isSuccess()) {
                    attachment.setUploadUserName(((EmployeeVO)employeeResponse.getData()).getName());
                }
                AttachmentEntity entity = (AttachmentEntity)((Object)BeanMapper.map((Object)attachment, AttachmentEntity.class));
                logger.info("\u5f85\u4fdd\u5b58\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
                this.attachmentService.saveOrUpdate((Object)entity, false);
                entity.setOnlinePath(this.fileUrl + (String)objectName);
                CommonResponse commonResponse = CommonResponse.success((String)"\u6587\u4ef6\u5408\u5e76\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)entity), AttachmentVO.class));
                return commonResponse;
            }
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u5408\u5e76\u8f6cPDF\u5f02\u5e38\uff1a", (Throwable)e);
            CommonResponse commonResponse = CommonResponse.error((String)"\u6587\u4ef6\u5408\u5e76\u5931\u8d25\uff01");
            return commonResponse;
        }
        finally {
            try {
                if (null != mainFile) {
                    mainFile.close();
                }
                for (Document doc : docList) {
                    doc.close();
                }
                if (bos != null) {
                    bos.flush();
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException ex) {
                logger.error("\u8f93\u51fa\u6d41\u5173\u95ed\u5f02\u5e38\uff1a", (Throwable)ex);
            }
        }
        return CommonResponse.success(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change2Pdf(InputStream in, ByteArrayOutputStream bos, String suffix) {
        boolean changFlag = false;
        BufferedInputStream bufferedInputStream = null;
        try {
            boolean auth = PoiExcelToHtmlImpl.authrolizeLicense();
            if (!auth) {
                logger.info("aspose \u8bb8\u53ef\u65e0\u6548\uff01");
            }
            if ("doc".equals(suffix) || "docx".equals(suffix)) {
                FontSettings fontSetting = FontSettings.getDefaultInstance();
                fontSetting.setFontsFolder("/usr/share/fonts/", false);
                bufferedInputStream = new BufferedInputStream(in);
                com.aspose.words.Document document = new com.aspose.words.Document((InputStream)bufferedInputStream);
                document.acceptAllRevisions();
                document.setFontSettings(fontSetting);
                document.save((OutputStream)bos, 40);
                changFlag = true;
            } else if ("xls".equals(suffix) || "xlsx".equals(suffix)) {
                Workbook cellBook = new Workbook(in);
                Style style = cellBook.createStyle();
                style.setTextWrapped(true);
                int[] autoDrawSheets = new int[]{1};
                AttachmentController.autoDraw(cellBook, autoDrawSheets);
                PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
                pdfSaveOptions.setAllColumnsInOnePagePerSheet(true);
                cellBook.save((OutputStream)bos, (SaveOptions)pdfSaveOptions);
                changFlag = true;
            } else {
                changFlag = this.officeToPdf.converterFile(in, suffix, bos, "pdf");
            }
            logger.info("\u5355\u4e2a\u975edoc/docx\u6587\u4ef6\u8f6cPDF\u7ed3\u679c\uff1a{}", (Object)changFlag);
        }
        catch (Exception e) {
            logger.error("change2Pdf-\u6587\u4ef6\u5408\u5e76\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException ignored) {
                    System.out.println("\u5173\u95ed\u6d41\u5f02\u5e38" + ignored);
                }
            }
            if (bos != null && bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ex2) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)ex2);
                }
            }
        }
        if (!changFlag) {
            throw new BusinessException("\u6587\u4ef6\u5408\u5e76\u5931\u8d25");
        }
    }

    public static void autoDraw(Workbook wb, int[] page) {
        if (null != page && page.length > 0) {
            for (int i = 0; i < page.length; ++i) {
                wb.getWorksheets().get(i).getHorizontalPageBreaks().clear();
                wb.getWorksheets().get(i).getVerticalPageBreaks().clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequestMapping(value={"upload"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> upload(HttpServletRequest request) {
        boolean fromWxMiniPm;
        String billType = request.getParameter("billType");
        String sourceId = request.getParameter("sourceId");
        String sourceType = request.getParameter("sourceType");
        String mark = request.getParameter("mark");
        String replace = request.getParameter("replace");
        String orgIdStr = request.getParameter("orgId");
        String imgFileType = request.getParameter("imgFileType");
        String imgFileSourceType = request.getParameter("imgFileSourceType");
        String imgFileDpi = request.getParameter("imgFileDpi");
        String originalFileNameStr = request.getParameter("originalFileName");
        boolean bl = fromWxMiniPm = StringUtils.isNotBlank((CharSequence)request.getParameter("fromWxMiniPm")) ? Boolean.valueOf(request.getParameter("fromWxMiniPm")) : false;
        if (StringUtils.isBlank((CharSequence)billType)) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u4ee5\u4f20\u5355\u636e\u7c7b\u578b\u7f16\u53f7\uff01");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<Object> fileList = new ArrayList<Object>();
        for (Map.Entry entity : fileMap.entrySet()) {
            void var19_23;
            MultipartFile mf = (MultipartFile)entity.getValue();
            String string = mf.getOriginalFilename();
            if (string.indexOf(".") < 0) {
                String string2 = originalFileNameStr;
            }
            if (mf.getSize() == 0L) {
                logger.error(mf.getOriginalFilename() + "\u5927\u5c0f\u4e0d\u80fd\u4e3a0");
                throw new BusinessException("\u4e0a\u4f20\u4e86\u7a7a\u6587\u4ef6");
            }
            String string3 = var19_23.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            string3.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)string3, (Boolean)false);
            if (this.fileExtInBlackList(extName)) {
                logger.error("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
                throw new BusinessException("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
            }
            Integer sizeLimit = this.minioConfiguration.getSizeLimit();
            if (mf.getSize() > (long)sizeLimit.intValue()) {
                logger.error("\u9650\u5b9a\u5927\u5c0f\u4e3a\uff1a" + sizeLimit + "\uff0c\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1a" + mf.getSize());
                throw new BusinessException("\u4e0a\u4f20\u4e86\u5927\u4e8e\u9650\u5b9a\u5927\u5c0f\u7684\u6587\u4ef6");
            }
            fileList.add(mf);
        }
        InputStream mfInputStream = null;
        try {
            ArrayList<AttachmentEntity> resultEntity = new ArrayList<AttachmentEntity>();
            for (MultipartFile multipartFile : fileList) {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                String fileName = multipartFile.getOriginalFilename();
                if (fileName.indexOf(".") < 0) {
                    fileName = originalFileNameStr;
                }
                String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
                originalFilename.replaceAll("00.", "");
                String extName = FileUtils.getFileExt((String)originalFilename, (Boolean)false);
                String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
                if (fromWxMiniPm) {
                    fileName = "WXMiniPm-" + objectName;
                }
                mfInputStream = multipartFile.getInputStream();
                ObjectWriteResponse objectResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(mfInputStream, (long)mfInputStream.available(), (long)this.DEFAULT_PART_SIZE.intValue()).build());
                if (!StringUtils.isNotBlank((CharSequence)objectResponse.etag())) continue;
                AttachmentVO attachment = null;
                if ("true".equals(replace) && StringUtils.isNotBlank((CharSequence)sourceId)) {
                    List<AttachmentVO> list = this.attachmentService.findFileList(InvocationInfoProxy.getTenantid(), sourceId, sourceType, billType);
                    if (CollectionUtils.isEmpty(list)) {
                        logger.info("\u672a\u5339\u914d\u5230\u8981\u66f4\u65b0\u7684\u9644\u4ef6sourceId-{},sourceType-{},billType-{}\uff0c\u521b\u5efa\u65b0\u7684\u9644\u4ef6\u4fe1\u606f\uff01", new Object[]{sourceId, sourceType, billType});
                        attachment = new AttachmentVO();
                    } else {
                        attachment = list.get(0);
                        attachment.setOnlinePath(null);
                    }
                } else {
                    attachment = new AttachmentVO();
                }
                attachment.setBillType(billType);
                if (StringUtils.isNotBlank((CharSequence)sourceId)) {
                    attachment.setSourceId(Long.valueOf(Long.parseLong(sourceId)));
                }
                attachment.setSourceType(sourceType);
                attachment.setMark(mark);
                attachment.setFileName(fileName);
                attachment.setFilePath(objectName);
                attachment.setFileSize(Long.valueOf(multipartFile.getSize()));
                Long orgId = null;
                orgId = StringUtils.isBlank((CharSequence)orgIdStr) ? InvocationInfoProxy.getOrgId() : Long.valueOf(Long.parseLong(orgIdStr));
                attachment.setOrgId(orgId);
                Long userId = InvocationInfoProxy.getUserid();
                CommonResponse employeeResponse = this.employeeApi.queryEmployeByUserId(userId);
                if (employeeResponse.isSuccess()) {
                    attachment.setUploadUserName(((EmployeeVO)employeeResponse.getData()).getName());
                }
                if (extName.toLowerCase().contains("pdf")) {
                    attachment.setMark(this.getPdfPages(multipartFile.getBytes()));
                }
                AttachmentEntity entity = (AttachmentEntity)((Object)BeanMapper.map((Object)attachment, AttachmentEntity.class));
                logger.info("\u5f85\u4fdd\u5b58\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
                this.attachmentService.saveOrUpdate((Object)entity, false);
                InputStream is = this.attachmentService.getThumbnailPath(entity);
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                entity.setOnlinePath(this.fileUrl + objectName);
                resultEntity.add(entity);
            }
            List resultList = BeanMapper.mapList(resultEntity, AttachmentVO.class);
            this.setFileTruePath(resultList);
            if (StringUtils.isNotBlank((CharSequence)imgFileType)) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("attaches", (Object)JSONObject.toJSONString((Object)resultList));
                jSONObject.put("imgFileType", (Object)imgFileType);
                jSONObject.put("imgFileSourceType", (Object)imgFileSourceType);
                jSONObject.put("imgFileDpi", (Object)imgFileDpi);
                this.mqQueueUtils.sendMq("fileToImg_" + this.profile, JSONObject.toJSONString((Object)jSONObject));
            }
            CommonResponse commonResponse = CommonResponse.success((Object)resultList);
            return commonResponse;
        }
        catch (Exception ex) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)ex);
            CommonResponse commonResponse = CommonResponse.error((String)("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0cMsg\uff1a" + ex.getMessage()));
            return commonResponse;
        }
        finally {
            if (mfInputStream != null) {
                try {
                    mfInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private String getPdfPages(InputStream is) {
        try {
            Document doc = new Document(is);
            return doc.getPages().size() + "";
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6PDF\u6587\u4ef6\u9875\u6570\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private String getPdfPages(byte[] bytes) {
        try {
            Document doc = new Document((InputStream)new ByteArrayInputStream(bytes));
            return doc.getPages().size() + "";
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6PDF\u6587\u4ef6\u9875\u6570\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @RequestMapping(value={"upload2"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> upload2(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MultipartFile> fileList = new ArrayList<MultipartFile>();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile mf = (MultipartFile)entity.getValue();
            String originalFilename = mf.getOriginalFilename();
            if (mf.getSize() == 0L) {
                logger.error(mf.getOriginalFilename() + "\u5927\u5c0f\u4e0d\u80fd\u4e3a0");
                throw new BusinessException("\u4e0a\u4f20\u4e86\u7a7a\u6587\u4ef6");
            }
            originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFilename.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFilename, (Boolean)false);
            if (this.fileExtInBlackList(extName)) {
                logger.error("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
                throw new BusinessException("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
            }
            Integer sizeLimit = this.minioConfiguration.getSizeLimit();
            if (mf.getSize() > (long)sizeLimit.intValue()) {
                logger.error("\u9650\u5b9a\u5927\u5c0f\u4e3a\uff1a" + sizeLimit + "\uff0c\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1a" + mf.getSize());
                throw new BusinessException("\u4e0a\u4f20\u4e86\u5927\u4e8e\u9650\u5b9a\u5927\u5c0f\u7684\u6587\u4ef6");
            }
            fileList.add(mf);
        }
        InputStream mfInputStream = null;
        try {
            ArrayList<AttachmentVO> resultList = new ArrayList<AttachmentVO>();
            for (MultipartFile mf : fileList) {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                String fileName = mf.getOriginalFilename();
                String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
                originalFilename.replaceAll("00.", "");
                String extName = FileUtils.getFileExt((String)originalFilename, (Boolean)false);
                String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
                mfInputStream = mf.getInputStream();
                ObjectWriteResponse objectResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(mfInputStream, (long)mfInputStream.available(), (long)this.DEFAULT_PART_SIZE.intValue()).build());
                if (!StringUtils.isNotBlank((CharSequence)objectResponse.etag())) continue;
                AttachmentVO vo = new AttachmentVO();
                vo.setFilePath(objectName);
                vo.setOnlinePath(this.fileUrl + objectName);
                vo.setFileName(fileName);
                if (extName.toLowerCase().contains("pdf")) {
                    vo.setMark(this.getPdfPages(mf.getBytes()));
                }
                resultList.add(vo);
            }
            CommonResponse commonResponse = CommonResponse.success(resultList);
            return commonResponse;
        }
        catch (Exception ex) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)ex);
            throw new BusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0cMsg\uff1a" + ex.getMessage());
        }
        finally {
            if (mfInputStream != null) {
                try {
                    mfInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @RequestMapping(value={"download"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> download(@RequestParam(name="fileId", required=true) String fileId, HttpServletResponse response) {
        AttachmentVO attachmentVo = this.attachmentService.selectById(fileId);
        if (attachmentVo != null) {
            String bucketName = this.minioConfiguration.getBucketName();
            BufferedOutputStream out = null;
            GetObjectResponse getObjectResponse = null;
            try {
                response.reset();
                response.setContentType("application/octet-stream");
                response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(attachmentVo.getFileName(), "UTF-8"));
                response.setHeader("Content-Length", String.valueOf(attachmentVo.getFileSize()));
                response.setHeader("Access-Control-Allow-Origin", "*");
                getObjectResponse = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(attachmentVo.getFilePath())).build());
                out = new BufferedOutputStream((OutputStream)response.getOutputStream());
                IOUtils.copy((InputStream)getObjectResponse, (OutputStream)out);
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
                throw new BusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0cMsg\uff1a" + e.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (getObjectResponse != null) {
                    try {
                        getObjectResponse.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return CommonResponse.success((String)"\u4e0b\u8f09\u6210\u529f");
        }
        return CommonResponse.error((String)"\u53c2\u6570fileId\u4e0d\u5408\u6cd5\uff0c\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u9644\u4ef6\u4fe1\u606f");
    }

    @RequestMapping(value={"no_auth/getattachById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AttachmentEntity> getattachById(@RequestParam(name="attachid", required=true) String attachid) {
        AttachmentEntity attachmentEntity = (AttachmentEntity)((Object)this.attachmentService.getById((Serializable)((Object)attachid)));
        return CommonResponse.success((Object)((Object)attachmentEntity));
    }

    @RequestMapping(value={"no_auth/download"})
    public void noAuthDownload(@RequestParam(name="fileId", required=true) String fileId, HttpServletResponse response) {
        this.download(fileId, response);
    }

    @RequestMapping(value={"no_auth/updateFileCss"})
    @ResponseBody
    public CommonResponse<String> updateFileCss(@RequestParam(name="fileId", required=true) String fileId, @RequestParam(name="extcss", required=true) String extcss) {
        this.attachmentService.updateFileCss(fileId, extcss);
        return CommonResponse.success();
    }

    @RequestMapping(value={"no_auth/queryFileCss"})
    @ResponseBody
    public CommonResponse<String> queryFileCss(@RequestParam(name="fileId", required=true) String fileId) {
        String extcss = this.attachmentService.queryFileCss(fileId);
        return CommonResponse.success((String)"success", (Object)extcss);
    }

    @RequestMapping(value={"batchdownflow"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, byte[]>> batchDownFlow(@RequestParam(name="fileIds", required=true) String fileIds) {
        List<AttachmentVO> attachmentList = this.attachmentService.queryListByIds(fileIds);
        try {
            TreeMap<String, byte[]> fileBytes = new TreeMap<String, byte[]>();
            OutputStream out = null;
            HashMap<String, Integer> fileNames = new HashMap<String, Integer>();
            for (int i = 0; i < attachmentList.size(); ++i) {
                AttachmentVO attachmentVo = attachmentList.get(i);
                String filName = "";
                if (fileNames.get(attachmentVo.getFileName()) != null) {
                    filName = attachmentVo.getFileName().replace(".", "(" + fileNames.get(attachmentVo.getFileName()) + ").");
                    fileNames.put(attachmentVo.getFileName(), (Integer)fileNames.get(attachmentVo.getFileName()) + 1);
                } else {
                    filName = attachmentVo.getFileName();
                    fileNames.put(attachmentVo.getFileName(), 1);
                }
                GetObjectResponse getObjectResponse = null;
                try {
                    String bucketName = this.minioConfiguration.getBucketName();
                    getObjectResponse = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(attachmentVo.getFilePath())).build());
                    out = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)getObjectResponse, (OutputStream)out);
                    fileBytes.put(filName, ((ByteArrayOutputStream)out).toByteArray());
                    continue;
                }
                catch (Exception e) {
                    throw new BusinessException(attachmentVo.getFileName() + "\u4e0b\u8f7d\u5931\u8d25");
                }
                finally {
                    if (out != null) {
                        try {
                            out.flush();
                            ((ByteArrayOutputStream)out).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (getObjectResponse != null) {
                        getObjectResponse.close();
                    }
                }
            }
            return CommonResponse.success(fileBytes);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u6587\u4ef6\u4e0b\u8f09\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u6279\u91cf\u6587\u4ef6\u4e0b\u8f09\u5931\u8d25\uff0cMsg\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"no_auth/batchdownflow"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, byte[]>> noAuthBatchDownFlow(@RequestParam(name="fileIds", required=true) String fileIds) {
        List<AttachmentVO> attachmentList = this.attachmentService.queryListByIds(fileIds);
        try {
            TreeMap<String, byte[]> fileBytes = new TreeMap<String, byte[]>();
            OutputStream out = null;
            HashMap<String, Integer> fileNames = new HashMap<String, Integer>();
            for (int i = 0; i < attachmentList.size(); ++i) {
                AttachmentVO attachmentVo = attachmentList.get(i);
                String filName = "";
                if (fileNames.get(attachmentVo.getFileName()) != null) {
                    filName = attachmentVo.getFileName().replace(".", "(" + fileNames.get(attachmentVo.getFileName()) + ").");
                    fileNames.put(attachmentVo.getFileName(), (Integer)fileNames.get(attachmentVo.getFileName()) + 1);
                } else {
                    filName = attachmentVo.getFileName();
                    fileNames.put(attachmentVo.getFileName(), 1);
                }
                GetObjectResponse getObjectResponse = null;
                try {
                    String bucketName = this.minioConfiguration.getBucketName();
                    getObjectResponse = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(attachmentVo.getFilePath())).build());
                    out = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)getObjectResponse, (OutputStream)out);
                    fileBytes.put(filName, ((ByteArrayOutputStream)out).toByteArray());
                    continue;
                }
                catch (Exception e) {
                    throw new BusinessException(attachmentVo.getFileName() + "\u4e0b\u8f7d\u5931\u8d25");
                }
                finally {
                    if (out != null) {
                        try {
                            out.flush();
                            ((ByteArrayOutputStream)out).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (getObjectResponse != null) {
                        getObjectResponse.close();
                    }
                }
            }
            return CommonResponse.success(fileBytes);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u6587\u4ef6\u4e0b\u8f09\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u6279\u91cf\u6587\u4ef6\u4e0b\u8f09\u5931\u8d25\uff0cMsg\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"no_auth/batch-download"}, method={RequestMethod.GET})
    @ResponseBody
    public void noAuthBatchDownload(@RequestParam(name="fileIds", required=false) String fileIds, @RequestParam(name="sourceIds", required=false) String sourceIds, @RequestParam(name="billType", required=false) String billType, @RequestParam(name="sourceTypes", required=false) String sourceTypes, @RequestParam(name="fileDirName", required=false) String fileDirName, @RequestParam(name="zipName", required=false) String zipName, HttpServletResponse response) {
        this.batchDownload(fileIds, sourceIds, billType, sourceTypes, fileDirName, zipName, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"batch-download"}, method={RequestMethod.GET})
    @ResponseBody
    public void batchDownload(@RequestParam(name="fileIds", required=false) String fileIds, @RequestParam(name="sourceIds", required=false) String sourceIds, @RequestParam(name="billType", required=false) String billType, @RequestParam(name="sourceTypes", required=false) String sourceTypes, @RequestParam(name="fileDirName", required=false) String fileDirName, @RequestParam(name="zipName", required=false) String zipName, HttpServletResponse response) {
        List<AttachmentVO> attachmentList = null;
        JSONObject fileDirNameMapping = null;
        if (StringUtils.isNotBlank((CharSequence)fileIds)) {
            attachmentList = this.attachmentService.queryListByIds(fileIds);
        } else {
            QueryParam queryParam = new QueryParam();
            if (StringUtils.isBlank((CharSequence)sourceIds)) {
                throw new BusinessException("\u6279\u91cf\u6587\u4ef6\u4e0b\u8f09\u5931\u8d25\uff0cMsg\uff1asourceIds\u4e3a\u7a7a\uff0c\u67e5\u8be2\u4e0d\u5230\u5339\u914d\u7684\u6587\u4ef6\u4fe1\u606f\uff01");
            }
            queryParam.getOrderMap().put("createTime", "desc");
            Map params = queryParam.getParams();
            params.put("sourceId", new Parameter("in", (Object)sourceIds));
            if (StringUtils.isNotBlank((CharSequence)billType)) {
                params.put("billType", new Parameter("eq", (Object)billType));
            }
            if (StringUtils.isNotBlank((CharSequence)sourceTypes)) {
                params.put("sourceType", new Parameter("in", (Object)sourceTypes));
            }
            if (StringUtils.isNotBlank((CharSequence)fileDirName)) {
                fileDirNameMapping = JSONObject.parseObject((String)fileDirName);
            }
            attachmentList = this.attachmentService.queryListByParams(queryParam);
        }
        String fileName = StringUtils.defaultString((String)(StringUtils.isNotBlank((CharSequence)zipName) ? zipName : "\u9644\u4ef6\u5305")) + ".zip";
        try {
            TreeMap<String, byte[]> fileBytes = new TreeMap<String, byte[]>();
            OutputStream out = null;
            HashMap<String, Integer> fileNames = new HashMap<String, Integer>();
            logger.info("fileDirNameMapping*******\uff1a{}", (Object)JSONObject.toJSONString(fileDirNameMapping));
            for (int i = 0; i < attachmentList.size(); ++i) {
                AttachmentVO attachmentVo = attachmentList.get(i);
                if (StringUtils.isNotBlank((CharSequence)attachmentVo.getMark()) && !"printFormatImg".equals(attachmentVo.getMark())) continue;
                String filName = null != fileDirNameMapping && fileDirNameMapping.containsKey((Object)attachmentVo.getSourceId()) ? fileDirNameMapping.get((Object)attachmentVo.getSourceId()) + File.separator + attachmentVo.getFileName() : attachmentVo.getFileName();
                logger.info("filName: {}", (Object)filName);
                if (fileNames.get(filName) != null) {
                    logger.info("fileNames: {}", (Object)JSONObject.toJSONString(fileNames));
                    logger.info("fileNamesIndex: {}", fileNames.get(filName));
                    Integer idx = (Integer)fileNames.get(filName);
                    filName = filName.replace(".", "(" + idx + ").");
                    fileNames.put(filName, idx + 1);
                } else {
                    fileNames.put(filName, 1);
                }
                GetObjectResponse getObjectResponse = null;
                try {
                    String bucketName = this.minioConfiguration.getBucketName();
                    getObjectResponse = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(attachmentVo.getFilePath())).build());
                    out = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)getObjectResponse, (OutputStream)out);
                    fileBytes.put(filName, ((ByteArrayOutputStream)out).toByteArray());
                    continue;
                }
                catch (Exception e) {
                    logger.info(attachmentVo.getFileName() + "\u4e0b\u8f7d\u5931\u8d25:" + e.getMessage());
                    continue;
                }
                finally {
                    if (out != null) {
                        try {
                            out.flush();
                            ((ByteArrayOutputStream)out).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (getObjectResponse != null) {
                        getObjectResponse.close();
                    }
                }
            }
            response.reset();
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
            ServletOutputStream outputStream = response.getOutputStream();
            ZipCompress zipCompress = new ZipCompress((OutputStream)outputStream);
            zipCompress.compress(fileBytes);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u6587\u4ef6\u4e0b\u8f09\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u6279\u91cf\u6587\u4ef6\u4e0b\u8f09\u5931\u8d25\uff0cMsg\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"/uploadForBase64"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> uploadForBase64(@RequestBody AttachmentRequestVO request) {
        String billType = request.getBillType();
        String sourceId = request.getSourceId();
        String sourceType = request.getSourceType();
        String mark = request.getMark();
        Long tenantId = request.getTenantId();
        Long orgId = request.getOrgId();
        if (StringUtils.isBlank((CharSequence)billType)) {
            return CommonResponse.error((String)"\u5355\u636e\u7c7b\u578b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)sourceType)) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u7c7b\u578b(\u56fe\u7247\u7c7b\u578b)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (tenantId == null && (tenantId = InvocationInfoProxy.getTenantid()) == null) {
            tenantId = 999999L;
        }
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        ArrayList<Object> fileList = new ArrayList<Object>();
        for (String fileStr : request.getFileList()) {
            Object mf = null;
            try {
                mf = new BASE64MultipartFile(fileStr);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new BusinessException("\u4e0a\u4f20\u5931\u8d25");
            }
            String string = mf.getOriginalFilename();
            if (mf.getSize() == 0L) {
                logger.error(mf.getOriginalFilename() + "\u5927\u5c0f\u4e0d\u80fd\u4e3a0");
                throw new BusinessException("\u4e0a\u4f20\u4e86\u7a7a\u6587\u4ef6");
            }
            String commonResponse = string.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            commonResponse.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)commonResponse, (Boolean)false);
            if (this.fileExtInBlackList(extName)) {
                logger.error("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
                throw new BusinessException("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
            }
            Integer sizeLimit = this.minioConfiguration.getSizeLimit();
            if (mf.getSize() > (long)sizeLimit.intValue()) {
                logger.error("\u9650\u5b9a\u5927\u5c0f\u4e3a\uff1a" + sizeLimit + "\uff0c\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1a" + mf.getSize());
                throw new BusinessException("\u4e0a\u4f20\u4e86\u5927\u4e8e\u9650\u5b9a\u5927\u5c0f\u7684\u6587\u4ef6");
            }
            fileList.add(mf);
        }
        InputStream mfInputStream = null;
        try {
            ArrayList<AttachmentEntity> resultEntity = new ArrayList<AttachmentEntity>();
            for (MultipartFile multipartFile : fileList) {
                CommonResponse employeeResponse;
                SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                String fileName = multipartFile.getOriginalFilename();
                String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
                originalFilename.replaceAll("00.", "");
                String extName = FileUtils.getFileExt((String)originalFilename, (Boolean)false);
                String objectName = tenantId + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
                mfInputStream = multipartFile.getInputStream();
                ObjectWriteResponse objectResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(mfInputStream, (long)mfInputStream.available(), (long)this.DEFAULT_PART_SIZE.intValue()).build());
                if (!StringUtils.isNotBlank((CharSequence)objectResponse.etag())) continue;
                AttachmentVO attachment = new AttachmentVO();
                attachment.setBillType(billType);
                if (StringUtils.isNotBlank((CharSequence)sourceId)) {
                    attachment.setSourceId(Long.valueOf(Long.parseLong(sourceId)));
                }
                attachment.setSourceType(sourceType);
                attachment.setMark(mark);
                attachment.setFileName(fileName);
                attachment.setFilePath(objectName);
                attachment.setFileSize(Long.valueOf(multipartFile.getSize()));
                attachment.setOrgId(orgId);
                Long userId = InvocationInfoProxy.getUserid();
                if (userId != null && (employeeResponse = this.employeeApi.queryEmployeByUserId(userId)).isSuccess()) {
                    attachment.setUploadUserName(((EmployeeVO)employeeResponse.getData()).getName());
                }
                AttachmentEntity entity = (AttachmentEntity)((Object)BeanMapper.map((Object)attachment, AttachmentEntity.class));
                entity.setOnlinePath(this.fileUrl + objectName);
                if (extName.toLowerCase().contains("pdf")) {
                    attachment.setMark(this.getPdfPages(multipartFile.getBytes()));
                }
                this.attachmentService.saveOrUpdate((Object)entity, false);
                InputStream is = this.attachmentService.getThumbnailPath(entity);
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                resultEntity.add(entity);
            }
            if (CollectionUtils.isNotEmpty(resultEntity)) {
                this.attachmentService.saveOrUpdateFileList(resultEntity, request.getClearBeforeSave());
            }
            List resultList = BeanMapper.mapList(resultEntity, AttachmentVO.class);
            this.setFileTruePath(resultList);
            CommonResponse commonResponse = CommonResponse.success((Object)resultList);
            return commonResponse;
        }
        catch (Exception ex) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)ex);
            throw new BusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0cMsg\uff1a" + ex.getMessage());
        }
        finally {
            if (mfInputStream != null) {
                try {
                    mfInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @RequestMapping(value={"/updateFileName"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateFileName(@RequestParam(value="id") Long id, @RequestParam(value="name") String name) {
        AttachmentEntity file = (AttachmentEntity)((Object)this.attachmentService.selectById(id));
        if (file == null) {
            return CommonResponse.error((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        file.setFileName(name);
        this.attachmentService.saveOrUpdate((Object)file);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }
}

