package com.ejianc.foundation.file.service.impl;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

import com.ejianc.foundation.file.service.FilePreview;
import com.ejianc.foundation.file.vo.AttachmentVO;

/**
 * Content :处理pdf文件
 */
@Service
public class PdfFilePreviewImpl implements FilePreview {
	
	@Value("${fileUrl}")
    private String fileUrl;

	@Override
	public String filePreviewHandle(HttpServletRequest req, AttachmentVO attach, Model model) {
		String newUrl = null;
		String url = attach.getFilePath();
		if(url.indexOf("http") != -1) {
			newUrl = url + "?attachid="+attach.getId();
		}else{
			newUrl = fileUrl+url + "?attachid="+attach.getId();
		}
		newUrl = newUrl.replaceAll("=", "%3d");
		model.addAttribute("pdfUrl", newUrl);
		
		return "mobilepdf";
	}
}
