package com.ejianc.foundation.file.service.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

import com.ejianc.foundation.file.service.FilePreview;
import com.ejianc.foundation.file.util.FileUtils;
import com.ejianc.foundation.file.vo.AttachmentVO;

/**
 * Content :处理文本文件
 */
@Service
public class SimTextFilePreviewImpl implements FilePreview {
	@Autowired
	FileUtils fileUtils;
	@Value("${fileUrl}")
	private String fileUrl;

	@Override
	public String filePreviewHandle(HttpServletRequest req, AttachmentVO attach, Model model) {
		StringBuffer resultBuffer = new StringBuffer();

		InputStream inputStream = fileUtils.downloadFileByKeyName(attach.getFilePath());
		InputStreamReader isReader = null;
		BufferedReader reader = null;
		try {
			isReader = new InputStreamReader(inputStream,"UTF-8");
			reader = new BufferedReader(isReader);
	        String line; // 用来保存每行读取的内容
	        line = reader.readLine(); // 读取第一行
	        while (line != null) { // 如果 line 为空说明读完了
	        	resultBuffer.append(line); // 将读到的内容添加到 buffer 中
	        	resultBuffer.append(System.getProperty("line.separator")); // 添加换行符
	            line = reader.readLine(); // 读取下一行
	        }
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
			if(inputStream != null) {
				try {
					inputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if(isReader != null) {
				try {
					isReader.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if(reader != null) {
				try {
					reader.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		model.addAttribute("resultStr", resultBuffer.toString());
		return "txt";

	}

}
