package com.ejianc.foundation.file.util;

import com.ejianc.framework.mq.common.MqMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author CJ
 * @Description:
 * @date 2024/8/15 11:33
 */
@Component
public class MqQueueUtils {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RabbitTemplate rabbitTemplate;

    public String sendMq(String queueName, String body) {
        logger.info("MQ队列标识：{}, msg-{}", queueName, body);
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody(body);
        rabbitTemplate.convertAndSend(queueName, mqMessage);
        return "消息发送MQ队列成功！";
    }

}
