package com.ejianc.business.filesystem.file.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 工程
 * 
 * @author generator
 * 
 */
 @TableName("ejc_filesystem_file_project")
public class FileProjectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="type_id")
    private Long typeId; // 分类id
    @TableField(value="type_code")
    private String typeCode; // 分类编号
    @TableField(value="type_name")
    private String typeName; // 分类名称
    @TableField(value="org_id")
    private Long orgId; // 单位id
    @TableField(value="org_name")
    private String orgName; // 单位名称
    @TableField(value="parent_id")
    private Long parentId; // 上级id
    @TableField(value="parent_name")
    private String parentName; // 上级名称
    @TableField(value="person_tech_id")
    private Long personTechId; // 技术负责人id
    @TableField(value="person_tech_name")
    private String personTechName; // 技术负责人名称
    @TableField(value="manager_id")
    private Long managerId; // 项目经理id
    @TableField(value="manager_name")
    private String managerName; // 项目经理名称
    @TableField(value="person_responsible_id")
    private Long personResponsibleId; // 安全员id
    @TableField(value="person_responsible_name")
    private String personResponsibleName; // 安全员名称
    @TableField(value="person_check_id")
    private Long personCheckId; // 审核人id
    @TableField(value="person_check_name")
    private String personCheckName; // 审核人名称
    @TableField(value="start_date")
    private Date startDate; // 开工日期
    @TableField(value="end_date")
    private Date endDate; // 竣工日期
    @TableField(value="build_scale")
    private String buildScale; // 建筑规模
    @TableField(value="build_area")
    private String buildArea; // 建筑面积
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="keyword")
    private String keyword; // 主题词
    @TableField(value="storeroom")
    private String storeroom; // 库位号
    @TableField(value="filing_state")
    private String filingState; // 归档状态

    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额
    @TableField(value="settle_mny")
    private BigDecimal settleMny; // 合同最终金额(结算金额)
    @TableField(value="measure_type")
    private String measureType; // 度量方式
    @TableField(value="memo")
    private String memo; // 工程概况
    @TableField(value="project_type")
    private String projectType; // 承包模式
    @TableField(value="project_contractor")
    private String projectContractor; // 承包人

    @TableField(exist=false)
    @SubEntity(serviceName="fileProjectDetailService")
    private List<FileProjectDetailEntity> fileProjectDetailList = new ArrayList<>(); // 工程批子表
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部名称
    @TableField(value="actual_start_date")
    private Date actualStartDate; // 实际开始日期
    @TableField(value="actual_end_date")
    private Date actualEndDate; // 实际结束日期
    @TableField(value="turn_type")
    private String turnType; // 移交类型

    public Date getActualStartDate() {
        return actualStartDate;
    }

    public void setActualStartDate(Date actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    public Date getActualEndDate() {
        return actualEndDate;
    }

    public void setActualEndDate(Date actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    public String getTurnType() {
        return turnType;
    }

    public void setTurnType(String turnType) {
        this.turnType = turnType;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public List<FileProjectDetailEntity> getFileProjectDetailList() {
        return fileProjectDetailList;
    }

    public void setFileProjectDetailList(List<FileProjectDetailEntity> fileProjectDetailList) {
        this.fileProjectDetailList = fileProjectDetailList;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public String getMeasureType() {
        return measureType;
    }

    public void setMeasureType(String measureType) {
        this.measureType = measureType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public String getProjectContractor() {
        return projectContractor;
    }

    public void setProjectContractor(String projectContractor) {
        this.projectContractor = projectContractor;
    }

    public String getFilingState() {
        return filingState;
    }

    public void setFilingState(String filingState) {
        this.filingState = filingState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getTypeId() {
        return typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }
    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }
    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }
    public Long getPersonTechId() {
        return personTechId;
    }

    public void setPersonTechId(Long personTechId) {
        this.personTechId = personTechId;
    }
    public String getPersonTechName() {
        return personTechName;
    }

    public void setPersonTechName(String personTechName) {
        this.personTechName = personTechName;
    }
    public Long getManagerId() {
        return managerId;
    }

    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    public Long getPersonResponsibleId() {
        return personResponsibleId;
    }

    public void setPersonResponsibleId(Long personResponsibleId) {
        this.personResponsibleId = personResponsibleId;
    }
    public String getPersonResponsibleName() {
        return personResponsibleName;
    }

    public void setPersonResponsibleName(String personResponsibleName) {
        this.personResponsibleName = personResponsibleName;
    }
    public Long getPersonCheckId() {
        return personCheckId;
    }

    public void setPersonCheckId(Long personCheckId) {
        this.personCheckId = personCheckId;
    }
    public String getPersonCheckName() {
        return personCheckName;
    }

    public void setPersonCheckName(String personCheckName) {
        this.personCheckName = personCheckName;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getBuildScale() {
        return buildScale;
    }

    public void setBuildScale(String buildScale) {
        this.buildScale = buildScale;
    }
    public String getBuildArea() {
        return buildArea;
    }

    public void setBuildArea(String buildArea) {
        this.buildArea = buildArea;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }
    public String getStoreroom() {
        return storeroom;
    }

    public void setStoreroom(String storeroom) {
        this.storeroom = storeroom;
    }
    
}
