package com.ejianc.business.filesystem.file.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.filesystem.common.MinioUtils;
import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.business.filesystem.file.bean.FileRecordEntity;
import com.ejianc.business.filesystem.file.dto.FileBtnDTO;
import com.ejianc.business.filesystem.file.dto.FileResponseDTO;
import com.ejianc.business.filesystem.file.mapper.FileBorrowDetailMapper;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileRecordService;
import com.ejianc.business.filesystem.file.service.IFileTypeService;
import com.ejianc.business.filesystem.file.vo.FileMetafileVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.filesystem.file.bean.FileMetafileReplenishEntity;
import com.ejianc.business.filesystem.file.service.IFileMetafileReplenishService;
import com.ejianc.business.filesystem.file.vo.FileMetafileReplenishVO;

/**
 * 元文件(工程)补录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("fileMetafileReplenish")
public class FileMetafileReplenishController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IFileMetafileReplenishService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IFileRecordService recordService;
    @Autowired
    private MinioUtils utils;

    @Value("${ejc.roleid}")
    private Long roleId;

    @Autowired
    private IRoleApi roleApi;

    @Autowired
    private IFileCaseService caseService;

    @Autowired
    private IFileTypeService fileTypeService;

    @Autowired
    private FileBorrowDetailMapper borrowDetailMapper;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FileMetafileReplenishVO> saveOrUpdate(@RequestBody FileMetafileReplenishVO saveOrUpdateVO) {
    	FileMetafileReplenishEntity entity = BeanMapper.map(saveOrUpdateVO, FileMetafileReplenishEntity.class);
        UserContext userContextCache = sessionManager.getUserContext();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际
                // 设置创建人姓名
                entity.setCreateUserId(userContextCache.getUserId());
                entity.setCreateUserName(userContextCache.getUserName());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }

        FileCaseEntity fileCaseEntity = caseService.selectById(entity.getParentId());
        //分类信息
        if (entity.getFileTypeId() == null) {
            entity.setFileTypeId(fileCaseEntity.getFileTypeId());
            entity.setFileTypeName(fileCaseEntity.getFileTypeName());
        }
        if (fileCaseEntity != null && fileCaseEntity.getProjectId() != null){
            entity.setProjectId(fileCaseEntity.getProjectId());
            entity.setProjectName(fileCaseEntity.getProjectName());
        }
        //归档状态
        //entity.setFilingState("未归档");

        service.saveOrUpdate(entity, false);

        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getFileIds()) ){
            for (Long fileId : saveOrUpdateVO.getFileIds()) {
                FileRecordEntity fileRecordEntity = recordService.selectById(fileId);
                if (fileRecordEntity.getBillId() == -1L){
                    fileRecordEntity.setBillId(entity.getId());
                    recordService.saveOrUpdate(fileRecordEntity);
                }
            }
        }
        FileMetafileReplenishVO vo = BeanMapper.map(entity, FileMetafileReplenishVO.class);


        QueryWrapper<FileRecordEntity> ae = new QueryWrapper<>();
        ae.eq("bill_id",entity.getId() );
        ae.eq("dr",0);
        List<FileRecordEntity> list = recordService.list(ae);
        if (CollectionUtils.isNotEmpty(list)){
            List<FileBtnDTO> fileList  = new ArrayList<>();

            for (FileRecordEntity fileRecordEntity : list) {
                FileBtnDTO fileBtnDTO = new FileBtnDTO();
                FileResponseDTO fileResponseDTO = new FileResponseDTO();

                String objectUrl = utils.getObjectUrl(fileRecordEntity.getFilePath());

                fileBtnDTO.setUid(fileRecordEntity.getId()+"");
                fileBtnDTO.setName(fileRecordEntity.getFileName());
                fileBtnDTO.setStatus("done");
                fileBtnDTO.setUrl(objectUrl);

                fileResponseDTO.setCode("0");
                fileResponseDTO.setMsg("success");
                fileResponseDTO.setName(fileRecordEntity.getFileName());
                fileResponseDTO.setFileName(fileRecordEntity.getFileName());
                fileResponseDTO.setUrl(objectUrl);
                fileResponseDTO.setFilePath(fileRecordEntity.getFilePath());
                fileResponseDTO.setFileId(fileRecordEntity.getId()+"");
                fileBtnDTO.setResponse(fileResponseDTO);

                fileList.add(fileBtnDTO);
            }
            vo.setFileList(fileList);
            entity.setFileUploadNum(list.size());
        }else {
            entity.setFileUploadNum(0);
        }

        service.saveOrUpdate(entity);
        vo.setFileUploadNum(entity.getFileUploadNum());
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FileMetafileReplenishVO> queryDetail(Long id) {
    	FileMetafileReplenishEntity entity = service.selectById(id);
    	FileMetafileReplenishVO vo = BeanMapper.map(entity, FileMetafileReplenishVO.class);
        /**
         *  判断当前人员是否拥有查看附件的权限 1.制单人 2.管理员 3.借阅人
         */
        boolean viewFlag = false;
        UserContext userContextCache = sessionManager.getUserContext();
        List<Long> roleIds = new ArrayList<>();
        roleIds.add(roleId);
        CommonResponse<List<RoleUserRelationVO>> roleResp = roleApi.getRoleUser(roleIds, null);
        if(!roleResp.isSuccess()){
            throw new BusinessException("网络异常，获取发送信息角色， 请稍后再试");
        }
        List<RoleUserRelationVO> relationVOS = roleResp.getData();
        List<String> userIds = relationVOS.stream().map(RoleUserRelationVO::getUserId).map(Object::toString).collect(Collectors.toList());

        //logger.info("管理员:{}",JSONObject.toJSONString(relationVOS));

        if (userIds.contains(userContextCache.getUserId().toString())){
            viewFlag = true;
        }

        //1制单人
        if (vo.getCreateUserId().equals(userContextCache.getUserId())) {
            viewFlag = true;
        }

        //3借阅人
        //当前表单的id==借阅单子表fileBillId 且 借阅单主表审批通过 且 借阅单子表未归还
        Integer borrowDetailByBillIdAndUserId = borrowDetailMapper.getBorrowDetailByBillIdAndUserId(vo.getId(), userContextCache.getUserId());
        Integer borrowDetailByBillIdAndUserId1 = borrowDetailMapper.getBorrowDetailByBillIdAndUserId(vo.getParentId(), userContextCache.getUserId());
        if (borrowDetailByBillIdAndUserId > 0 || borrowDetailByBillIdAndUserId1 > 0){
            viewFlag = true;
        }

        logger.info("当前浏览文件的人员:{},文档id:{},是否有权限:{}",userContextCache.getUserName(),id,viewFlag);

        QueryWrapper<FileRecordEntity> ae = new QueryWrapper<>();
        ae.eq("bill_id",entity.getId() );
        ae.eq("dr",0);
        List<FileRecordEntity> list = recordService.list(ae);
        if (CollectionUtils.isNotEmpty(list)){
            List<FileBtnDTO> fileList  = new ArrayList<>();

            for (FileRecordEntity fileRecordEntity : list) {
                FileBtnDTO fileBtnDTO = new FileBtnDTO();
                FileResponseDTO fileResponseDTO = new FileResponseDTO();

                String objectUrl = utils.getObjectUrl(fileRecordEntity.getFilePath());

                fileBtnDTO.setUid(fileRecordEntity.getId()+"");
                fileBtnDTO.setName(fileRecordEntity.getFileName());
                fileBtnDTO.setStatus("done");
                if (viewFlag) {
                    fileBtnDTO.setUrl(objectUrl);

                }
                fileResponseDTO.setCode("0");
                fileResponseDTO.setMsg("success");
                fileResponseDTO.setName(fileRecordEntity.getFileName());
                fileResponseDTO.setFileName(fileRecordEntity.getFileName());
                if (viewFlag) {
                    fileResponseDTO.setUrl(objectUrl);
                    fileResponseDTO.setFilePath(fileRecordEntity.getFilePath());
                }
                fileResponseDTO.setFileId(fileRecordEntity.getId()+"");
                fileBtnDTO.setResponse(fileResponseDTO);

                fileList.add(fileBtnDTO);
            }
            vo.setFileList(fileList);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileMetafileReplenishVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (FileMetafileReplenishVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FileMetafileReplenishVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileMetafileReplenishVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<FileMetafileReplenishEntity> page = service.queryPage(param,false);
        IPage<FileMetafileReplenishVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileMetafileReplenishVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FileMetafileReplenishEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileMetafileReplenish-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refFileMetafileReplenishData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FileMetafileReplenishVO>> refFileMetafileReplenishData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FileMetafileReplenishEntity> page = service.queryPage(param,false);
        IPage<FileMetafileReplenishVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileMetafileReplenishVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
