package com.ejianc.business.filesystem.file.controller.api;

import com.ejianc.business.filesystem.common.MyFileController;
import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.business.filesystem.file.vo.FileCaseVO;
import com.ejianc.business.filesystem.file.vo.FileMetafileVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import feign.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;


@RestController
@RequestMapping("/api/file/")
public class HashFileApi {
    @Autowired
    private IFileMetafileService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private MyFileController myFileController;
    /**
     *
    */
    @RequestMapping(value = "filePush", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> filePush(@RequestBody FileMetafileVO vo){
        FileMetafileEntity entity = BeanMapper.map(vo, FileMetafileEntity.class);

        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            entity.setBillCode(billCode.getData());//此处需要根据实际

        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        //归档状态
        entity.setFilingState("未归档");

        service.saveOrUpdate(entity);

        boolean flag = false;

        //复制附件
        if (entity.getBillAddress() != null && entity.getBillAddress().indexOf("id=") != -1) {
            String[] parts = entity.getBillAddress().split("id=");
            if(parts[1] != null) {
                //查询该单据的所有附件
                CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(Long.parseLong(parts[1]),null,null,null);
                //下载附件
                if (listCommonResponse != null && listCommonResponse.isSuccess()){
                    for (AttachmentVO attachmentVO : listCommonResponse.getData()) {
                        Response response = attachmentApi.downloadFileById(attachmentVO.getId());
                        InputStream inputStream = null;
                        try {
                            inputStream = response.body().asInputStream();
                        } catch (IOException e) {
                            flag = true;
                        }
                        if (inputStream != null) {
                            MultipartFile multipartFile = convertToMultipartFile(inputStream, attachmentVO.getFileName());
                            myFileController.uploadFile(multipartFile,entity.getId());
                        }else {
                            flag = true;
                        }
                    }
                }else {
                    flag = true;
                }

                if (flag) {
                    //文件推送失败
                    entity.setRemark("附件下载失败，请重新下载");
                    service.saveOrUpdate(entity);
                }
                //上传附件
                //更新附件表
            }
        }
        return CommonResponse.success("保存成功！");
    }
    @RequestMapping(value = "pushFileHistory", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> pushFileHistory(){
        QueryParam param = new QueryParam();
        param.getParams().put("source", new Parameter(QueryParam.EQ, "企业业绩推送"));
        List<FileMetafileEntity> fileMetafileEntities = service.queryList(param);
        if (CollectionUtils.isNotEmpty(fileMetafileEntities)) {
            int i = 0;
            for (FileMetafileEntity entity : fileMetafileEntities) {
                //复制附件
                if (entity.getBillAddress() != null && entity.getBillAddress().indexOf("id=") != -1) {
                    String[] parts = entity.getBillAddress().split("id=");
                    if (parts[1] != null) {
                        //查询该单据的所有附件
                        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(Long.parseLong(parts[1]), null, null, null);
                        //下载附件
                        if (listCommonResponse != null && listCommonResponse.isSuccess()) {
                            for (AttachmentVO attachmentVO : listCommonResponse.getData()) {
                                Response response = attachmentApi.downloadFileById(attachmentVO.getId());
                                InputStream inputStream = null;
                                try {
                                    inputStream = response.body().asInputStream();
                                } catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                                if (inputStream != null) {
                                    MultipartFile multipartFile = convertToMultipartFile(inputStream, attachmentVO.getFileName());
                                    myFileController.uploadFile(multipartFile, entity.getId());
                                }
                            }
                        }
                        //上传附件
                        //更新附件表
                    }
                }
                i++;
                logger.info("已完成第{}项，共{}项",  i, fileMetafileEntities.size());
            }
        }
        return CommonResponse.success("保存成功！");
    }
    /**
     *
     */
    @RequestMapping(value = "filePull", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> filePull(@RequestBody FileMetafileVO vo){
        FileMetafileEntity entity = BeanMapper.map(vo, FileMetafileEntity.class);
        QueryParam param = new QueryParam();
        param.getParams().put("billAddress", new Parameter(QueryParam.EQ, entity.getBillAddress()));

        List<FileMetafileEntity> fileMetafileEntities = service.queryList(param);
        if (CollectionUtils.isNotEmpty(fileMetafileEntities)){
            for (FileMetafileEntity fileMetafileEntity : fileMetafileEntities) {
                if (!("在库".equals(fileMetafileEntity.getBorrowState()))){
                    return CommonResponse.error("已经借出，不能撤回！");
                }

                if ("已归档".equals(fileMetafileEntity.getFilingState())){
                    return CommonResponse.error("已经借出，不能撤回！");
                }
            }
        }else {
            return CommonResponse.success("此荣誉未推送档案系统，可以撤回！");
        }

        service.removeByIds(fileMetafileEntities.stream().map(FileMetafileEntity::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("撤回成功！");
    }

    public MultipartFile convertToMultipartFile(InputStream inputStream, String fileName) {
        DiskFileItem fileItem = (DiskFileItem) new DiskFileItemFactory().createItem("file", "text/plain", true, fileName);
        try (OutputStream os = fileItem.getOutputStream()) {
            IOUtils.copy(inputStream, os);
        } catch (IOException e) {
            // 处理异常
            return null;
        }
        return new CommonsMultipartFile(fileItem);
    }
}
