package com.ejianc.business.filesystem.file.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.filesystem.file.bean.FileBorrowDetailEntity;
import com.ejianc.business.filesystem.file.bean.FileBorrowEntity;
import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.service.IFileBorrowService;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.stream.Collectors;

@Service("fileBorrow") 
public class FileBorrowBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IFileBorrowService service;
	@Autowired
	private IFileCaseService caseService;
	@Autowired
	private IFileMetafileService metafileService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		//被借阅走的则不允许再借阅
		FileBorrowEntity fileBorrowEntity = service.selectById(billId);
		if (fileBorrowEntity != null){
			List<FileBorrowDetailEntity> fileBorrowDetailList = fileBorrowEntity.getFileBorrowDetailList();
			List<Long> fillBillIds = fileBorrowDetailList.stream().map(FileBorrowDetailEntity::getFileBillId).collect(Collectors.toList());

			if (fileBorrowEntity.getBorrowType() == 1){
				//纸质档
				if (fileBorrowEntity.getBorrowFileKind() == 1){
					//案卷
					QueryParam paramCase = new QueryParam();
					paramCase.getParams().put("id",new Parameter(QueryParam.IN,fillBillIds));
					List<FileCaseEntity> fileCaseEntities = caseService.queryList(paramCase);
					if (CollectionUtils.isNotEmpty(fileCaseEntities)) {
						for (FileCaseEntity fileCaseEntity : fileCaseEntities) {
							if ("借出".equals(fileCaseEntity.getBorrowState())){
								return CommonResponse.error(fileCaseEntity.getReference()+"已经被借走啦！");
							}
						}

						List<Long> collect = fileCaseEntities.stream().map(FileCaseEntity::getId).collect(Collectors.toList());
						QueryParam paramFile = new QueryParam();
						paramFile.getParams().put("parentId", new Parameter(QueryParam.IN, collect));
						List<FileMetafileEntity> fileMetafileEntities = metafileService.queryList(paramFile);
						if (CollectionUtils.isNotEmpty(fileMetafileEntities)) {
							for (FileMetafileEntity fileMetafileEntitiy : fileMetafileEntities) {
								if ("借出".equals(fileMetafileEntitiy.getBorrowState())){
									return CommonResponse.error(fileMetafileEntitiy.getReference()+"已经被借走啦！");
								}
							}

						}
					}

				}else {
					//文件
					QueryParam paramCase = new QueryParam();
					paramCase.getParams().put("id",new Parameter(QueryParam.IN,fillBillIds));
					List<FileMetafileEntity> fileMetafileEntities1 = metafileService.queryList(paramCase);

					if (CollectionUtils.isNotEmpty(fileMetafileEntities1)) {
						for (FileMetafileEntity fileMetafileEntity : fileMetafileEntities1) {
							if ("借出".equals(fileMetafileEntity.getBorrowState())){
								return CommonResponse.error(fileMetafileEntity.getReference()+"已经被借走啦！");
							}
						}

						List<Long> collect = fileMetafileEntities1.stream().map(FileMetafileEntity::getParentId).collect(Collectors.toList());
						QueryParam paramFile = new QueryParam();
						paramFile.getParams().put("id", new Parameter(QueryParam.IN, collect));
						List<FileCaseEntity> fileCaseEntities = caseService.queryList(paramFile);

						if (CollectionUtils.isNotEmpty(fileCaseEntities)) {
							for (FileCaseEntity fileCaseEntity : fileCaseEntities) {
								if ("在库".equals(fileCaseEntity.getBorrowState())) {
									if ("借出".equals(fileCaseEntity.getBorrowState())){
										return CommonResponse.error(fileCaseEntity.getReference()+"已经被借走啦！");
									}
								}
							}
						}
					}
				}

			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		//审核完成回写案卷或文件的借阅状态；
		// 借阅单元为案卷的
		FileBorrowEntity fileBorrowEntity = service.selectById(billId);
		if (fileBorrowEntity != null){
			List<FileBorrowDetailEntity> fileBorrowDetailList = fileBorrowEntity.getFileBorrowDetailList();
			List<Long> fillBillIds = fileBorrowDetailList.stream().map(FileBorrowDetailEntity::getFileBillId).collect(Collectors.toList());

			if (fileBorrowEntity.getBorrowType() == 1){
				//纸质档
				if (fileBorrowEntity.getBorrowFileKind() == 1){
					//案卷
					QueryParam paramCase = new QueryParam();
					paramCase.getParams().put("id",new Parameter(QueryParam.IN,fillBillIds));
					List<FileCaseEntity> fileCaseEntities = caseService.queryList(paramCase);
					if (CollectionUtils.isNotEmpty(fileCaseEntities)) {
						for (FileCaseEntity fileCaseEntity : fileCaseEntities) {
							fileCaseEntity.setBorrowState("借出");
						}
						caseService.saveOrUpdateBatch(fileCaseEntities);


						List<Long> collect = fileCaseEntities.stream().map(FileCaseEntity::getId).collect(Collectors.toList());
						QueryParam paramFile = new QueryParam();
						paramFile.getParams().put("parentId", new Parameter(QueryParam.IN, collect));
						List<FileMetafileEntity> fileMetafileEntities = metafileService.queryList(paramFile);
						if (CollectionUtils.isNotEmpty(fileMetafileEntities)) {
							for (FileMetafileEntity fileMetafileEntitiy : fileMetafileEntities) {
								fileMetafileEntitiy.setBorrowState("借出");
								fileMetafileEntitiy.setBorrowNum(fileMetafileEntitiy.getBorrowNum()+1);
							}
							metafileService.saveOrUpdateBatch(fileMetafileEntities);
						}
					}

				}else {
					//文件
					QueryParam paramCase = new QueryParam();
					paramCase.getParams().put("id",new Parameter(QueryParam.IN,fillBillIds));
					List<FileMetafileEntity> fileMetafileEntities1 = metafileService.queryList(paramCase);

					if (CollectionUtils.isNotEmpty(fileMetafileEntities1)) {
						for (FileMetafileEntity fileMetafileEntity : fileMetafileEntities1) {
							fileMetafileEntity.setBorrowState("借出");
							fileMetafileEntity.setBorrowNum(fileMetafileEntity.getBorrowNum()+1);
						}
						metafileService.saveOrUpdateBatch(fileMetafileEntities1);


						List<Long> collect = fileMetafileEntities1.stream().map(FileMetafileEntity::getParentId).collect(Collectors.toList());
						QueryParam paramFile = new QueryParam();
						paramFile.getParams().put("id", new Parameter(QueryParam.IN, collect));
						List<FileCaseEntity> fileCaseEntities = caseService.queryList(paramFile);

						if (CollectionUtils.isNotEmpty(fileCaseEntities)) {
							for (FileCaseEntity fileCaseEntity : fileCaseEntities) {
								if ("在库".equals(fileCaseEntity.getBorrowState())) {
									fileCaseEntity.setBorrowState("子文件借出");
								}
							}
							caseService.saveOrUpdateBatch(fileCaseEntities);
						}
					}
				}

			}else {
				//电子档

				//文件
				QueryParam paramCase = new QueryParam();
				paramCase.getParams().put("id",new Parameter(QueryParam.IN,fillBillIds));
				List<FileMetafileEntity> fileMetafileEntities1 = metafileService.queryList(paramCase);

				if (CollectionUtils.isNotEmpty(fileMetafileEntities1)) {
					for (FileMetafileEntity fileMetafileEntity : fileMetafileEntities1) {
						fileMetafileEntity.setBorrowState("借出");
						fileMetafileEntity.setBorrowNum(fileMetafileEntity.getBorrowNum()+1);
					}
					metafileService.saveOrUpdateBatch(fileMetafileEntities1);


					List<Long> collect = fileMetafileEntities1.stream().map(FileMetafileEntity::getParentId).collect(Collectors.toList());
					QueryParam paramFile = new QueryParam();
					paramFile.getParams().put("id", new Parameter(QueryParam.IN, collect));
					List<FileCaseEntity> fileCaseEntities = caseService.queryList(paramFile);

					if (CollectionUtils.isNotEmpty(fileCaseEntities)) {
						for (FileCaseEntity fileCaseEntity : fileCaseEntities) {
							if ("在库".equals(fileCaseEntity.getBorrowState())) {
								fileCaseEntity.setBorrowState("子文件借出");
							}
						}
						caseService.saveOrUpdateBatch(fileCaseEntities);
					}
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		return CommonResponse.error("借阅流程无法撤回！请走归还流程！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
