package com.ejianc.business.filesystem.file.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.filesystem.file.mapper.FileCaseMapper;
import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.business.filesystem.file.service.IFileCaseService;

import java.util.Date;
import java.util.List;
import java.util.stream.Stream;

/**
 * 案卷(文书、工程)
 * 
 * @author generator
 * 
 */
@Service("fileCaseService")
public class FileCaseServiceImpl extends BaseServiceImpl<FileCaseMapper, FileCaseEntity> implements IFileCaseService{

    @Autowired
    private IFileMetafileService fileMetafileService;
    @Override
    public void updateFilingState(Long projectId) {

        QueryParam param = new QueryParam();
        param.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
        List<FileCaseEntity> fileCaseEntities = this.queryList(param);
        if (CollectionUtils.isNotEmpty(fileCaseEntities)) {
            for (FileCaseEntity fileCaseEntity : fileCaseEntities) {
                if(fileCaseEntity.getBillState() == 1 || fileCaseEntity.getBillState() == 3) {
                    //文件的归档状态变更
                    fileMetafileService.updateFilingState(fileCaseEntity.getId());
                }else {
                    throw new BusinessException("案卷未提交!"+fileCaseEntity.getReference());
                }
            }
        }

        LambdaUpdateWrapper<FileCaseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(FileCaseEntity::getFilingState, "已归档");
        updateWrapper.eq(FileCaseEntity::getProjectId, projectId);
        this.update(updateWrapper);


    }
}
