package com.ejianc.business.filesystem.file.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.filesystem.file.bean.*;
import com.ejianc.business.filesystem.file.service.*;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("fileReturn") 
public class FileReturnBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IFileReturnService service;
	@Autowired
	private IFileReturnDetailService returnDetailService;
	@Autowired
	private IFileBorrowService borrowService;
	@Autowired
	private IFileBorrowDetailService borrowDetailService;
	@Autowired
	private IFileCaseService caseService;
	@Autowired
	private IFileMetafileService metafileService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//
		FileReturnEntity fileReturnEntity = service.selectById(billId);
		if (fileReturnEntity != null){
			List<FileReturnDetailEntity> fileReturnDetailList = fileReturnEntity.getFileReturnDetailList();

			if (CollectionUtils.isNotEmpty(fileReturnDetailList)){
				//先更新借出子表的归还状态、归还时间
				List<Long> detailIds = fileReturnDetailList.stream().map(FileReturnDetailEntity::getBorrowDetailId).collect(Collectors.toList());
				LambdaUpdateWrapper<FileBorrowDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
				updateWrapper.set(FileBorrowDetailEntity::getBorrowEndTime, new Date());
				updateWrapper.set(FileBorrowDetailEntity::getIsReturn, 1);
				updateWrapper.in(FileBorrowDetailEntity::getId, detailIds);
				borrowDetailService.update(updateWrapper);

				//再开始更新案卷、文件的状态

				List<Long> caseIdsList = new ArrayList<>();

				//先更新文件的状态
				Map<Integer, List<FileReturnDetailEntity>> collect =
						fileReturnDetailList.stream().collect(Collectors.groupingBy(s -> s.getBorrowType()));

				if (collect.containsKey(2)) {
					//电子档
					List<FileReturnDetailEntity> fileReturnDetailEntities = collect.get(2);
					//只有文件
					List<Long> fileBillIds = fileReturnDetailEntities.stream().map(FileReturnDetailEntity::getFileBillId).collect(Collectors.toList());
					QueryParam paramFile = new QueryParam();
					paramFile.getParams().put("id", new Parameter(QueryParam.IN, fileBillIds));
					List<FileMetafileEntity> fileMetafileEntities = metafileService.queryList(paramFile);
					if (CollectionUtils.isNotEmpty(fileMetafileEntities)){
						for (FileMetafileEntity fileMetafileEntity : fileMetafileEntities) {
							List<FileBorrowDetailEntity> borrowDetailCase = borrowDetailService.getBorrowDetailByBillId(fileMetafileEntity.getParentId());
							List<FileBorrowDetailEntity> borrowDetailFile = borrowDetailService.getBorrowDetailByBillId(fileMetafileEntity.getId());
							if (CollectionUtils.isNotEmpty(borrowDetailCase)) {//文件所属案卷被借出
								if (CollectionUtils.isNotEmpty(borrowDetailFile)) {
									fileMetafileEntity.setBorrowNum(borrowDetailFile.size()+1);
									fileMetafileEntity.setBorrowState("借出");
								} else {
									fileMetafileEntity.setBorrowNum(1);
									fileMetafileEntity.setBorrowState("借出");
								}
							}else {
								//文件所属案卷未被借出
								if (CollectionUtils.isNotEmpty(borrowDetailFile)) {
									fileMetafileEntity.setBorrowNum(borrowDetailFile.size());
									fileMetafileEntity.setBorrowState("借出");
								} else {
									fileMetafileEntity.setBorrowNum(0);
									fileMetafileEntity.setBorrowState("在库");
								}
							}
							caseIdsList.add(fileMetafileEntity.getParentId());
						}
						metafileService.saveOrUpdateBatch(fileMetafileEntities);
					}

				}

				if (collect.containsKey(1)) {
					//纸质档
					List<FileReturnDetailEntity> fileReturnDetailEntities = collect.get(1);
					Map<Integer, List<FileReturnDetailEntity>> fileKindMap =
							fileReturnDetailEntities.stream().collect(Collectors.groupingBy(s -> s.getBorrowFileKind()));

					if (fileKindMap.containsKey(1)) {
						//案卷
						List<FileReturnDetailEntity> fileKindList1 = fileKindMap.get(1);
						List<Long> fileBillIds = fileKindList1.stream().map(FileReturnDetailEntity::getFileBillId).collect(Collectors.toList());

						QueryParam paramFile = new QueryParam();
						paramFile.getParams().put("parentId", new Parameter(QueryParam.IN, fileBillIds));
						List<FileMetafileEntity> fileMetafileEntities = metafileService.queryList(paramFile);
						if (CollectionUtils.isNotEmpty(fileMetafileEntities)) {
							for (FileMetafileEntity fileMetafileEntity : fileMetafileEntities) {
								List<FileBorrowDetailEntity> borrowDetailCase = borrowDetailService.getBorrowDetailByBillId(fileMetafileEntity.getParentId());
								List<FileBorrowDetailEntity> borrowDetailFile = borrowDetailService.getBorrowDetailByBillId(fileMetafileEntity.getId());
								if (CollectionUtils.isNotEmpty(borrowDetailCase)) {//文件所属案卷被借出
									if (CollectionUtils.isNotEmpty(borrowDetailFile)) {
										fileMetafileEntity.setBorrowNum(borrowDetailFile.size()+1);
										fileMetafileEntity.setBorrowState("借出");
									} else {
										fileMetafileEntity.setBorrowNum(1);
										fileMetafileEntity.setBorrowState("借出");
									}
								}else {
									//文件所属案卷未被借出
									if (CollectionUtils.isNotEmpty(borrowDetailFile)) {
										fileMetafileEntity.setBorrowNum(borrowDetailFile.size());
										fileMetafileEntity.setBorrowState("借出");
									} else {
										fileMetafileEntity.setBorrowNum(0);
										fileMetafileEntity.setBorrowState("在库");
									}
								}
							}
							metafileService.saveOrUpdateBatch(fileMetafileEntities);
						}

						caseIdsList.addAll(fileBillIds);
					}

					if (fileKindMap.containsKey(2)) {
						//文件
						List<FileReturnDetailEntity> fileKindList2 = fileKindMap.get(2);
						//文件改为在库
						List<Long> fileBillIds = fileKindList2.stream().map(FileReturnDetailEntity::getFileBillId).collect(Collectors.toList());
						QueryParam paramFile = new QueryParam();
						paramFile.getParams().put("id", new Parameter(QueryParam.IN, fileBillIds));
						List<FileMetafileEntity> fileMetafileEntities = metafileService.queryList(paramFile);
						for (FileMetafileEntity fileMetafileEntity : fileMetafileEntities) {
							fileMetafileEntity.setBorrowState("在库");
							fileMetafileEntity.setBorrowNum(0);
							caseIdsList.add(fileMetafileEntity.getParentId());
						}
						metafileService.saveOrUpdateBatch(fileMetafileEntities);
					}
				}
				//统一调整案卷的借阅状态
				service.updateCaseBorrowStateByCaseId(caseIdsList);

			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("已归还，不允许撤回！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


}
