/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.filesystem.common;

import com.ejianc.business.filesystem.config.MinioConfiguration;
import com.ejianc.framework.auth.session.SessionManager;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.http.Method;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioUtils {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private MinioClient client;
    @Autowired
    private MinioConfiguration minioConfiguration;

    public void createBucket(String bucketName) {
        boolean found = this.client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        if (!found) {
            this.client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).region("cn-beijing")).build());
        }
    }

    public void removeBucket(String bucketName) {
        this.client.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
    }

    public ObjectStat getObjectInfo(String objectName) {
        String bucketName = this.minioConfiguration.getBucketName();
        ObjectStat objectStat = this.client.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
        return objectStat;
    }

    public InputStream getObjectInputStream(String objectName) {
        String bucketName = this.minioConfiguration.getBucketName();
        InputStream object = this.client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
        return object;
    }

    public HttpServletResponse downloadFile(String originalName, String userName, String orgName, HttpServletResponse response) {
        String bucketName = this.minioConfiguration.getBucketName();
        InputStream file = this.client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(originalName)).build());
        String filename = new String(originalName.getBytes("ISO8859-1"), StandardCharsets.UTF_8);
        if (StringUtils.isNotBlank((CharSequence)originalName)) {
            filename = originalName;
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + filename);
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex > 0 && ("pdf".equals(filename.substring(dotIndex + 1)) || "PDF".equals(filename.substring(dotIndex + 1)))) {
            PdfReader reader = new PdfReader(file);
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)response.getOutputStream());
            int pageCount = reader.getNumberOfPages();
            stamper.close();
            reader.close();
            file.close();
        } else {
            int len;
            ServletOutputStream servletOutputStream = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = file.read(buffer)) > 0) {
                servletOutputStream.write(buffer, 0, len);
            }
            servletOutputStream.flush();
            file.close();
            servletOutputStream.close();
        }
        return response;
    }

    public HttpServletResponse downloadFileOld(String originalName, HttpServletResponse response) {
        int len;
        String bucketName = this.minioConfiguration.getBucketName();
        InputStream file = this.client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(originalName)).build());
        String filename = new String(originalName.getBytes("ISO8859-1"), StandardCharsets.UTF_8);
        if (StringUtils.isNotBlank((CharSequence)originalName)) {
            filename = originalName;
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + filename);
        ServletOutputStream servletOutputStream = response.getOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = file.read(buffer)) > 0) {
            servletOutputStream.write(buffer, 0, len);
        }
        servletOutputStream.flush();
        file.close();
        servletOutputStream.close();
        return response;
    }

    public void putObject(String objectName, InputStream stream, Long fileSize, String type) throws Exception {
        String bucketName = this.minioConfiguration.getBucketName();
        this.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(stream, fileSize.longValue(), -1L).contentType(type).build());
    }

    public String minioUpload(MultipartFile file, String fileName) throws Exception {
        String bucketName = this.minioConfiguration.getBucketName();
        if (fileName == null) {
            fileName = file.getOriginalFilename();
            fileName = fileName.replaceAll(" ", "_");
        }
        InputStream inputStream = file.getInputStream();
        PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream(inputStream, file.getSize(), -1L).contentType(file.getContentType()).build();
        ObjectWriteResponse objectWriteResponse = this.client.putObject(objectArgs);
        String etag = objectWriteResponse.etag();
        return etag;
    }

    public Boolean folderExists(String prefix) {
        String bucketName = this.minioConfiguration.getBucketName();
        Iterable results = this.client.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).prefix(prefix).recursive(false).build());
        for (Result result : results) {
            Item item = (Item)result.get();
            if (!item.isDir()) continue;
            return true;
        }
        return false;
    }

    public void createFolder(String path) {
        String bucketName = this.minioConfiguration.getBucketName();
        this.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(path + "/")).stream((InputStream)new ByteArrayInputStream(new byte[0]), 0L, -1L).build());
    }

    public String getObjectUrl(String objectName) {
        String bucketName = this.minioConfiguration.getBucketName();
        return this.client.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).build());
    }
}

