/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.filesystem.common;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.filesystem.common.MinioUtils;
import com.ejianc.business.filesystem.file.bean.FileRecordEntity;
import com.ejianc.business.filesystem.file.service.IFileRecordService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Calendar;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"myFile"})
public class MyFileController {
    @Autowired
    private IFileRecordService service;
    @Autowired
    private MinioUtils utils;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<String> queryDetail() {
        this.utils.createFolder("123321/");
        return CommonResponse.success();
    }

    @RequestMapping(value={"/queryDetail2"}, method={RequestMethod.GET})
    public CommonResponse<String> queryDetail2() {
        Boolean xixixi = this.utils.folderExists("123321");
        return CommonResponse.success();
    }

    @RequestMapping(value={"/noAuth/getObjectInfo"}, method={RequestMethod.GET})
    public void getObjectInfo(String name, HttpServletResponse response) {
        UserContext userContextCache = this.sessionManager.getUserContext();
        response = this.utils.downloadFile(name, userContextCache.getUserName(), userContextCache.getOrgName(), response);
    }

    @RequestMapping(value={"/getObjectUrl"}, method={RequestMethod.GET})
    public String getObjectUrl(String name) {
        return this.utils.getObjectUrl(name);
    }

    @PostMapping(value={"/noAuth/uploadFile"})
    public JSONObject uploadFile(@RequestBody MultipartFile file, Long billId) {
        JSONObject jsonObject = new JSONObject();
        try {
            Calendar calendar = Calendar.getInstance();
            String yearMonth = calendar.get(1) + "-" + (calendar.get(2) + 1);
            String day = calendar.get(5) + "";
            Boolean yearMonth1 = this.utils.folderExists(yearMonth + "/" + day);
            if (!yearMonth1.booleanValue()) {
                this.utils.createFolder(yearMonth + "/" + day);
            }
            String fileName = System.currentTimeMillis() + "_" + file.getOriginalFilename();
            String s = this.utils.minioUpload(file, yearMonth + "/" + day + "/" + fileName);
            String objectUrl = this.utils.getObjectUrl(yearMonth + "/" + day + "/" + fileName);
            jsonObject.put("code", (Object)0);
            jsonObject.put("msg", (Object)"success");
            jsonObject.put("url", (Object)objectUrl);
            jsonObject.put("filePath", (Object)(yearMonth + "/" + day + "/" + fileName));
            jsonObject.put("fileName", (Object)fileName);
            FileRecordEntity entity = new FileRecordEntity();
            if (billId == null) {
                entity.setBillId(-1L);
            } else {
                entity.setBillId(billId);
            }
            entity.setFileName(file.getOriginalFilename());
            entity.setFilePath(yearMonth + "/" + day + "/" + fileName);
            entity.setTenantId(999999L);
            entity.setIsCopy(0);
            this.service.saveOrUpdate((Object)entity, false);
            jsonObject.put("fileId", (Object)entity.getId());
            return jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            jsonObject.put("code", (Object)1);
            jsonObject.put("msg", (Object)"\u4e0a\u4f20\u5931\u8d25\uff01");
            return jsonObject;
        }
    }

    @RequestMapping(value={"/noAuth/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(String fileName) {
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        stringStringHashMap.put("file_path", fileName);
        boolean b = this.service.removeByMap(stringStringHashMap);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

