/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.filesystem.file.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.filesystem.file.bean.FileProjectEntity;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileProjectService;
import com.ejianc.business.filesystem.file.service.IFileTypeService;
import com.ejianc.business.filesystem.file.vo.FileProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"fileProject"})
public class FileProjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IFileProjectService service;
    @Autowired
    private IFileTypeService typeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IFileCaseService caseService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FileProjectVO> saveOrUpdate(@RequestBody FileProjectVO saveOrUpdateVO) {
        FileProjectEntity entity = (FileProjectEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FileProjectEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateUserName(userContextCache.getUserName());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        entity.setBillCode(entity.getProjectCode());
        entity.setFilingState("\u672a\u5f52\u6863");
        this.service.saveOrUpdate((Object)entity, false);
        FileProjectVO vo = (FileProjectVO)BeanMapper.map((Object)((Object)entity), FileProjectVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FileProjectVO> queryDetail(Long id) {
        FileProjectEntity entity = (FileProjectEntity)((Object)this.service.selectById(id));
        FileProjectVO vo = (FileProjectVO)BeanMapper.map((Object)((Object)entity), FileProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileProjectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FileProjectVO fileProjectVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryFilingList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FileProjectVO>> queryFilingList(@RequestBody QueryParam param) {
        Parameter orgIdValue;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("keyword");
        fuzzyFields.add("memo");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("filingState", new Parameter("eq", (Object)"\u5df2\u5f52\u6863"));
        if (param.getParams().containsKey("parentId")) {
            String parentId = ((Parameter)param.getParams().get("parentId")).getValue().toString();
            QueryParam param1 = new QueryParam();
            param1.getParams().put("inner_code", new Parameter("like", (Object)parentId));
            List fileTypeEntities = this.typeService.queryList(param1);
            List collect = fileTypeEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            param.getParams().remove("parentId");
            param.getParams().put("parentId", new Parameter("in", collect));
        }
        Long orgId = (orgIdValue = (Parameter)param.getParams().get("orgId")) == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FileProjectVO>> queryList(@RequestBody QueryParam param) {
        Parameter orgIdValue;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("keyword");
        fuzzyFields.add("memo");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("filingState", new Parameter("eq", (Object)"\u672a\u5f52\u6863"));
        if (param.getParams().containsKey("parentId")) {
            String parentId = ((Parameter)param.getParams().get("parentId")).getValue().toString();
            QueryParam param1 = new QueryParam();
            param1.getParams().put("inner_code", new Parameter("like", (Object)parentId));
            List fileTypeEntities = this.typeService.queryList(param1);
            List collect = fileTypeEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            param.getParams().remove("parentId");
            param.getParams().put("parentId", new Parameter("in", collect));
        }
        Long orgId = (orgIdValue = (Parameter)param.getParams().get("orgId")) == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileProject-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFileProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FileProjectVO>> refFileProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateFilingState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateFilingState(Long id) {
        FileProjectEntity entity = (FileProjectEntity)((Object)this.service.selectById(id));
        if (entity.getFilingState() == "\u5df2\u5f52\u6863") {
            return CommonResponse.error((String)"\u5df2\u5f52\u6863\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u590d\u5f52\u6863\uff01");
        }
        if (entity.getBillState() != 1 && entity.getBillState() != 3) {
            return CommonResponse.error((String)"\u5ba1\u6279\u901a\u8fc7\u7684\u624d\u80fd\u5f52\u6863\uff01");
        }
        this.caseService.updateFilingState(id);
        entity.setFilingState("\u5df2\u5f52\u6863");
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u4fee\u6539\u5f52\u6863\u72b6\u6001\u6210\u529f\uff01");
    }
}

