/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.filesystem.file.controller.api;

import com.ejianc.business.filesystem.common.MyFileController;
import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.business.filesystem.file.vo.FileMetafileVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@RestController
@RequestMapping(value={"/api/file/"})
public class HashFileApi {
    @Autowired
    private IFileMetafileService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private MyFileController myFileController;

    @RequestMapping(value={"filePush"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> filePush(@RequestBody FileMetafileVO vo) {
        String[] parts;
        FileMetafileEntity entity = (FileMetafileEntity)((Object)BeanMapper.map((Object)vo, FileMetafileEntity.class));
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setBillCode((String)billCode.getData());
        entity.setFilingState("\u672a\u5f52\u6863");
        this.service.saveOrUpdate((Object)entity);
        boolean flag = false;
        if (entity.getBillAddress() != null && entity.getBillAddress().indexOf("id=") != -1 && (parts = entity.getBillAddress().split("id="))[1] != null) {
            CommonResponse listCommonResponse = this.attachmentApi.queryListBySourceId(Long.valueOf(Long.parseLong(parts[1])), null, null, null);
            if (listCommonResponse != null && listCommonResponse.isSuccess()) {
                for (AttachmentVO attachmentVO : (List)listCommonResponse.getData()) {
                    Response response = this.attachmentApi.downloadFileById(attachmentVO.getId());
                    InputStream inputStream = null;
                    try {
                        inputStream = response.body().asInputStream();
                    }
                    catch (IOException e) {
                        flag = true;
                    }
                    if (inputStream != null) {
                        MultipartFile multipartFile = this.convertToMultipartFile(inputStream, attachmentVO.getFileName());
                        this.myFileController.uploadFile(multipartFile, entity.getId());
                        continue;
                    }
                    flag = true;
                }
            } else {
                flag = true;
            }
            if (flag) {
                entity.setRemark("\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d");
                this.service.saveOrUpdate((Object)entity);
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"pushFileHistory"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> pushFileHistory() {
        QueryParam param = new QueryParam();
        param.getParams().put("source", new Parameter("eq", (Object)"\u4f01\u4e1a\u4e1a\u7ee9\u63a8\u9001"));
        List fileMetafileEntities = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)fileMetafileEntities)) {
            int i = 0;
            for (FileMetafileEntity entity : fileMetafileEntities) {
                CommonResponse listCommonResponse;
                String[] parts;
                if (entity.getBillAddress() != null && entity.getBillAddress().indexOf("id=") != -1 && (parts = entity.getBillAddress().split("id="))[1] != null && (listCommonResponse = this.attachmentApi.queryListBySourceId(Long.valueOf(Long.parseLong(parts[1])), null, null, null)) != null && listCommonResponse.isSuccess()) {
                    for (AttachmentVO attachmentVO : (List)listCommonResponse.getData()) {
                        Response response = this.attachmentApi.downloadFileById(attachmentVO.getId());
                        InputStream inputStream = null;
                        try {
                            inputStream = response.body().asInputStream();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        if (inputStream == null) continue;
                        MultipartFile multipartFile = this.convertToMultipartFile(inputStream, attachmentVO.getFileName());
                        this.myFileController.uploadFile(multipartFile, entity.getId());
                    }
                }
                this.logger.info("\u5df2\u5b8c\u6210\u7b2c{}\u9879\uff0c\u5171{}\u9879", (Object)(++i), (Object)fileMetafileEntities.size());
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"filePull"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> filePull(@RequestBody FileMetafileVO vo) {
        FileMetafileEntity entity = (FileMetafileEntity)((Object)BeanMapper.map((Object)vo, FileMetafileEntity.class));
        QueryParam param = new QueryParam();
        param.getParams().put("billAddress", new Parameter("eq", (Object)entity.getBillAddress()));
        List fileMetafileEntities = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)fileMetafileEntities)) {
            for (FileMetafileEntity fileMetafileEntity : fileMetafileEntities) {
                if (!"\u5728\u5e93".equals(fileMetafileEntity.getBorrowState())) {
                    return CommonResponse.error((String)"\u5df2\u7ecf\u501f\u51fa\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
                }
                if (!"\u5df2\u5f52\u6863".equals(fileMetafileEntity.getFilingState())) continue;
                return CommonResponse.error((String)"\u5df2\u7ecf\u501f\u51fa\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
            }
        } else {
            return CommonResponse.success((String)"\u6b64\u8363\u8a89\u672a\u63a8\u9001\u6863\u6848\u7cfb\u7edf\uff0c\u53ef\u4ee5\u64a4\u56de\uff01");
        }
        this.service.removeByIds(fileMetafileEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u64a4\u56de\u6210\u529f\uff01");
    }

    public MultipartFile convertToMultipartFile(InputStream inputStream, String fileName) {
        DiskFileItem fileItem = (DiskFileItem)new DiskFileItemFactory().createItem("file", "text/plain", true, fileName);
        try (OutputStream os = fileItem.getOutputStream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)os);
        }
        catch (IOException e) {
            return null;
        }
        return new CommonsMultipartFile((FileItem)fileItem);
    }
}

