package com.ejianc.business.filesystem.file.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.filesystem.file.bean.*;
import com.ejianc.business.filesystem.file.dto.FileBorrowDetailDTO;
import com.ejianc.business.filesystem.file.service.IFileBorrowDetailService;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.business.filesystem.file.service.IFileReturnService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.filesystem.file.service.IFileBorrowService;
import com.ejianc.business.filesystem.file.vo.FileBorrowVO;

/**
 * 文件借阅
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("fileBorrow")
public class FileBorrowController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IFileBorrowService service;
    @Autowired
    private IFileBorrowDetailService borrowDetailService;

    @Autowired
    private IFileMetafileService metafileService;

    @Autowired
    private IFileReturnService fileReturnService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FileBorrowVO> saveOrUpdate(@RequestBody FileBorrowVO saveOrUpdateVO) {
    	FileBorrowEntity entity = BeanMapper.map(saveOrUpdateVO, FileBorrowEntity.class);
        UserContext userContextCache = sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
        } else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
    	service.saveOrUpdate(entity, false);
    	FileBorrowVO vo = BeanMapper.map(entity, FileBorrowVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FileBorrowVO> queryDetail(Long id) {
    	FileBorrowEntity entity = service.selectById(id);
    	FileBorrowVO vo = BeanMapper.map(entity, FileBorrowVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileBorrowVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (FileBorrowVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FileBorrowVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileBorrowVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<FileBorrowEntity> page = service.queryPage(param,false);
        IPage<FileBorrowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileBorrowVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FileBorrowEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileBorrow-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refFileBorrowData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FileBorrowDetailDTO>> refFileBorrowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgid",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        Page<FileBorrowDetailDTO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<FileBorrowDetailDTO> fileBorrowDetailDTOS = service.refBorrowList(page, wrapper);

        IPage<FileBorrowDetailDTO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(fileBorrowDetailDTOS);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/autoReturn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> autoReturn(HttpServletRequest request) {
        
        //获取到期的电子档的借阅明细   文件、电子档、预计归还时间<现在
        List<FileBorrowDetailDTO> fileBorrowDetailList = service.autoReturnList();
        if (CollectionUtils.isNotEmpty(fileBorrowDetailList)){
            //先更新借出子表的归还状态、归还时间
            List<Long> detailIds = fileBorrowDetailList.stream().map(FileBorrowDetailDTO::getId).collect(Collectors.toList());
            LambdaUpdateWrapper<FileBorrowDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(FileBorrowDetailEntity::getBorrowEndTime, new Date());
            updateWrapper.set(FileBorrowDetailEntity::getIsReturn, 1);
            updateWrapper.in(FileBorrowDetailEntity::getId, detailIds);
            borrowDetailService.update(updateWrapper);

            //再开始更新案卷、文件的状态

            List<Long> caseIdsList = new ArrayList<>();

            //先更新文件的状态
                //电子档
                //只有文件
                List<Long> fileBillIds = fileBorrowDetailList.stream().map(FileBorrowDetailDTO::getFileBillId).collect(Collectors.toList());
                QueryParam paramFile = new QueryParam();
                paramFile.getParams().put("id", new Parameter(QueryParam.IN, fileBillIds));
                List<FileMetafileEntity> fileMetafileEntities = metafileService.queryList(paramFile);
                if (CollectionUtils.isNotEmpty(fileMetafileEntities)){
                    for (FileMetafileEntity fileMetafileEntity : fileMetafileEntities) {
                        List<FileBorrowDetailEntity> borrowDetailCase = borrowDetailService.getBorrowDetailByBillId(fileMetafileEntity.getParentId());
                        List<FileBorrowDetailEntity> borrowDetailFile = borrowDetailService.getBorrowDetailByBillId(fileMetafileEntity.getId());
                        if (CollectionUtils.isNotEmpty(borrowDetailCase)) {//文件所属案卷被借出
                            if (CollectionUtils.isNotEmpty(borrowDetailFile)) {
                                fileMetafileEntity.setBorrowNum(borrowDetailFile.size()+1);
                                fileMetafileEntity.setBorrowState("借出");
                            } else {
                                fileMetafileEntity.setBorrowNum(1);
                                fileMetafileEntity.setBorrowState("借出");
                            }
                        }else {
                            //文件所属案卷未被借出
                            if (CollectionUtils.isNotEmpty(borrowDetailFile)) {
                                fileMetafileEntity.setBorrowNum(borrowDetailFile.size());
                                fileMetafileEntity.setBorrowState("借出");
                            } else {
                                fileMetafileEntity.setBorrowNum(0);
                                fileMetafileEntity.setBorrowState("在库");
                            }
                        }
                        caseIdsList.add(fileMetafileEntity.getParentId());
                    }
                    metafileService.saveOrUpdateBatch(fileMetafileEntities);
                }

            //统一调整案卷的借阅状态
            fileReturnService.updateCaseBorrowStateByCaseId(caseIdsList);

        }

        return CommonResponse.success("处理完成！");
    }
}
