package com.ejianc.business.filesystem.file.controller;

import java.io.Serializable;

import com.ejianc.business.filesystem.file.bean.*;
import com.ejianc.business.filesystem.file.service.IFileCaseDetailService;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.business.filesystem.file.service.IFileTypeService;
import com.ejianc.business.filesystem.file.vo.FileCaseDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.vo.FileCaseVO;

/**
 * 案卷(文书、工程)
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("fileCase")
public class FileCaseController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "case_code";//此处需要根据实际修改

    @Autowired
    private IFileCaseService service;
    @Autowired
    private IFileCaseDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IFileTypeService fileTypeService;
    @Autowired
    private IFileMetafileService metafileService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FileCaseVO> saveOrUpdate(@RequestBody FileCaseVO saveOrUpdateVO) {
        List<FileCaseDetailVO> fileCaseDetailList1 = saveOrUpdateVO.getFileCaseDetailList();
        List<Long> delFileIds = fileCaseDetailList1.stream().filter(entity -> "del".equals(entity.getRowState()) && entity.getMetaFileId() != null).map(FileCaseDetailVO::getMetaFileId).collect(Collectors.toList());

        FileCaseEntity entity = BeanMapper.map(saveOrUpdateVO, FileCaseEntity.class);
        UserContext userContextCache = sessionManager.getUserContext();
        List<FileCaseEntity> fileCaseEntities = null;
        if (entity.getProjectId() == null) {
            //非工程档案判断是否重复
            QueryParam param = new QueryParam();
            param.getParams().put("reference", new Parameter(QueryParam.EQ, entity.getReference()));
            fileCaseEntities = service.queryList(param);
        }
        if (entity.getId() == null || entity.getId() == 0) {
            //设置创建人姓名
            entity.setCreateUserId(userContextCache.getUserId());
            entity.setCreateUserName(userContextCache.getUserName());
            if (entity.getProjectId() != null) {
                //工程档案自动生成档号
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setReference(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }else {
                if (fileCaseEntities != null && fileCaseEntities.size() > 0) {
                    throw new BusinessException("存在重复的档号！");
                }
            }

            //归档状态
            entity.setFilingState("未归档");
        } else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
            if (fileCaseEntities != null && fileCaseEntities.size()>1){
                throw new BusinessException("存在重复的档号！");
            }
        }


    	service.saveOrUpdate(entity, false);

        //删除对应的元文件
        if (CollectionUtils.isNotEmpty(delFileIds)) {
            metafileService.removeByIds(delFileIds);
        }
        //新增元文件
        FileCaseEntity entityNew = service.selectById(entity.getId());
        List<FileCaseDetailEntity> fileCaseDetailList = entityNew.getFileCaseDetailList();
        if (CollectionUtils.isNotEmpty(fileCaseDetailList)){
            List<FileCaseDetailEntity> collect = fileCaseDetailList.stream().filter(etity -> etity.getMetaFileId() == null).collect(Collectors.toList());
            for (FileCaseDetailEntity fileCaseDetailEntity : collect) {
                //保存元文件
                FileMetafileEntity fileMetafileEntity = new FileMetafileEntity();
                fileMetafileEntity.setParentId(entityNew.getId());
                fileMetafileEntity.setParentCode(entityNew.getCaseCode());
                fileMetafileEntity.setReference(entityNew.getReference()+"-"+fileCaseDetailEntity.getCode());
                fileMetafileEntity.setTitle(fileCaseDetailEntity.getFileName());
                fileMetafileEntity.setOrgId(entityNew.getOrgId());
                fileMetafileEntity.setOrgName(entityNew.getOrgName());
                fileMetafileEntity.setFileTypeId(entityNew.getFileTypeId());
                fileMetafileEntity.setFileTypeName(entityNew.getFileTypeName());
                fileMetafileEntity.setCreateUserName(entityNew.getCreateUserName());
                fileMetafileEntity.setCreateUserId(entityNew.getCreateUserId());
                fileMetafileEntity.setPersonResponsibleName(entityNew.getCreateUserName());
                fileMetafileEntity.setMetafileNum(Integer.parseInt(fileCaseDetailEntity.getCode()));
                fileMetafileEntity.setFilingNum(1);
                fileMetafileEntity.setFilingNum(0);
                fileMetafileEntity.setClassification(0);
                fileMetafileEntity.setRetentionPeriod(0);
                fileMetafileEntity.setTotalPageNum(0);
                fileMetafileEntity.setFilingState("未归档");
                fileMetafileEntity.setBorrowNum(0);
                fileMetafileEntity.setBorrowState("在库");
                fileMetafileEntity.setCDate(new Date());
                fileMetafileEntity.setProjectId(entityNew.getProjectId());
                fileMetafileEntity.setProjectName(entityNew.getProjectName());

                metafileService.saveOrUpdate(fileMetafileEntity);
                //回写元文件的id
                fileCaseDetailEntity.setMetaFileId(fileMetafileEntity.getId());
                detailService.saveOrUpdate(fileCaseDetailEntity);
            }

        }
        FileCaseVO vo = BeanMapper.map(entityNew, FileCaseVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FileCaseVO> queryDetail(Long id) {
    	FileCaseEntity entity = service.selectById(id);
    	FileCaseVO vo = BeanMapper.map(entity, FileCaseVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileCaseVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (FileCaseVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FileCaseVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryFilingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileCaseVO>> queryFilingList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("filingState", new Parameter(QueryParam.EQ,"已归档"));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        Parameter orgIdValue = param.getParams().get("orgId");
//        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
//        param.getParams().put("orgId", new Parameter(QueryParam.IN,
//                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<FileCaseEntity> page = service.queryPage(param,false);
        IPage<FileCaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileCaseVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileCaseVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //param.getParams().put("filingState", new Parameter(QueryParam.EQ,"未归档"));

        param.getParams().put("", new Parameter(QueryParam.SQL, " (filing_state= '" + "未归档" + "'or file_type_id in (895340334396051474,898575273094647864,898575365717463080,898575642839322678,898575810083000414))"));


        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        Parameter orgIdValue = param.getParams().get("orgId");
//        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
//        param.getParams().put("orgId", new Parameter(QueryParam.IN,
//                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<FileCaseEntity> page = service.queryPage(param,false);
        IPage<FileCaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileCaseVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListReplenish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileCaseVO>> queryListReplenish(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<FileCaseEntity> page = service.queryPage(param,false);
        IPage<FileCaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileCaseVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FileCaseEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileCase-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refFileCaseData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FileCaseVO>> refFileCaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

            if (_con.containsKey("filingState")) {
                param.getParams().put("filingState", new Parameter(QueryParam.EQ,_con.getString("filingState")));
            }

            if (_con.containsKey("fileTypeId")) {
                param.getParams().put("fileTypeId", new Parameter(QueryParam.EQ,_con.getString("fileTypeId")));
            }

            if (_con.containsKey("borrowState")) {
                param.getParams().put("borrowState", new Parameter(QueryParam.EQ,_con.getString("borrowState")));
            }

            //档案借阅专用  1为文书档案和工程档案 2为荣誉档案 3为证照管理
            if (_con.containsKey("fileType")) {
                QueryParam param1 = new QueryParam();
                if (_con.getString("fileType").equals("1")){
                    param1.getParams().put("lastTypeId",new Parameter(QueryParam.IN,Arrays.asList("877940299152830497","877940557538734178")));
                }else if (_con.getString("fileType").equals("2")){
                    param1.getParams().put("lastTypeId",new Parameter(QueryParam.IN,Arrays.asList(894547059074502668L)));
                }else if (_con.getString("fileType").equals("3")){
                    param1.getParams().put("lastTypeId",new Parameter(QueryParam.IN,Arrays.asList(877940557538734179L)));
                }
                else {
                    param1.getParams().put("lastTypeId",new Parameter(QueryParam.IN,Arrays.asList("894547059074502668")));
                }

                param1.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList("1","3")));
                List<FileTypeEntity> fileTypeEntities = fileTypeService.queryList(param1);
                List<Long> collect = fileTypeEntities.stream().map(FileTypeEntity::getId).collect(Collectors.toList());


                param.getParams().put("fileTypeId", new Parameter(QueryParam.IN,collect));
            }
        }

        IPage<FileCaseEntity> page = service.queryPage(param,false);
        IPage<FileCaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileCaseVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/updateFilingState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateFilingState(Long id) {
        FileCaseEntity fileCaseEntity = service.selectById(id);
        if ("已归档".equals(fileCaseEntity.getFilingState())){
            return CommonResponse.error("已归档完成，无需重复归档！");
        }
        if(fileCaseEntity.getBillState() == 1 || fileCaseEntity.getBillState() == 3){
            fileCaseEntity.setFilingState("已归档");
            metafileService.updateFilingState(id);
            service.saveOrUpdate(fileCaseEntity);
        }else {
            return CommonResponse.error("审批通过的才能归档！");
        }
        return CommonResponse.success("修改归档状态成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryFileType", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryFileType(Long id) {
        FileCaseEntity fileCaseEntity = service.selectById(id);
        FileTypeEntity fileTypeEntity = fileTypeService.selectById(fileCaseEntity.getFileTypeId());
        return CommonResponse.success("成功！",fileTypeEntity.getInnerCode());
    }
}
