package com.ejianc.business.filesystem.file.controller;

import java.io.Serializable;

import com.ejianc.business.filesystem.file.bean.FileTypeEntity;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileTypeService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.filesystem.file.bean.FileProjectEntity;
import com.ejianc.business.filesystem.file.service.IFileProjectService;
import com.ejianc.business.filesystem.file.vo.FileProjectVO;

/**
 * 工程
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("fileProject")
public class FileProjectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IFileProjectService service;

    @Autowired
    private IFileTypeService typeService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FileProjectVO> saveOrUpdate(@RequestBody FileProjectVO saveOrUpdateVO) {
    	FileProjectEntity entity = BeanMapper.map(saveOrUpdateVO, FileProjectEntity.class);
        UserContext userContextCache = sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0) {
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
        } else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        entity.setBillCode(entity.getProjectCode());

        //归档状态
        entity.setFilingState("未归档");
    	service.saveOrUpdate(entity, false);
    	FileProjectVO vo = BeanMapper.map(entity, FileProjectVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FileProjectVO> queryDetail(Long id) {
    	FileProjectEntity entity = service.selectById(id);
    	FileProjectVO vo = BeanMapper.map(entity, FileProjectVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileProjectVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (FileProjectVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FileProjectVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryFilingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileProjectVO>> queryFilingList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("keyword");
        fuzzyFields.add("memo");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("filingState", new Parameter(QueryParam.EQ,"已归档"));

        if (param.getParams().containsKey("parentId")){
            String parentId = param.getParams().get("parentId").getValue().toString();
            QueryParam param1 = new QueryParam();
            param1.getParams().put("inner_code", new Parameter(QueryParam.LIKE,parentId));
            List<FileTypeEntity> fileTypeEntities = typeService.queryList(param1);
            List<Long> collect = fileTypeEntities.stream().map(FileTypeEntity::getId).collect(Collectors.toList());

            param.getParams().remove("parentId");
            param.getParams().put("parentId", new Parameter(QueryParam.IN,collect));
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<FileProjectEntity> page = service.queryPage(param,false);
        IPage<FileProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileProjectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileProjectVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("keyword");
        fuzzyFields.add("memo");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("filingState", new Parameter(QueryParam.EQ,"未归档"));

        if (param.getParams().containsKey("parentId")){
            String parentId = param.getParams().get("parentId").getValue().toString();
            QueryParam param1 = new QueryParam();
            param1.getParams().put("inner_code", new Parameter(QueryParam.LIKE,parentId));
            List<FileTypeEntity> fileTypeEntities = typeService.queryList(param1);
            List<Long> collect = fileTypeEntities.stream().map(FileTypeEntity::getId).collect(Collectors.toList());

            param.getParams().remove("parentId");
            param.getParams().put("parentId", new Parameter(QueryParam.IN,collect));
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<FileProjectEntity> page = service.queryPage(param,false);
        IPage<FileProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileProjectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FileProjectEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileProject-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refFileProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FileProjectVO>> refFileProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FileProjectEntity> page = service.queryPage(param,false);
        IPage<FileProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileProjectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     @Autowired
     private IFileCaseService caseService;
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/updateFilingState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateFilingState(Long id) {
        FileProjectEntity entity = service.selectById(id);
        if (entity.getFilingState() == "已归档"){
            return CommonResponse.error("已归档完成，无需重复归档！");
        }
        if(entity.getBillState() == 1 || entity.getBillState() == 3){
            //修改案卷归档状态
            caseService.updateFilingState(id);

            entity.setFilingState("已归档");
            service.saveOrUpdate(entity);
        }else {
            return CommonResponse.error("审批通过的才能归档！");
        }
        return CommonResponse.success("修改归档状态成功！");
    }

}
