package com.ejianc.business.filesystem.file.service.impl;

import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("fileCase") 
public class FileCaseBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IFileCaseService service;
	@Autowired
	private IFileMetafileService metafileService;

	@Autowired
	private SessionManager sessionManager;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		FileCaseEntity fileCaseEntity = service.selectById(billId);
		if (fileCaseEntity != null){
			//检查文件的档号是否有重复
//			QueryParam param = new QueryParam();
//			param.getParams().put("parentId", new Parameter(QueryParam.EQ, fileCaseEntity.getId()));
//			List<FileMetafileEntity> fileMetafileEntities = metafileService.queryList(param);
//			if (CollectionUtils.isNotEmpty(fileMetafileEntities)){
//				Map<String, Long> collect =
//						fileMetafileEntities.stream().collect(Collectors.groupingBy(FileMetafileEntity::getReference, Collectors.counting()));
//				if (collect != null && collect.size()>0){
//					List<String> list = collect.keySet().stream().filter(key -> collect.get(key) > 1).collect(Collectors.toList());
//					return  CommonResponse.error("存在档号重复的文件，重复的档号：{}",list.toString());
//				}
//			}
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		FileCaseEntity fileCaseEntity = service.selectById(billId);
		if (fileCaseEntity != null){
//			fileCaseEntity.setFilingState("已归档");

		//终审完总页数、文件件数，应该是提交时自动计算生成
		//并检查文件的档号是否有重复
			//检查人应该是最后一个审批人
			QueryParam param = new QueryParam();
			 param.getParams().put("parentId", new Parameter(QueryParam.EQ, fileCaseEntity.getId()));
			List<FileMetafileEntity> fileMetafileEntities = metafileService.queryList(param);
			if (CollectionUtils.isNotEmpty(fileMetafileEntities)){
				Map<String, Long> collect =
						fileMetafileEntities.stream().collect(Collectors.groupingBy(FileMetafileEntity::getReference, Collectors.counting()));
				List<String> list = collect.keySet().stream().filter(key -> collect.get(key) > 1).collect(Collectors.toList());
				if (list != null && list.size()>0){

					//return  CommonResponse.error("存在档号重复的文件，重复的档号:"+list.toString());
				}

				int sum = fileMetafileEntities.stream().mapToInt((s) -> s.getTotalPageNum()).sum();
				fileCaseEntity.setTotalPageNum(sum);
				fileCaseEntity.setFileNum(fileMetafileEntities.size());

				UserContext userContextCache = sessionManager.getUserContext();
				fileCaseEntity.setPersonCheckId(userContextCache.getUserId());
				fileCaseEntity.setPersonCheckName(userContextCache.getUserName());

				service.saveOrUpdate(fileCaseEntity);
			}



			//文书档案，案卷提交也要将子表提交

			if(fileCaseEntity.getProjectId() == null){
				logger.info("111111111111111111111111111111111111");
				if (CollectionUtils.isNotEmpty(fileMetafileEntities)) {
					logger.info("222222222222222222222222222222222222222");
					for (FileMetafileEntity fileMetafileEntity : fileMetafileEntities) {
						logger.info("fileMetafileEntity.id::"+fileMetafileEntity.getId());
						fileMetafileEntity.setBillState(1);
						metafileService.saveOrUpdate(fileMetafileEntity);
					}
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		FileCaseEntity fileCaseEntity = service.selectById(billId);
		if (fileCaseEntity != null && "已归档".equals(fileCaseEntity.getFilingState())){
			return CommonResponse.error("已归档不允许弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
