package com.ejianc.business.filesystem.file.service.impl;

import com.ejianc.business.filesystem.file.bean.FileCaseDetailEntity;
import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.service.IFileCaseDetailService;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;

@Service("fileMetafile") 
public class FileMetafileBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IFileMetafileService service;
	@Autowired
	private IFileCaseService caseService;

	@Autowired
	private IFileCaseDetailService caseDetailService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		FileMetafileEntity fileMetafileEntity = service.selectById(billId);
		if (fileMetafileEntity != null){

			//工程档案更改是否上传的状态
			QueryParam param = new QueryParam();
			param.getParams().put("pid", new Parameter(QueryParam.EQ, fileMetafileEntity.getParentId()));
			param.getParams().put("metaFileId", new Parameter(QueryParam.EQ,fileMetafileEntity.getId()));
			List<FileCaseDetailEntity> fileCaseDetailEntities = caseDetailService.queryList(param);
			if (CollectionUtils.isNotEmpty(fileCaseDetailEntities)){
				fileCaseDetailEntities.get(0).setIsRight("是");
				fileCaseDetailEntities.get(0).setRectificationTime(new Date());
				caseDetailService.saveOrUpdate(fileCaseDetailEntities.get(0));
			}


			//荣誉档案-审批通过直接改为已归档 加上证照
			if(fileMetafileEntity.getFileTypeId() == 895340334396051474L ||
					fileMetafileEntity.getFileTypeId() == 898575273094647864L ||
					fileMetafileEntity.getFileTypeId() == 898575365717463080L ||
					fileMetafileEntity.getFileTypeId() == 898575642839322678L ||
					fileMetafileEntity.getFileTypeId() == 898575810083000414L ||
					fileMetafileEntity.getFileTypeId() == 970654971034963987L  //证照管理
			){
				fileMetafileEntity.setFilingState("已归档");
				service.saveOrUpdate(fileMetafileEntity);
			}


			//如果所属案卷已归档，则提交文件时直接改为已归档
			FileCaseEntity fileCaseEntity = caseService.selectById(fileMetafileEntity.getParentId());
			if (fileCaseEntity != null && "已归档".equals(fileCaseEntity.getFilingState())){
				fileMetafileEntity.setFilingState("已归档");
			}
			service.saveOrUpdate(fileMetafileEntity);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		FileMetafileEntity fileMetafileEntity = service.selectById(billId);
		if (fileMetafileEntity != null && "已归档".equals(fileMetafileEntity.getFilingState())){
			return CommonResponse.error("已归档不允许弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
