package com.ejianc.business.filesystem.file.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.filesystem.file.mapper.FileMetafileMapper;
import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 元文件
 * 
 * @author generator
 * 
 */
@Service("fileMetafileService")
public class FileMetafileServiceImpl extends BaseServiceImpl<FileMetafileMapper, FileMetafileEntity> implements IFileMetafileService{
    @Autowired
    private IOrgApi iOrgApi;


    @Override
    public void updateFilingState(Long parentId) {
        QueryParam param = new QueryParam();
        param.getParams().put("parentId",new Parameter(QueryParam.EQ,parentId));
        List<FileMetafileEntity> fileMetafileEntities = this.queryList(param);
        if (CollectionUtils.isNotEmpty(fileMetafileEntities)) {
            for (FileMetafileEntity fileMetafile : fileMetafileEntities) {
                if(fileMetafile.getBillState() != 1 && fileMetafile.getBillState() != 3) {
                    throw new BusinessException("元文件未提交!"+fileMetafile.getReference());
                }
            }
        }

        LambdaUpdateWrapper<FileMetafileEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(FileMetafileEntity::getFilingState, "已归档");
        updateWrapper.eq(FileMetafileEntity::getParentId, parentId);
        //updateWrapper.eq(FileMetafileEntity::getYxzt, 0);
        this.update(updateWrapper);
    }

    @Override
    public List<FileMetafileEntity> getListByCaseId(Long caseId) {

        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("filingState", new Parameter(QueryParam.EQ,"未归档"));

        param.getParams().put("parentId", new Parameter(QueryParam.EQ,caseId));

        param.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<FileMetafileEntity> fileMetafileEntities = this.queryList(param);

        return fileMetafileEntities;
    }
}
