package com.ejianc.business.filesystem.file.service.impl;

import com.ejianc.business.filesystem.file.bean.FileBorrowDetailEntity;
import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.service.IFileBorrowDetailService;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.filesystem.file.mapper.FileReturnMapper;
import com.ejianc.business.filesystem.file.bean.FileReturnEntity;
import com.ejianc.business.filesystem.file.service.IFileReturnService;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 文件归还
 * 
 * @author generator
 * 
 */
@Service("fileReturnService")
public class FileReturnServiceImpl extends BaseServiceImpl<FileReturnMapper, FileReturnEntity> implements IFileReturnService{
    @Autowired
    private IFileBorrowDetailService borrowDetailService;
    @Autowired
    private IFileCaseService caseService;
    @Autowired
    private IFileMetafileService metafileService;

    public void updateCaseBorrowStateByCaseId(List<Long> caseId){
        if (CollectionUtils.isNotEmpty(caseId)) {

            QueryParam paramFile = new QueryParam();
            paramFile.getParams().put("id", new Parameter(QueryParam.IN, caseId));
            List<FileCaseEntity> fileCaseEntities = caseService.queryList(paramFile);

            if (CollectionUtils.isNotEmpty(fileCaseEntities)){

                QueryParam paramFile1 = new QueryParam();
                paramFile1.getParams().put("parentId", new Parameter(QueryParam.IN, caseId));
                List<FileMetafileEntity> fileMetafileEntities = metafileService.queryList(paramFile1);

                if (CollectionUtils.isNotEmpty(fileMetafileEntities)){
                    Map<Long, List<FileMetafileEntity>> parentIdGroup = fileMetafileEntities.stream().collect(Collectors.groupingBy(s -> s.getParentId()));

                    for (FileCaseEntity fileCaseEntity : fileCaseEntities) {
                        List<FileBorrowDetailEntity> borrowDetailCase = borrowDetailService.getBorrowDetailByBillId(fileCaseEntity.getId());
                        if (CollectionUtils.isNotEmpty(borrowDetailCase)){//案卷被借出
                            fileCaseEntity.setBorrowState("借出");
                        }else {
                            fileCaseEntity.setBorrowState("在库");
                            if(parentIdGroup.containsKey(fileCaseEntity.getId())){
                                List<FileMetafileEntity> fileMetafileEntities1 = parentIdGroup.get(fileCaseEntity.getId());
                                for (FileMetafileEntity fileMetafileEntity : fileMetafileEntities1) {
                                    if ("借出".equals(fileMetafileEntity.getBorrowState())){
                                        fileCaseEntity.setBorrowState("子文件借出");
                                    }
                                }
                            }
                        }

                    }
                }else {
                    //文件子表是空的，直接将案卷状态改为在库
                    for (FileCaseEntity fileCaseEntity : fileCaseEntities) {
                        fileCaseEntity.setBorrowState("在库");
                    }
                }

                caseService.saveOrUpdateBatch(fileCaseEntities);
            }
        }
    }
}
