package com.ejianc.business.filesystem.utils;

import com.itextpdf.text.pdf.BaseFont;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author sunxy
 * @Date 24/10/9 14:01:51
 */
public class FontGenerater {
    // 符号
    public final static String EMPTY = "";
    public final static String FXG = "\\";
    public final static String DIAN = ".";
    //for report
    public final static String HG = "-";
    public final static String REPORT_UNDERLINE = "<r_u>";
    public final static String REPORT_UNDERLINE_SUFFIX = "</r_u>";
    public final static String NORMAL_CHAR_SET = "UTF-8";

    // font
    public static final short FONT_SMALL_SIZE = 8;
    public static final int FONT_SMALL_VALUELENGTH = 12;
    public static String FONT_URL = EMPTY;
    public static Map FONTMAP = null;
    public static final String FONT_SONTI_NAME = "宋体";
    public static final String FONT_SONTI = "simsun.ttc,0";

    public static BaseFont getFont(String name) {
        if (FONTMAP == null) {
            FONT_URL = "";

            FONTMAP = new HashMap<String, BaseFont>() {{
                try {
                    BaseFont font = BaseFont.createFont(FONT_URL + FONT_SONTI, BaseFont.IDENTITY_H, BaseFont.EMBEDDED);
                    put(FONT_SONTI_NAME, font);
                } catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }};
        }
        return (BaseFont) FONTMAP.get(name);
    }
}
