/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.filesystem.file.service.impl;

import com.ejianc.business.filesystem.file.bean.FileBorrowDetailEntity;
import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.bean.FileReturnEntity;
import com.ejianc.business.filesystem.file.mapper.FileReturnMapper;
import com.ejianc.business.filesystem.file.service.IFileBorrowDetailService;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.business.filesystem.file.service.IFileReturnService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="fileReturnService")
public class FileReturnServiceImpl
extends BaseServiceImpl<FileReturnMapper, FileReturnEntity>
implements IFileReturnService {
    @Autowired
    private IFileBorrowDetailService borrowDetailService;
    @Autowired
    private IFileCaseService caseService;
    @Autowired
    private IFileMetafileService metafileService;

    @Override
    public void updateCaseBorrowStateByCaseId(List<Long> caseId) {
        if (CollectionUtils.isNotEmpty(caseId)) {
            QueryParam paramFile = new QueryParam();
            paramFile.getParams().put("id", new Parameter("in", caseId));
            List fileCaseEntities = this.caseService.queryList(paramFile);
            if (CollectionUtils.isNotEmpty((Collection)fileCaseEntities)) {
                QueryParam paramFile1 = new QueryParam();
                paramFile1.getParams().put("parentId", new Parameter("in", caseId));
                List fileMetafileEntities = this.metafileService.queryList(paramFile1);
                if (CollectionUtils.isNotEmpty((Collection)fileMetafileEntities)) {
                    Map<Long, List<FileMetafileEntity>> parentIdGroup = fileMetafileEntities.stream().collect(Collectors.groupingBy(s -> s.getParentId()));
                    for (FileCaseEntity fileCaseEntity : fileCaseEntities) {
                        List<FileBorrowDetailEntity> borrowDetailCase = this.borrowDetailService.getBorrowDetailByBillId(fileCaseEntity.getId());
                        if (CollectionUtils.isNotEmpty(borrowDetailCase)) {
                            fileCaseEntity.setBorrowState("\u501f\u51fa");
                            continue;
                        }
                        fileCaseEntity.setBorrowState("\u5728\u5e93");
                        if (!parentIdGroup.containsKey(fileCaseEntity.getId())) continue;
                        List<FileMetafileEntity> fileMetafileEntities1 = parentIdGroup.get(fileCaseEntity.getId());
                        for (FileMetafileEntity fileMetafileEntity : fileMetafileEntities1) {
                            if (!"\u501f\u51fa".equals(fileMetafileEntity.getBorrowState())) continue;
                            fileCaseEntity.setBorrowState("\u5b50\u6587\u4ef6\u501f\u51fa");
                        }
                    }
                } else {
                    for (FileCaseEntity fileCaseEntity : fileCaseEntities) {
                        fileCaseEntity.setBorrowState("\u5728\u5e93");
                    }
                }
                this.caseService.saveOrUpdateBatch(fileCaseEntities);
            }
        }
    }
}

