package com.ejianc.business.bank.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description: 银行流水来源类型
 * @author songlx
 * @date 2024/4/1
 * @version 1.0
 */
public enum BankFlowSourceType {

    初始余额(1, "初始余额"),
    余额调增(2, "余额调增"),
    账户调入(3, "账户调入"),
    账户收入(4, "账户收入"),
    项目收款(5, "项目收款"),
    投标保证金退还(6, "投标保证金退还"),
    对上保证金退还(7, "对上保证金退还"),
    对下保证金收取(8, "对下保证金收取"),
    押金退还(9, "押金退还"),
    付款退还(10, "付款退还"),
    备用金退还(11, "备用金退还"),


    余额调减(21, "余额调减"),
    账户调出(22, "账户调出"),
    账户支出(23, "账户支出"),
    支出合同付款(24, "支出合同付款"),
    零星付款(25, "零星付款"),
    备用金付款(26, "备用金付款"),
    费用报销(27, "费用报销"),
    押金付款(28, "押金付款"),
    投标保证金支付(29, "投标保证金支付"),
    对上保证金支付(30, "对上保证金支付"),
    对下保证金退还(31, "对下保证金退还");


    private Integer code;

    private String name;


    private static Map<Integer, BankFlowSourceType> enumMap = new HashMap();

    static {
        enumMap = EnumSet.allOf(BankFlowSourceType.class).stream().collect(Collectors.toMap(BankFlowSourceType::getCode, Function.identity(), (k1, k2) -> k2));
    }


    public static String getNameByCode(Integer code) {
        return enumMap.get(code).getName();
    }


    BankFlowSourceType(Integer code, String name) {
        this.code = code;
        this.name = name;
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}


