package com.ejianc.business.bank.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 账户调拨
 * 
 * @author generator
 * 
 */
public class BankAllocateVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String title; // 标题
    private Long accountOutId; // 调出账户
    private String accountOutName; // 调出账户名称
    private String accountOutBank; // 开户行（调出账户）
    private String accountOutNum; // 账号（调出账户）
    private Long accountInId; // 调入账户
    private String accountInName; // 调入账户名称
    private String accountInBank; // 开户行（调入账户）
    private String accountInNum; // 账号（调入账户）
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private String billCode; // 单据编号
    private BigDecimal allocateMny; // 调拨金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date allocateDate; // 调拨日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门
    private String departmentName; // 经办人部门
    private String memo; // 备注
    private Integer billState; // 单据状态
    

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    @ReferSerialTransfer(referCode = "finance-bank-acct")
    public Long getAccountOutId() {
        return accountOutId;
    }
    @ReferDeserialTransfer
    public void setAccountOutId(Long accountOutId) {
        this.accountOutId = accountOutId;
    }
    public String getAccountOutName() {
        return accountOutName;
    }

    public void setAccountOutName(String accountOutName) {
        this.accountOutName = accountOutName;
    }
    public String getAccountOutBank() {
        return accountOutBank;
    }

    public void setAccountOutBank(String accountOutBank) {
        this.accountOutBank = accountOutBank;
    }
    public String getAccountOutNum() {
        return accountOutNum;
    }

    public void setAccountOutNum(String accountOutNum) {
        this.accountOutNum = accountOutNum;
    }
    @ReferSerialTransfer(referCode = "finance-bank-acct")
    public Long getAccountInId() {
        return accountInId;
    }
    @ReferDeserialTransfer
    public void setAccountInId(Long accountInId) {
        this.accountInId = accountInId;
    }
    public String getAccountInName() {
        return accountInName;
    }

    public void setAccountInName(String accountInName) {
        this.accountInName = accountInName;
    }
    public String getAccountInBank() {
        return accountInBank;
    }

    public void setAccountInBank(String accountInBank) {
        this.accountInBank = accountInBank;
    }
    public String getAccountInNum() {
        return accountInNum;
    }

    public void setAccountInNum(String accountInNum) {
        this.accountInNum = accountInNum;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getAllocateMny() {
        return allocateMny;
    }

    public void setAllocateMny(BigDecimal allocateMny) {
        this.allocateMny = allocateMny;
    }
    public Date getAllocateDate() {
        return allocateDate;
    }

    public void setAllocateDate(Date allocateDate) {
        this.allocateDate = allocateDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
