package com.ejianc.business.finance.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.List;
import java.util.concurrent.Callable;

/**
 * @author yqls
 * @date 2021-04-06 14:13:47
 */
public class CountCallable  implements Callable<JSONObject> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private RequestAttributes context;
    private String authority;
    private String url;
    private QueryParam queryParam;
    private IBaseService service;

    public CountCallable(RequestAttributes context, String authority, String url, QueryParam queryParam, IBaseService service) {
        this.context = context;
        this.authority = authority;
        this.url = url;
        this.queryParam = queryParam;
        this.service = service;
    }

    @Override
    public JSONObject call() throws Exception {
        JSONObject back = new JSONObject();
        if(service == null){
            context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
            RequestContextHolder.setRequestAttributes(context);
            String resp = HttpTookit.postByJson(url, JSONObject.toJSONString(queryParam));
            JSONObject json = JSONObject.parseObject(resp);
            if(json.getInteger("code") != 0){
                logger.error("获取列表失败：{}", json.getString("msg"));
                return new JSONObject();
            }
            JSONObject data = json.getJSONObject("data");
            if(data == null){
                return new JSONObject();
            }
            back.put("records", data.getJSONArray("records"));
        } else {
            List<T> list = service.queryList(queryParam, false);
            String json = JSON.toJSONString(list);
            JSONArray records = JSONArray.parseArray(json);
            back.put("records", records);
        }
//        logger.info("查询列表结果：{}", back);
        return back;
    }
}
