package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 保证金对上办理记录
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
public class BondUpDealRentVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 申请金额
     */
    private BigDecimal applyMny;

    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;

    /**
     * 已退还金额
     */
    private BigDecimal backMny;

    /**
     * 已退还金额
     */
    private BigDecimal surplusMny;

    /**
     * 保证金状态:0-待处理，1-有效
     */
    private String bondStatus;

    private Long bondType;

    /**
     * 账户名
     */
    private String accountName;

    /**
     * 银行账号
     */
    private String bankAccount;

    /**
     * 开户行
     */
    private String bankName;

    /**
     * 期限开始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate;

    /**
     * 期限结束日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    // 办理记录
    private List<BondUpDealVO> dealRecord = new ArrayList<BondUpDealVO>();

    private List<BondUpBackVO> backRecord = new ArrayList<BondUpBackVO>();

    public String getBondStatus() {
        return bondStatus;
    }

    public void setBondStatus(String bondStatus) {
        this.bondStatus = bondStatus;
    }

    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }

    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public List<BondUpDealVO> getDealRecord() {
        return dealRecord;
    }

    public void setDealRecord(List<BondUpDealVO> dealRecord) {
        this.dealRecord = dealRecord;
    }

    public List<BondUpBackVO> getBackRecord() {
        return backRecord;
    }

    public void setBackRecord(List<BondUpBackVO> backRecord) {
        this.backRecord = backRecord;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBondType() {
        return bondType;
    }
    @ReferDeserialTransfer
    public void setBondType(Long bondType) {
        this.bondType = bondType;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
}
