package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: IncomeExpendVO
 * @Description:
 * @Author: 曹鹏辉
 * @Date: 2021/5/26 14:34
 */
public class ExpenditureVO {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;
    private Integer contractTypeExtend;// 合同类型扩展：0-劳务分包,1-专业分包,2-设备采购,3-设备租赁,4-物资采购,5-周转材租赁,6-其他支出合同
    private Integer applyTypeFilter;// 支付类型筛选字段放置
    /**
     * 付款申请主键
     */
    private Long payapplyId;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 账户名(收款单位名称)
     */
    private String receiveUnitName;

    /**
     * 支付类型：1-预付款，2-过程款，3-其他
     */
    private Long feeType;

    /**
     * 付款申请类型：合同付款，零星采购，报销，押金
     */
    private String applyType;

    /**
     * 支付金额
     */
    private BigDecimal thisPayMny;
    /**
     * 税金
     */
    private BigDecimal expenditureTaxMny;
    /**
     * 价税合计金额
     */
    private BigDecimal expenditureInvoiceTaxMny;
    /**
     * 专用发票 税额
     */
    private BigDecimal expenditureZhuanTaxMny;

    /**
     * 支付状态：1-未支付 2-已支付
     */
    private Integer payStatus;

    /**
     * 说明
     */
    private String explanation;

    /**
     * 申请人
     */
    private Long applyUserId;

    /**
     * 申请人名称
     */
    private String applyUserName;

    /**
     * 申请时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 办理时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    public Integer getContractTypeExtend() {
        return contractTypeExtend;
    }

    public void setContractTypeExtend(Integer contractTypeExtend) {
        this.contractTypeExtend = contractTypeExtend;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFeeType() {
        return feeType;
    }

    @ReferDeserialTransfer
    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }

    public String getApplyType() {
        return applyType;
    }

    public Integer getApplyTypeFilter() {
        return applyTypeFilter;
    }

    public void setApplyTypeFilter(Integer applyTypeFilter) {
        this.applyTypeFilter = applyTypeFilter;
    }

    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }

    public BigDecimal getThisPayMny() {
        return thisPayMny;
    }

    public void setThisPayMny(BigDecimal thisPayMny) {
        this.thisPayMny = thisPayMny;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public BigDecimal getExpenditureTaxMny() {
        return expenditureTaxMny;
    }

    public void setExpenditureTaxMny(BigDecimal expenditureTaxMny) {
        this.expenditureTaxMny = expenditureTaxMny;
    }

    public BigDecimal getExpenditureInvoiceTaxMny() {
        return expenditureInvoiceTaxMny;
    }

    public void setExpenditureInvoiceTaxMny(BigDecimal expenditureInvoiceTaxMny) {
        this.expenditureInvoiceTaxMny = expenditureInvoiceTaxMny;
    }

    public BigDecimal getExpenditureZhuanTaxMny() {
        return expenditureZhuanTaxMny;
    }

    public void setExpenditureZhuanTaxMny(BigDecimal expenditureZhuanTaxMny) {
        this.expenditureZhuanTaxMny = expenditureZhuanTaxMny;
    }

    public String getExplanation() {
        return explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

}
