package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 报销费用信息实体
 *
 * @author baipengyan
 */
public class PayInfoVO extends BaseVO {
	private static final long serialVersionUID = 5684305050008562899L;

	private Long payapplyId; // 付款申请单主键
	private Long feeType; // 费用类别
	private String feeTypeName; // 费用类别名称
	private BigDecimal feeTaxMny; // 费用金额
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date feeHappenDate; // 费用发生日期
	private Long subjectId; // 成本科目主键
	private String subjectName; // 成本科目名称
	private String feeMemo; // 备注

	/**
	 * 导入失败原因
	 */
	private String errorMessage;

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public Long getPayapplyId() {
		return payapplyId;
	}

	public void setPayapplyId(Long payapplyId) {
		this.payapplyId = payapplyId;
	}

	@ReferSerialTransfer(referCode = "support-defdoc")
	public Long getFeeType() {
		return feeType;
	}

	@ReferDeserialTransfer
	public void setFeeType(Long feeType) {
		this.feeType = feeType;
	}

	public String getFeeTypeName() {
		return feeTypeName;
	}

	public void setFeeTypeName(String feeTypeName) {
		this.feeTypeName = feeTypeName;
	}

	public BigDecimal getFeeTaxMny() {
		return feeTaxMny;
	}

	public void setFeeTaxMny(BigDecimal feeTaxMny) {
		this.feeTaxMny = feeTaxMny;
	}

	public Date getFeeHappenDate() {
		return feeHappenDate;
	}

	public void setFeeHappenDate(Date feeHappenDate) {
		this.feeHappenDate = feeHappenDate;
	}

	@ReferSerialTransfer(referCode = "cost-subject-set")
	public Long getSubjectId() {
		return subjectId;
	}

	@ReferDeserialTransfer
	public void setSubjectId(Long subjectId) {
		this.subjectId = subjectId;
	}

	public String getSubjectName() {
		return subjectName;
	}

	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}

	public String getFeeMemo() {
		return feeMemo;
	}

	public void setFeeMemo(String feeMemo) {
		this.feeMemo = feeMemo;
	}

}
