package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-05-28
 */
public class PayInvoiceVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 付款申请单主键
     */
    private Long payapplyId;

    /**
     * 来源发票主键
     */
    private Long invoiceId;

    /**
     * 发票号码
     */
    private String invoiceNumber;

    /**
     * 发票代码
     */
    private String invoiceCode;

    /**
     * 发票金额
     */
    private BigDecimal invoiceMny;

    /**
     * 税金
     */
    private BigDecimal taxMny;

    /**
     * 价税合计
     */
    private BigDecimal invoiceTaxMny;

    /**
     * 开票日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date invoiceDate;

    /**
     * 创建者名称
     */
    private String createUserName;

    /**
     * 是否占用：1 未占用， 2 已占用
     */
    private Integer useFlag;

    /**
     * 发票版本号
     */
    private Integer invoiceVersion;

    /**
     * 本期发票金额
     */
    private BigDecimal usedInvoiceTaxMny;
    private Long invoiceType; // 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
    private String invoiceTypeName; // 发票类型名称:1、增值税专用发票，2、增值税普通发票，3、其他；

    /**
     * 剩余发票金额
     */
    private BigDecimal surplusInvoiceTaxMny;

    public BigDecimal getUsedInvoiceTaxMny() {
        return usedInvoiceTaxMny;
    }

    public void setUsedInvoiceTaxMny(BigDecimal usedInvoiceTaxMny) {
        this.usedInvoiceTaxMny = usedInvoiceTaxMny;
    }

    public BigDecimal getSurplusInvoiceTaxMny() {
        return surplusInvoiceTaxMny;
    }

    public void setSurplusInvoiceTaxMny(BigDecimal surplusInvoiceTaxMny) {
        this.surplusInvoiceTaxMny = surplusInvoiceTaxMny;
    }

    public Integer getInvoiceVersion() {
        return invoiceVersion;
    }

    public void setInvoiceVersion(Integer invoiceVersion) {
        this.invoiceVersion = invoiceVersion;
    }

    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }

    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }

    public Long getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
    }

    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getInvoiceType() {
        return invoiceType;
    }
    @ReferDeserialTransfer
    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }

    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

}
