package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-05
 */
public class PayReimburseStatisticsVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 本月申请金额
     */
    private BigDecimal thisMonthApplyMny;

    /**
     * 本月实际支付金额
     */
    private BigDecimal thisMonthPayMny;

    /**
     * 本月发票金额
     */
    private BigDecimal thisMonthInvoiceMny;


    /**
     * 本月组织报销单被分摊的费用
     */
    private BigDecimal thisMonthOrgShareMny;

    /**
     * 本月分摊报销费用
     */
    private BigDecimal thisMonthShareMny;

    /**
     * 本年申请金额
     */
    private BigDecimal thisYearApplyMny;

    /**
     * 本年实际支付金额
     */
    private BigDecimal thisYearPayMny;

    /**
     * 本月组织报销单被分摊的费用
     */
    private BigDecimal thisYearOrgShareMny;

    /**
     * 本年发票金额
     */
    private BigDecimal thisYearInvoiceMny;

    /**
     * 本年分摊报销费用
     */
    private BigDecimal thisYearShareMny;

    /**
     * 累计申请金额
     */
    private BigDecimal sumApplyMny;

    /**
     * 累计实际支付金额
     */
    private BigDecimal sumPayMny;

    /**
     * 累计发票金额
     */
    private BigDecimal sumInvoiceMny;

    /**
     * 项目分摊生成的分摊报销费用
     */
    private BigDecimal sumShareMny;


    /**
     * 组织报销单被分摊的费用
     */
    private BigDecimal sumOrgShareMny;

    /**
     * 属于项目:1-是，0-否
     */
    private String dependOnProject;
    /**
     * 费用类型
     */
    private Long feeType;
    /**
     * 费用类型名称
     */
    private String feeTypeName;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    private List<PayReimburseStatisticsVO> children;//子集数据


    public BigDecimal getThisMonthOrgShareMny() {
        return thisMonthOrgShareMny;
    }

    public void setThisMonthOrgShareMny(BigDecimal thisMonthOrgShareMny) {
        this.thisMonthOrgShareMny = thisMonthOrgShareMny;
    }

    public BigDecimal getThisYearOrgShareMny() {
        return thisYearOrgShareMny;
    }

    public void setThisYearOrgShareMny(BigDecimal thisYearOrgShareMny) {
        this.thisYearOrgShareMny = thisYearOrgShareMny;
    }

    public BigDecimal getSumOrgShareMny() {
        return sumOrgShareMny;
    }

    public void setSumOrgShareMny(BigDecimal sumOrgShareMny) {
        this.sumOrgShareMny = sumOrgShareMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getThisMonthApplyMny() {
        return thisMonthApplyMny;
    }

    public void setThisMonthApplyMny(BigDecimal thisMonthApplyMny) {
        this.thisMonthApplyMny = thisMonthApplyMny;
    }

    public BigDecimal getThisMonthPayMny() {
        return thisMonthPayMny;
    }

    public void setThisMonthPayMny(BigDecimal thisMonthPayMny) {
        this.thisMonthPayMny = thisMonthPayMny;
    }

    public BigDecimal getThisMonthInvoiceMny() {
        return thisMonthInvoiceMny;
    }

    public void setThisMonthInvoiceMny(BigDecimal thisMonthInvoiceMny) {
        this.thisMonthInvoiceMny = thisMonthInvoiceMny;
    }

    public BigDecimal getThisMonthShareMny() {
        return thisMonthShareMny;
    }

    public void setThisMonthShareMny(BigDecimal thisMonthShareMny) {
        this.thisMonthShareMny = thisMonthShareMny;
    }

    public BigDecimal getThisYearApplyMny() {
        return thisYearApplyMny;
    }

    public void setThisYearApplyMny(BigDecimal thisYearApplyMny) {
        this.thisYearApplyMny = thisYearApplyMny;
    }

    public BigDecimal getThisYearPayMny() {
        return thisYearPayMny;
    }

    public void setThisYearPayMny(BigDecimal thisYearPayMny) {
        this.thisYearPayMny = thisYearPayMny;
    }

    public BigDecimal getThisYearInvoiceMny() {
        return thisYearInvoiceMny;
    }

    public void setThisYearInvoiceMny(BigDecimal thisYearInvoiceMny) {
        this.thisYearInvoiceMny = thisYearInvoiceMny;
    }

    public BigDecimal getThisYearShareMny() {
        return thisYearShareMny;
    }

    public void setThisYearShareMny(BigDecimal thisYearShareMny) {
        this.thisYearShareMny = thisYearShareMny;
    }

    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }

    public BigDecimal getSumShareMny() {
        return sumShareMny;
    }

    public void setSumShareMny(BigDecimal sumShareMny) {
        this.sumShareMny = sumShareMny;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Long getFeeType() {
        return feeType;
    }

    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }

    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public List<PayReimburseStatisticsVO> getChildren() {
        return children;
    }

    public void setChildren(List<PayReimburseStatisticsVO> children) {
        this.children = children;
    }
}
