package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 项目资金计划
 * 
 * @author generator
 * 
 */
public class ProjectCapitalPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private String name; // 合同名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate; // 计划日期
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private BigDecimal planBackTotalMny; // 计划回款金额合计
    private BigDecimal planPaymentTotalMny; // 计划支付金额合计
    private Long employeeId; // 编制人
    private String employeeName; // 编制人名称
    private String memo; // 备注
    private Long parentOrgId; // 父组织id
    private String parentOrgName; // 父组织名称

    private List<ProjectCapitalBackPlanVO> backPlanList = new ArrayList<>();
    private List<ProjectCapitalPaymentPlanVO> paymentPlanList = new ArrayList<>();
    private String billStateName;
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public BigDecimal getPlanBackTotalMny() {
        return planBackTotalMny;
    }

    public void setPlanBackTotalMny(BigDecimal planBackTotalMny) {
        this.planBackTotalMny = planBackTotalMny;
    }
    public BigDecimal getPlanPaymentTotalMny() {
        return planPaymentTotalMny;
    }

    public void setPlanPaymentTotalMny(BigDecimal planPaymentTotalMny) {
        this.planPaymentTotalMny = planPaymentTotalMny;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public List<ProjectCapitalBackPlanVO> getBackPlanList() {
        return backPlanList;
    }

    public void setBackPlanList(List<ProjectCapitalBackPlanVO> backPlanList) {
        this.backPlanList = backPlanList;
    }

    public List<ProjectCapitalPaymentPlanVO> getPaymentPlanList() {
        return paymentPlanList;
    }

    public void setPaymentPlanList(List<ProjectCapitalPaymentPlanVO> paymentPlanList) {
        this.paymentPlanList = paymentPlanList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
