package com.ejianc.business.finance.vo;

import java.math.BigDecimal;
import java.util.Date;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 项目资金设置-费用清单
 * </p>
 *
 * @author liyj
 * @since 2021-05-11
 */
public class ProjectCapitalSetCostVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 费用名称
     */
    private String costName;

    /**
     * 增加/扣除
     */
    private String addOrDelete;

    /**
     * 数据类型
     */
    private String dataType;

    /**
     * 数值/公式
     */
    private String valueOrFormula;

    /**
     * 公式--实际值
     */
    private String formula;

    /**
     * 公式--列描述
     */
    private String columnDescribe;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 登记时间
     */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registrationTime;

    /**
     * 经办人
     */
    private Long dealUser;

    /**
     * 备注
     */
    private String remarks;
    
    /**
     * 主表id
     */
    private Long projectCapitalSetId;

	public String getCostName() {
		return costName;
	}

	public void setCostName(String costName) {
		this.costName = costName;
	}

	public String getAddOrDelete() {
		return addOrDelete;
	}

	public void setAddOrDelete(String addOrDelete) {
		this.addOrDelete = addOrDelete;
	}

	public String getDataType() {
		return dataType;
	}

	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	public String getValueOrFormula() {
		return valueOrFormula;
	}

	public void setValueOrFormula(String valueOrFormula) {
		this.valueOrFormula = valueOrFormula;
	}

	public BigDecimal getAmount() {
		return amount;
	}

	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	public Date getRegistrationTime() {
		return registrationTime;
	}

	public void setRegistrationTime(Date registrationTime) {
		this.registrationTime = registrationTime;
	}


    @ReferSerialTransfer(referCode="idm-user")
	public Long getDealUser() {
		return dealUser;
	}

    @ReferDeserialTransfer
	public void setDealUser(Long dealUser) {
		this.dealUser = dealUser;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public Long getProjectCapitalSetId() {
		return projectCapitalSetId;
	}

	public void setProjectCapitalSetId(Long projectCapitalSetId) {
		this.projectCapitalSetId = projectCapitalSetId;
	}

	public String getFormula() {
		return formula;
	}

	public void setFormula(String formula) {
		this.formula = formula;
	}

	public String getColumnDescribe() {
		return columnDescribe;
	}

	public void setColumnDescribe(String columnDescribe) {
		this.columnDescribe = columnDescribe;
	}

}
