package com.ejianc.business.finance.vo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * <p>
 * 项目资金设置
 * </p>
 *
 * @author liyj
 * @since 2021-05-11
 */
public class ProjectCapitalSetVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 项目id
     */
    private Long projectId;
    
    /**
     * 项目部id
     */
    private Long projectDepartmentId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目收入
     */
    private BigDecimal projectIncome;

    /**
     * 项目支出
     */
    private BigDecimal projectExpenditure;

    /**
     * 其他
     */
    private BigDecimal other;

    /**
     * 可用余额
     */
    private BigDecimal availableBalance;

    /**
     * 子表
     */
    private List<ProjectCapitalSetCostVO> projectCapitalSetList = new ArrayList<>();

    @ReferSerialTransfer(referCode="market-project")
	public Long getProjectId() {
		return projectId;
	}

    @ReferDeserialTransfer
	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public BigDecimal getProjectIncome() {
		return projectIncome;
	}

	public void setProjectIncome(BigDecimal projectIncome) {
		this.projectIncome = projectIncome;
	}

	public BigDecimal getProjectExpenditure() {
		return projectExpenditure;
	}

	public void setProjectExpenditure(BigDecimal projectExpenditure) {
		this.projectExpenditure = projectExpenditure;
	}

	public BigDecimal getOther() {
		return other;
	}

	public void setOther(BigDecimal other) {
		this.other = other;
	}

	public BigDecimal getAvailableBalance() {
		return availableBalance;
	}

	public void setAvailableBalance(BigDecimal availableBalance) {
		this.availableBalance = availableBalance;
	}

	public List<ProjectCapitalSetCostVO> getProjectCapitalSetList() {
		return projectCapitalSetList;
	}

	public void setProjectCapitalSetList(List<ProjectCapitalSetCostVO> projectCapitalSetList) {
		this.projectCapitalSetList = projectCapitalSetList;
	}

	public Long getProjectDepartmentId() {
		return projectDepartmentId;
	}

	public void setProjectDepartmentId(Long projectDepartmentId) {
		this.projectDepartmentId = projectDepartmentId;
	}

}
