package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 备用金报销费用信息实体
 * 
 * @author generator
 * 
 */
public class ReimburseInfoVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long reimburseId; // 报销单主键
    private Long feeType; // 费用类别
    private String feeTypeName; // 费用类别名称
    private BigDecimal feeTaxMny; // 费用金额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date feeHappenDate; // 费用发生日期
    private String feeMemo; // 备注
    private Long subjectId; // 成本科目主键
    private String subjectName; // 成本科目名称
    

    public Long getReimburseId() {
        return reimburseId;
    }

    public void setReimburseId(Long reimburseId) {
        this.reimburseId = reimburseId;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFeeType() {
        return feeType;
    }

    @ReferDeserialTransfer
    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }
    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }
    public Date getFeeHappenDate() {
        return feeHappenDate;
    }

    public void setFeeHappenDate(Date feeHappenDate) {
        this.feeHappenDate = feeHappenDate;
    }
    public String getFeeMemo() {
        return feeMemo;
    }

    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public void setFeeMemo(String feeMemo) {
        this.feeMemo = feeMemo;
    }
    @ReferSerialTransfer(referCode = "cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
}
