package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public class ReceiveInvoiceVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 收款单主键
     */
    private Long receiveId;

    /**
     * 来源发票主键
     */
    private Long invoiceId;

    /**
     * 发票号码
     */
    private String invoiceNumber;

    /**
     * 发票代码
     */
    private String invoiceCode;

    /**
     * 发票金额
     */
    private BigDecimal invoiceMny;

    /**
     * 税金
     */
    private BigDecimal taxMny;

    /**
     * 价税合计
     */
    private BigDecimal invoiceTaxMny;

    /**
     * 本期的发票金额
     */
    private BigDecimal currentInvoiceTaxMny;

    /**
     * 剩余发票金额
     */
    private BigDecimal surplusInvoiceTaxMny;

    /**
     * 开票日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date invoiceDate;

    /**
     * 创建者名称
     */
    private String createUserName;

    /**
     * 发票版本号
     */
    private Integer invoiceVersion;

    public Integer getInvoiceVersion() {
        return invoiceVersion;
    }

    public void setInvoiceVersion(Integer invoiceVersion) {
        this.invoiceVersion = invoiceVersion;
    }

    public Long getReceiveId() {
        return receiveId;
    }

    public void setReceiveId(Long receiveId) {
        this.receiveId = receiveId;
    }

    public Long getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
    }

    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }

    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public BigDecimal getCurrentInvoiceTaxMny() {
        return currentInvoiceTaxMny;
    }

    public void setCurrentInvoiceTaxMny(BigDecimal currentInvoiceTaxMny) {
        this.currentInvoiceTaxMny = currentInvoiceTaxMny;
    }

    public BigDecimal getSurplusInvoiceTaxMny() {
        return surplusInvoiceTaxMny;
    }

    public void setSurplusInvoiceTaxMny(BigDecimal surplusInvoiceTaxMny) {
        this.surplusInvoiceTaxMny = surplusInvoiceTaxMny;
    }
}
