package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-05
 */
public class PayReimburseVO extends BaseVO {

    public static final String BILL_TYPE_CODE = "BT200529000000002";
    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    private Integer billState;

    /**
     * 备注
     */
    private String memo;

    /**
     * 申请金额大写
     */
    private String applyMnyCn;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 经办时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 付款类型：1-组织付款，2- 项目付款
     */
    private Integer payType;

    /**
     * 支付状态：1-未支付，2-已支付
     */
    private Integer payStatus;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 费用类型
     */
    private Long feeType;

    /**
     * 费用承担部门Id
     */
    private Long bearDeptId;

    /**
     * 费用承担部门
     */
    private String bearDept;

    /**
     * 付款单位
     */
    private Long payUnitId;

    /**
     * 付款单位名称
     */
    private String payUnitName;

    /**
     * 付款事由
     */
    private String payReason;

    /**
     * 申请人
     */
    private Long applyUserId;

    /**
     * 申请人名称
     */
    private String applyUserName;

    /**
     * 申请时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 申请金额
     */
    private BigDecimal applyMny;

    /**
     * 支付金额
     */
    private BigDecimal payMny;

    /**
     * 发票金额
     */
    private BigDecimal invoiceMny;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 银行账号
     */
    private String accountNum;

    /**
     * 开户行
     */
    private String accountBank;

    /**
     * 撤回原因
     */
    private String backReason;

    /**
     * 撤回时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    /**
     * 发票子表
     */
    private List<PayInvoiceVO> invoiceVOList;

    /**
     * 审批时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    /**
     * 是否支出管理
     */
    private boolean manageFlag;

    /**
     * 属于项目:1-是，0-否
     */
    private String dependOnProject;

    /**
     * 单据状态名称
     */
    private String billStateName;

    /**
     * 费用类型名称
     */
    private String feeTypeName;

    /**
     * 成本科目主键
     */
    private Long subjectId;
    /**
     * 成本科目名称
     */
    private String subjectName;
    /**
     * 关联状态(1:是，0：否)
     */
    private String relationFlag;
    /**
     * 分摊状态(1:是，0：否)
     */
    private String proportionFlag;

    private BigDecimal reimburseMmy; // 报销费用（报销费用=付款申请中的报销费用+备用金报销）
    private BigDecimal manageMmy; //  管理费(预算中的管理费)
    private BigDecimal cumulativeMny;//累计报销

    private Integer isShareFlag; // 是否项目分摊：0否，1是
    private String isShareFlagName; //是否项目分摊
    /**
     * 是否需要发票：1 需要，2 不需要，3 不确定
     */
    private Integer invoiceFlag;


    private String orgCode; // 组织编码

    /**
     * 关闭前的本期申请金额
     */
    private BigDecimal applyMnyBeforeClose;

    /**
     * 关闭状态
     */
    private String closeState;

    /**
     * 关闭时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date closeTime;

    /**
     * 关闭人
     */
    private String closeUser;


    /**
     * 是否关闭
     */
    private Boolean closeFlag;

    /**
     * 上级组织主键
     */
    private Long parentOrgId;
    /**
     * 上级组织名称
     */
    private String parentOrgName;


    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public BigDecimal getApplyMnyBeforeClose() {
        return applyMnyBeforeClose;
    }

    public void setApplyMnyBeforeClose(BigDecimal applyMnyBeforeClose) {
        this.applyMnyBeforeClose = applyMnyBeforeClose;
    }

    public String getCloseState() {
        return closeState;
    }

    public void setCloseState(String closeState) {
        this.closeState = closeState;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public String getCloseUser() {
        return closeUser;
    }

    public void setCloseUser(String closeUser) {
        this.closeUser = closeUser;
    }

    public Boolean getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(Boolean closeFlag) {
        this.closeFlag = closeFlag;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }


    /**
     * 是否需要发票
     */
    private String invoiceFlagName;

    public String getInvoiceFlagName() {
        if (this.invoiceFlag == null) {
            return null;
        } else if (this.invoiceFlag == 1) {
            return "有";
        } else if (this.invoiceFlag == 2) {
            return "没有";
        } else if (this.invoiceFlag == 3) {
            return "不确定";
        }
        return null;
    }

    public void setInvoiceFlagName(String invoiceFlagName) {
        this.invoiceFlagName = invoiceFlagName;
    }


    /**
     *************start************************项目资金改造***************************start*******************************
     */

    private ProjectFinanceVO projectFinanceVO = new ProjectFinanceVO();

    private BigDecimal proContractMny; // 收入合同金额
    private BigDecimal proOutputMny; // 完成产值
    private BigDecimal proDateProgress; // 日期进度
    private BigDecimal proOutputProgress; // 产值进度
    private BigDecimal proContractReceiveMny; // 合同累计收款金额
    private BigDecimal proReceiveMny; // 累计收款
    private BigDecimal proPayMny; // 累计付款
    private BigDecimal proCostListSurplus; // 费用清单结余
    private BigDecimal proTransferSurplus; // 项目代转款款结余
    private BigDecimal proRiskMarginSurplus; // 风险保证金结余
    private BigDecimal proLoanBalance; // 借款结余
    private BigDecimal proLoanInterest; // 借款利息
    private BigDecimal proOtherFeeDeduct; // 其他费用扣除
    private BigDecimal proOtherFeeBack; // 其他费用退还
    private BigDecimal proSurplusMny; // 项目可用资金
    private BigDecimal proSurplusApplyMny; // 剩余可申请金额release
    private BigDecimal proPettyCash; // 备用金结余
    private BigDecimal proManageScale; // 管理费比例
    private BigDecimal proManageFee; // 管理费
    private BigDecimal proAmerce; // 罚款
    private BigDecimal proApplyUnpayMny; // 已申请未支付金额

    private BigDecimal unpaidMny; // 未付金额

    /**
     * 支付金额
     */
    private String payMnyCn;

    /**
     * 累计分摊金额
     */
    private BigDecimal countShareMny;
    /**
     * 剩余可分摊金额
     */
    private BigDecimal surplusShareMny;

    private Map<String, Object> _payRecordId;

    /**
     * 推送凭证标识
     */
    private Integer voucherFlag;

    /**
     * 凭证信息json
     */
    private String voucherInfo;

    public Integer getVoucherFlag() {
        return voucherFlag;
    }

    public void setVoucherFlag(Integer voucherFlag) {
        this.voucherFlag = voucherFlag;
    }

    public String getVoucherInfo() {
        return voucherInfo;
    }

    public void setVoucherInfo(String voucherInfo) {
        this.voucherInfo = voucherInfo;
    }

    public Map<String, Object> get_payRecordId() {
        return _payRecordId;
    }

    public void set_payRecordId(Map<String, Object> _payRecordId) {
        this._payRecordId = _payRecordId;
    }


    public String getPayMnyCn() {
        return payMnyCn;
    }

    public void setPayMnyCn(String payMnyCn) {
        this.payMnyCn = payMnyCn;
    }
    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }

    public BigDecimal getUnpaidMny() {
        return unpaidMny;
    }

    public void setUnpaidMny(BigDecimal unpaidMny) {
        this.unpaidMny = unpaidMny;
    }

    public ProjectFinanceVO getProjectFinanceVO() {
        return projectFinanceVO;
    }

    public void setProjectFinanceVO(ProjectFinanceVO projectFinanceVO) {
        this.projectFinanceVO = projectFinanceVO;
    }

    public BigDecimal getProApplyUnpayMny() {
        return proApplyUnpayMny;
    }

    public void setProApplyUnpayMny(BigDecimal proApplyUnpayMny) {
        this.proApplyUnpayMny = proApplyUnpayMny;
    }


    public BigDecimal getProContractMny() {
        return proContractMny;
    }

    public void setProContractMny(BigDecimal proContractMny) {
        this.proContractMny = proContractMny;
    }

    public BigDecimal getProOutputMny() {
        return proOutputMny;
    }

    public void setProOutputMny(BigDecimal proOutputMny) {
        this.proOutputMny = proOutputMny;
    }

    public BigDecimal getProDateProgress() {
        return proDateProgress;
    }

    public void setProDateProgress(BigDecimal proDateProgress) {
        this.proDateProgress = proDateProgress;
    }

    public BigDecimal getProOutputProgress() {
        return proOutputProgress;
    }

    public void setProOutputProgress(BigDecimal proOutputProgress) {
        this.proOutputProgress = proOutputProgress;
    }

    public BigDecimal getProContractReceiveMny() {
        return proContractReceiveMny;
    }

    public void setProContractReceiveMny(BigDecimal proContractReceiveMny) {
        this.proContractReceiveMny = proContractReceiveMny;
    }

    public BigDecimal getProReceiveMny() {
        return proReceiveMny;
    }

    public void setProReceiveMny(BigDecimal proReceiveMny) {
        this.proReceiveMny = proReceiveMny;
    }

    public BigDecimal getProPayMny() {
        return proPayMny;
    }

    public void setProPayMny(BigDecimal proPayMny) {
        this.proPayMny = proPayMny;
    }

    public BigDecimal getProCostListSurplus() {
        return proCostListSurplus;
    }

    public void setProCostListSurplus(BigDecimal proCostListSurplus) {
        this.proCostListSurplus = proCostListSurplus;
    }

    public BigDecimal getProTransferSurplus() {
        return proTransferSurplus;
    }

    public void setProTransferSurplus(BigDecimal proTransferSurplus) {
        this.proTransferSurplus = proTransferSurplus;
    }

    public BigDecimal getProRiskMarginSurplus() {
        return proRiskMarginSurplus;
    }

    public void setProRiskMarginSurplus(BigDecimal proRiskMarginSurplus) {
        this.proRiskMarginSurplus = proRiskMarginSurplus;
    }

    public BigDecimal getProLoanBalance() {
        return proLoanBalance;
    }

    public void setProLoanBalance(BigDecimal proLoanBalance) {
        this.proLoanBalance = proLoanBalance;
    }

    public BigDecimal getProLoanInterest() {
        return proLoanInterest;
    }

    public void setProLoanInterest(BigDecimal proLoanInterest) {
        this.proLoanInterest = proLoanInterest;
    }

    public BigDecimal getProOtherFeeDeduct() {
        return proOtherFeeDeduct;
    }

    public void setProOtherFeeDeduct(BigDecimal proOtherFeeDeduct) {
        this.proOtherFeeDeduct = proOtherFeeDeduct;
    }

    public BigDecimal getProOtherFeeBack() {
        return proOtherFeeBack;
    }

    public void setProOtherFeeBack(BigDecimal proOtherFeeBack) {
        this.proOtherFeeBack = proOtherFeeBack;
    }

    public BigDecimal getProSurplusMny() {
        return proSurplusMny;
    }

    public void setProSurplusMny(BigDecimal proSurplusMny) {
        this.proSurplusMny = proSurplusMny;
    }

    public BigDecimal getProSurplusApplyMny() {
        return proSurplusApplyMny;
    }

    public void setProSurplusApplyMny(BigDecimal proSurplusApplyMny) {
        this.proSurplusApplyMny = proSurplusApplyMny;
    }

    public BigDecimal getProPettyCash() {
        return proPettyCash;
    }

    public void setProPettyCash(BigDecimal proPettyCash) {
        this.proPettyCash = proPettyCash;
    }

    public BigDecimal getProManageScale() {
        return proManageScale;
    }

    public void setProManageScale(BigDecimal proManageScale) {
        this.proManageScale = proManageScale;
    }

    public BigDecimal getProManageFee() {
        return proManageFee;
    }

    public void setProManageFee(BigDecimal proManageFee) {
        this.proManageFee = proManageFee;
    }

    public BigDecimal getProAmerce() {
        return proAmerce;
    }

    public void setProAmerce(BigDecimal proAmerce) {
        this.proAmerce = proAmerce;
    }

    /**
     *************end************************项目资金改造***************************end*******************************
     */



    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    private List<PayRecordVO> recordList = new ArrayList<>(); // 付款申请记录实体

    public List<PayRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<PayRecordVO> recordList) {
        this.recordList = recordList;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getBearDeptId() {
        return bearDeptId;
    }
    @ReferDeserialTransfer
    public void setBearDeptId(Long bearDeptId) {
        this.bearDeptId = bearDeptId;
    }

    public String getBearDept() {
        return bearDept;
    }

    public void setBearDept(String bearDept) {
        this.bearDept = bearDept;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayUnitId() {
        return payUnitId;
    }
    @ReferDeserialTransfer
    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }

    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }

    public boolean isManageFlag() {
        return manageFlag;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public boolean getManageFlag() {
        return manageFlag;
    }

    public void setManageFlag(boolean manageFlag) {
        this.manageFlag = manageFlag;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public List<PayInvoiceVO> getInvoiceVOList() {
        return invoiceVOList;
    }

    public void setInvoiceVOList(List<PayInvoiceVO> invoiceVOList) {
        this.invoiceVOList = invoiceVOList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFeeType() {
        return feeType;
    }

    @ReferDeserialTransfer
    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getApplyUserId() {
        return applyUserId;
    }

    @ReferDeserialTransfer
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }

    public Integer getIsShareFlag() {
        return isShareFlag;
    }

    public void setIsShareFlag(Integer isShareFlag) {
        this.isShareFlag = isShareFlag;
    }

    public String getIsShareFlagName() {
        return isShareFlagName;
    }

    public void setIsShareFlagName(String isShareFlagName) {
        this.isShareFlagName = isShareFlagName;
    }

    public Integer getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(Integer invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }

    public BigDecimal getReimburseMmy() {
        return reimburseMmy;
    }

    public void setReimburseMmy(BigDecimal reimburseMmy) {
        this.reimburseMmy = reimburseMmy;
    }

    public BigDecimal getManageMmy() {
        return manageMmy;
    }

    public void setManageMmy(BigDecimal manageMmy) {
        this.manageMmy = manageMmy;
    }

    public BigDecimal getCumulativeMny() {
        return cumulativeMny;
    }

    public void setCumulativeMny(BigDecimal cumulativeMny) {
        this.cumulativeMny = cumulativeMny;
    }

    public BigDecimal getCountShareMny() {
        return countShareMny;
    }

    public void setCountShareMny(BigDecimal countShareMny) {
        this.countShareMny = countShareMny;
    }

    public BigDecimal getSurplusShareMny() {
        return surplusShareMny;
    }

    public void setSurplusShareMny(BigDecimal surplusShareMny) {
        this.surplusShareMny = surplusShareMny;
    }
}
