package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public class PaySporadicVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    private Integer billState;

    /**
     * 备注
     */
    private String memo;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 申请金额大写
     */
    private String applyMnyCn;

    /**
     * 经办时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 付款类型：1-组织付款，2- 项目付款
     */
    private Integer payType;

    /**
     * 支付状态：1-未支付，2-已支付
     */
    private Integer payStatus;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 供应商
     */
    private Long supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 付款事由
     */
    private String payReason;

    /**
     * 申请人
     */
    private Long applyUserId;

    /**
     * 申请人名称
     */
    private String applyUserName;

    /**
     * 申请时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 申请金额
     */
    private BigDecimal applyMny;

    /**
     * 付款单位
     */
    @TableField("pay_unit_id")
    private Long payUnitId;

    /**
     * 付款单位名称
     */
    @TableField("pay_unit_name")
    private String payUnitName;

    /**
     * 发票金额
     */
    private BigDecimal invoiceMny;

    /**
     * 支付金额
     */
    private BigDecimal payMny;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 银行账号
     */
    private String accountNum;

    /**
     * 开户行
     */
    private String accountBank;

    /**
     * 撤回原因
     */
    private String backReason;

    /**
     * 撤回时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    /**
     * 发票子表
     */
    private List<PayInvoiceVO> invoiceVOList;

    /**
     * 入库单子表
     */
    private List<PaySporadicStockVO> stockVOList;
    /**
     * 设备使用记录
     */
    private List<PaySporadicEquipmentRecordVO> equipmentRecordList = new ArrayList<>();
    /**
     * 审批时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    /**
     * 是否支出管理
     */
    private boolean manageFlag;

    /**
     * 属于项目:1-是，0-否
     */
    private String dependOnProject;

    /**
     * 单据状态名称
     */
    private String billStateName;
    /**
     * 是否包含入库单(1-是，0-否)
     */
    private String inputFlag;
    /**
     * 成本科目主键
     */
    private Long subjectId;
    /**
     * 成本科目名称
     */
    private String subjectName;
    /**
     * 关联状态(1:是，0：否)
     */
    private String relationFlag;
    /**
     * 分摊状态(1:是，0：否)
     */
    private String proportionFlag;

    /**
     * 是否需要发票：1 需要，2 不需要，3 不确定
     */
    private Integer invoiceFlag;

    /**
     * 是否需要发票
     */
    private String invoiceFlagName;


    /**
     * 关闭前的本期申请金额
     */
    private BigDecimal applyMnyBeforeClose;
    /**
     * 关闭状态
     */
    private String closeState;

    /**
     * 关闭时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date closeTime;

    /**
     * 关闭人
     */
    private String closeUser;

    /**
     * 是否关闭
     */
    private Boolean closeFlag;


    /**
     * 其他费用子表
     */
    private List<PaySporadicOtherVO> otherVOList;
    private String purchasePeople;//采购人

    public String getInvoiceFlagName() {
        if (this.invoiceFlag == null) {
            return null;
        } else if (this.invoiceFlag == 1) {
            return "有";
        } else if (this.invoiceFlag == 2) {
            return "没有";
        } else if (this.invoiceFlag == 3) {
            return "不确定";
        }
        return null;
    }

    public List<PaySporadicOtherVO> getOtherVOList() {
        return otherVOList;
    }

    public void setOtherVOList(List<PaySporadicOtherVO> otherVOList) {
        this.otherVOList = otherVOList;
    }

    public void setInvoiceFlagName(String invoiceFlagName) {
        this.invoiceFlagName = invoiceFlagName;
    }


    /**
     *************start************************项目资金改造***************************start*******************************
     */

    private ProjectFinanceVO projectFinanceVO = new ProjectFinanceVO();


    private java.math.BigDecimal proContractMny; // 收入合同金额
    private java.math.BigDecimal proOutputMny; // 完成产值
    private java.math.BigDecimal proDateProgress; // 日期进度
    private java.math.BigDecimal proOutputProgress; // 产值进度
    private java.math.BigDecimal proContractReceiveMny; // 合同累计收款金额
    private java.math.BigDecimal proReceiveMny; // 累计收款
    private java.math.BigDecimal proPayMny; // 累计付款
    private java.math.BigDecimal proCostListSurplus; // 费用清单结余
    private java.math.BigDecimal proTransferSurplus; // 项目代转款款结余
    private java.math.BigDecimal proRiskMarginSurplus; // 风险保证金结余
    private java.math.BigDecimal proLoanBalance; // 借款结余
    private java.math.BigDecimal proLoanInterest; // 借款利息
    private java.math.BigDecimal proOtherFeeDeduct; // 其他费用扣除
    private java.math.BigDecimal proOtherFeeBack; // 其他费用退还
    private java.math.BigDecimal proSurplusMny; // 项目可用资金
    private java.math.BigDecimal proSurplusApplyMny; // 剩余可申请金额release
    private java.math.BigDecimal proPettyCash; // 备用金结余
    private java.math.BigDecimal proManageScale; // 管理费比例
    private java.math.BigDecimal proManageFee; // 管理费
    private java.math.BigDecimal proAmerce; // 罚款
    private java.math.BigDecimal proApplyUnpayMny; // 已申请未支付金额

    private java.math.BigDecimal unpaidMny; // 未付金额

    /**
     * 支付金额
     */
    private String payMnyCn;
    private BigDecimal thisPayMnyRecord; // 本期支付金额（支付记录）
    private String accountNameRecord; // 账户名称（支付记录）
    private String accountNumRecord; // 银行账号（支付记录）
    private String accountBankRecord; // 开户行名（支付记录）
    private String applyUserNameRecord; // 申请人名称（支付记录）
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date confirmTimeRecord; // 经办时间（支付记录）
    private String payWayNameRecord; // 付款方式名称（支付记录）
    private String memoRecord; // 备注（支付记录）

    public BigDecimal getThisPayMnyRecord() {
        return thisPayMnyRecord;
    }

    public void setThisPayMnyRecord(BigDecimal thisPayMnyRecord) {
        this.thisPayMnyRecord = thisPayMnyRecord;
    }

    public String getAccountNameRecord() {
        return accountNameRecord;
    }

    public void setAccountNameRecord(String accountNameRecord) {
        this.accountNameRecord = accountNameRecord;
    }

    public String getAccountNumRecord() {
        return accountNumRecord;
    }

    public void setAccountNumRecord(String accountNumRecord) {
        this.accountNumRecord = accountNumRecord;
    }

    public String getAccountBankRecord() {
        return accountBankRecord;
    }

    public void setAccountBankRecord(String accountBankRecord) {
        this.accountBankRecord = accountBankRecord;
    }

    public String getApplyUserNameRecord() {
        return applyUserNameRecord;
    }

    public void setApplyUserNameRecord(String applyUserNameRecord) {
        this.applyUserNameRecord = applyUserNameRecord;
    }

    public Date getConfirmTimeRecord() {
        return confirmTimeRecord;
    }

    public void setConfirmTimeRecord(Date confirmTimeRecord) {
        this.confirmTimeRecord = confirmTimeRecord;
    }

    public String getPayWayNameRecord() {
        return payWayNameRecord;
    }

    public void setPayWayNameRecord(String payWayNameRecord) {
        this.payWayNameRecord = payWayNameRecord;
    }

    public String getMemoRecord() {
        return memoRecord;
    }

    public void setMemoRecord(String memoRecord) {
        this.memoRecord = memoRecord;
    }

    public String getPayMnyCn() {
        return payMnyCn;
    }

    public void setPayMnyCn(String payMnyCn) {
        this.payMnyCn = payMnyCn;
    }

    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }

    public BigDecimal getUnpaidMny() {
        return unpaidMny;
    }

    public void setUnpaidMny(BigDecimal unpaidMny) {
        this.unpaidMny = unpaidMny;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayUnitId() {
        return payUnitId;
    }

    @ReferDeserialTransfer
    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }

    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }

    public ProjectFinanceVO getProjectFinanceVO() {
        return projectFinanceVO;
    }

    public void setProjectFinanceVO(ProjectFinanceVO projectFinanceVO) {
        this.projectFinanceVO = projectFinanceVO;
    }

    public BigDecimal getProApplyUnpayMny() {
        return proApplyUnpayMny;
    }

    public void setProApplyUnpayMny(BigDecimal proApplyUnpayMny) {
        this.proApplyUnpayMny = proApplyUnpayMny;
    }


    public BigDecimal getProContractMny() {
        return proContractMny;
    }

    public void setProContractMny(BigDecimal proContractMny) {
        this.proContractMny = proContractMny;
    }

    public BigDecimal getProOutputMny() {
        return proOutputMny;
    }

    public void setProOutputMny(BigDecimal proOutputMny) {
        this.proOutputMny = proOutputMny;
    }

    public BigDecimal getProDateProgress() {
        return proDateProgress;
    }

    public void setProDateProgress(BigDecimal proDateProgress) {
        this.proDateProgress = proDateProgress;
    }

    public BigDecimal getProOutputProgress() {
        return proOutputProgress;
    }

    public void setProOutputProgress(BigDecimal proOutputProgress) {
        this.proOutputProgress = proOutputProgress;
    }

    public BigDecimal getProContractReceiveMny() {
        return proContractReceiveMny;
    }

    public void setProContractReceiveMny(BigDecimal proContractReceiveMny) {
        this.proContractReceiveMny = proContractReceiveMny;
    }

    public BigDecimal getProReceiveMny() {
        return proReceiveMny;
    }

    public void setProReceiveMny(BigDecimal proReceiveMny) {
        this.proReceiveMny = proReceiveMny;
    }

    public BigDecimal getProPayMny() {
        return proPayMny;
    }

    public void setProPayMny(BigDecimal proPayMny) {
        this.proPayMny = proPayMny;
    }

    public BigDecimal getProCostListSurplus() {
        return proCostListSurplus;
    }

    public void setProCostListSurplus(BigDecimal proCostListSurplus) {
        this.proCostListSurplus = proCostListSurplus;
    }

    public BigDecimal getProTransferSurplus() {
        return proTransferSurplus;
    }

    public void setProTransferSurplus(BigDecimal proTransferSurplus) {
        this.proTransferSurplus = proTransferSurplus;
    }

    public BigDecimal getProRiskMarginSurplus() {
        return proRiskMarginSurplus;
    }

    public void setProRiskMarginSurplus(BigDecimal proRiskMarginSurplus) {
        this.proRiskMarginSurplus = proRiskMarginSurplus;
    }

    public BigDecimal getProLoanBalance() {
        return proLoanBalance;
    }

    public void setProLoanBalance(BigDecimal proLoanBalance) {
        this.proLoanBalance = proLoanBalance;
    }

    public BigDecimal getProLoanInterest() {
        return proLoanInterest;
    }

    public void setProLoanInterest(BigDecimal proLoanInterest) {
        this.proLoanInterest = proLoanInterest;
    }

    public BigDecimal getProOtherFeeDeduct() {
        return proOtherFeeDeduct;
    }

    public void setProOtherFeeDeduct(BigDecimal proOtherFeeDeduct) {
        this.proOtherFeeDeduct = proOtherFeeDeduct;
    }

    public BigDecimal getProOtherFeeBack() {
        return proOtherFeeBack;
    }

    public void setProOtherFeeBack(BigDecimal proOtherFeeBack) {
        this.proOtherFeeBack = proOtherFeeBack;
    }

    public BigDecimal getProSurplusMny() {
        return proSurplusMny;
    }

    public void setProSurplusMny(BigDecimal proSurplusMny) {
        this.proSurplusMny = proSurplusMny;
    }

    public BigDecimal getProSurplusApplyMny() {
        return proSurplusApplyMny;
    }

    public void setProSurplusApplyMny(BigDecimal proSurplusApplyMny) {
        this.proSurplusApplyMny = proSurplusApplyMny;
    }

    public BigDecimal getProPettyCash() {
        return proPettyCash;
    }

    public void setProPettyCash(BigDecimal proPettyCash) {
        this.proPettyCash = proPettyCash;
    }

    public BigDecimal getProManageScale() {
        return proManageScale;
    }

    public void setProManageScale(BigDecimal proManageScale) {
        this.proManageScale = proManageScale;
    }

    public BigDecimal getProManageFee() {
        return proManageFee;
    }

    public void setProManageFee(BigDecimal proManageFee) {
        this.proManageFee = proManageFee;
    }

    public BigDecimal getProAmerce() {
        return proAmerce;
    }

    public void setProAmerce(BigDecimal proAmerce) {
        this.proAmerce = proAmerce;
    }

    /**
     *************end************************项目资金改造***************************end*******************************
     */




    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    private List<PayRecordVO> recordList = new ArrayList<>(); // 付款申请记录实体

    public List<PayRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<PayRecordVO> recordList) {
        this.recordList = recordList;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }
    public String getInputFlag() {
        return inputFlag;
    }

    public void setInputFlag(String inputFlag) {
        this.inputFlag = inputFlag;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public boolean getManageFlag() {
        return manageFlag;
    }

    public void setManageFlag(boolean manageFlag) {
        this.manageFlag = manageFlag;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public List<PayInvoiceVO> getInvoiceVOList() {
        return invoiceVOList;
    }

    public void setInvoiceVOList(List<PayInvoiceVO> invoiceVOList) {
        this.invoiceVOList = invoiceVOList;
    }

    public List<PaySporadicStockVO> getStockVOList() {
        return stockVOList;
    }

    public void setStockVOList(List<PaySporadicStockVO> stockVOList) {
        this.stockVOList = stockVOList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getApplyUserId() {
        return applyUserId;
    }

    @ReferDeserialTransfer
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }

    public Integer getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(Integer invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }

    public List<PaySporadicEquipmentRecordVO> getEquipmentRecordList() {
        return equipmentRecordList;
    }

    public void setEquipmentRecordList(List<PaySporadicEquipmentRecordVO> equipmentRecordList) {
        this.equipmentRecordList = equipmentRecordList;
    }

    public String getPurchasePeople() {
        return purchasePeople;
    }

    public void setPurchasePeople(String purchasePeople) {
        this.purchasePeople = purchasePeople;
    }

    public BigDecimal getApplyMnyBeforeClose() {
        return applyMnyBeforeClose;
    }

    public void setApplyMnyBeforeClose(BigDecimal applyMnyBeforeClose) {
        this.applyMnyBeforeClose = applyMnyBeforeClose;
    }

    public String getCloseState() {
        return closeState;
    }

    public void setCloseState(String closeState) {
        this.closeState = closeState;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public String getCloseUser() {
        return closeUser;
    }

    public void setCloseUser(String closeUser) {
        this.closeUser = closeUser;
    }

    public Boolean getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(Boolean closeFlag) {
        this.closeFlag = closeFlag;
    }
}
