package com.ejianc.business.finance.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import javax.servlet.http.HttpServletRequest;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.framework.core.util.Utils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.RequestContextHolder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.ProjectCapitalSetEntity;
import com.ejianc.business.finance.mapper.ProjectCapitalSetMapper;
import com.ejianc.business.finance.service.IProjectCapitalSetService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.util.CountCallable;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.ProjectCapitalSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.IBaseService;


@Service("projectCapitalSetService")
public class ProjectCapitalSetService  extends BaseServiceImpl<ProjectCapitalSetMapper, ProjectCapitalSetEntity> implements IProjectCapitalSetService {
    private static Logger logger = LoggerFactory.getLogger(ProjectCapitalSetService.class);

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ProjectCapitalSetMapper projectCapitalSetMapper;
    
    @Autowired
    private IReceiveService receiveService;

    @Autowired
    private IInvoiceApi invoiceApi;

    @Autowired
    private IIncomeContractApi incomeApi;

    @Override
    public IPage<ProjectCapitalSetVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<ProjectCapitalSetVO> voPage = null;
        IPage<ProjectCapitalSetEntity> entityPage = super.queryPage(queryParam,isEs);
        if(entityPage!=null){
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(),ProjectCapitalSetVO.class));
        }
        return voPage;
    }


    /**
     * 根据项目id，查询项目收支统计
     * @param projectIds
     * @return
     */
    @SuppressWarnings({ "unchecked" })
	@Override
	public Map<Long,JSONObject> queryIncoemAndExpendByProjectIds(List<Long> projectIds, HttpServletRequest request){
        long startTime = System.currentTimeMillis();    //获取开始时间

		Map<Long,BigDecimal> payMoneyMap = new HashMap<>();//付款金额
		Map<Long,BigDecimal> incomeContractTaxMnyMap = new HashMap<>();// 收入合同金额（含税）
		Map<Long,BigDecimal> incomeContractMnyMap = new HashMap<>();// 收入合同金额（不含税）
		Map<Long,BigDecimal> incomeTaxRateMap = new HashMap<>();// 合同税率
		
		Map<Long,BigDecimal> receiveMoneyMap = new HashMap<>();// 收款登记金额
		Map<Long,BigDecimal> financeEngineReceiveMnyMap = new HashMap<>();// 工程收款（含税）
		Map<Long,BigDecimal> financeOtherReceiveMnyMap = new HashMap<>();// 其他收款（含税）
		

		Map<Long,BigDecimal> openInvoiceTaxMnyMap = new HashMap<>();// 开票金额（含税）
		Map<Long,BigDecimal> openInvoiceMnyMap = new HashMap<>();// 开票金额（不含税）
		Map<Long,BigDecimal> openTaxMnyMap = new HashMap<>();// 开票税金

		Map<Long,BigDecimal> receiveSpecialInvoiceTaxMnyMap = new HashMap<>();// 收票含税金额（专票）
		Map<Long,BigDecimal> receiveSpecialInvoiceMnyMap = new HashMap<>();// 收票不含税金额（专票）
		Map<Long,BigDecimal> receiveSpecialTaxMnyMap = new HashMap<>();// 收票税金（专票）
		Map<Long,BigDecimal> receiveGeneralInvoiceTaxMnyMap = new HashMap<>();// 收票含税金额（普票）
		Map<Long,BigDecimal> receiveGeneralInvoiceMnyMap = new HashMap<>();// 收票不含税金额（普票）
		Map<Long,BigDecimal> receiveGeneralTaxMnyMap = new HashMap<>();// 收票税金（普票）
        
        /* 付款金额start  */
        Map<String, Object> map = new HashMap<>();
        map.put("tenantId", InvocationInfoProxy.getTenantid());
        map.put("projectIds", projectIds);
		List<ProjectCapitalSetVO> payMoneyList = projectCapitalSetMapper.getProjectPayMny(map);
		//转成map
		if(payMoneyList!=null&&payMoneyList.size()>0){
			for(ProjectCapitalSetVO vo : payMoneyList){
				payMoneyMap.put(vo.getProjectId(), vo.getProjectIncome());
			}
		}
        /* 付款金额end  */
        String authority = request.getHeader("authority");
        
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));//租户隔离
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));//单据状态已提交和审批通过
        queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);
        
        /** 收入合同 */
        QueryParam queryParam2 = Utils.deepCopy(queryParam);// 深拷贝
        queryParam2.getOrderMap().put("createTime", "desc");
        CommonResponse<JSONObject> incomeResp = incomeApi.getListByQueryParam(queryParam2);
        JSONArray jsonArray = new JSONArray();
        if (!incomeResp.isSuccess() || incomeResp.getData() == null) {
            logger.error("获取收入合同列表失败：{}", incomeResp.getMsg());
        } else {
            jsonArray = incomeResp.getData().getJSONArray("records");
        }
        /** 收款登记 */
        List<ReceiveEntity> receiveList = receiveService.queryList(queryParam);
        JSONArray receiveArray = JSONArray.parseArray(JSON.toJSONString(receiveList));
        /** 开票 */
        CommonResponse<JSONObject> openResp = invoiceApi.getOpenListByQueryParam(queryParam);
        JSONArray openArray = new JSONArray();
        if (!openResp.isSuccess() || openResp.getData() == null) {
            logger.error("获取开票列表失败：{}", openResp.getMsg());
        } else {
            openArray = openResp.getData().getJSONArray("records");
        }
        /** 收票 */
        QueryParam queryParam3 = Utils.deepCopy(queryParam);// 深拷贝
        queryParam3.getParams().put("dependOnProject", new Parameter(QueryParam.EQ, "1"));//属于项目
        CommonResponse<JSONObject> invoiceResp = invoiceApi.getReceiveListByQueryParam(queryParam3);
        JSONArray invoiceArray = new JSONArray();
        if (!invoiceResp.isSuccess() || invoiceResp.getData() == null) {
            logger.error("获取收票列表失败：{}", invoiceResp.getMsg());
        } else {
            invoiceArray = invoiceResp.getData().getJSONArray("records");
        }

        long endTime2 = System.currentTimeMillis();    //获取结束时间
        logger.info("query2 ---- 运行时间：" + (endTime2 - startTime) + "ms");//输出程序运行时间

        // 收入合同金额
        if (CollectionUtils.isNotEmpty(jsonArray)) {
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject obj = jsonArray.getJSONObject(i);
                Long projectId = this.getProjectId(obj);
                // 收入合同金额（含税）
                if(incomeContractTaxMnyMap.get(projectId)!=null){
                    //已经存在，继续增加
                    BigDecimal sumMny = MathUtil.safeAdd(incomeContractTaxMnyMap.get(projectId), obj.getBigDecimal("contractTaxMny"));
                    incomeContractTaxMnyMap.put(projectId, sumMny);
                }else{
                    incomeContractTaxMnyMap.put(projectId, obj.getBigDecimal("contractTaxMny"));
                }
                // 收入合同金额（不含税）
                if(incomeContractMnyMap.get(projectId)!=null){
                    //已经存在，继续增加
                    BigDecimal sumMny = MathUtil.safeAdd(incomeContractMnyMap.get(projectId), obj.getBigDecimal("contractMny"));
                    incomeContractMnyMap.put(projectId, sumMny);
                }else{
                    incomeContractMnyMap.put(projectId, obj.getBigDecimal("contractMny"));
                }
                // 合同税率
                if(incomeTaxRateMap.get(projectId)!=null){
                    //已经存在，忽略
                }else{
                    //取新签订收入合同的税率,创建时间倒序排，第一个出现的是最新的
                    incomeTaxRateMap.put(projectId, obj.getBigDecimal("taxRate"));
                }
            }
        }

        // 收款
        if (CollectionUtils.isNotEmpty(receiveArray)) {
            for (int i = 0; i < receiveArray.size(); i++) {
                JSONObject obj = receiveArray.getJSONObject(i);
                Long projectId = this.getProjectId(obj);
                // 收款登记金额
                if(receiveMoneyMap.get(projectId)!=null){
                    //已经存在，继续增加
                    BigDecimal sumMny = MathUtil.safeAdd(receiveMoneyMap.get(projectId), obj.getBigDecimal("receiveMny"));
                    receiveMoneyMap.put(projectId, sumMny);
                }else{
                    receiveMoneyMap.put(projectId, obj.getBigDecimal("receiveMny"));
                }
                // 工程收款
                if (Long.valueOf("1275321308270993409").equals(obj.getLong("receiveType"))){
                    if(financeEngineReceiveMnyMap.get(projectId)!=null){
                        //已经存在，继续增加
                        BigDecimal sumMny = MathUtil.safeAdd(financeEngineReceiveMnyMap.get(projectId), obj.getBigDecimal("receiveMny"));
                        financeEngineReceiveMnyMap.put(projectId, sumMny);
                    }else{
                        financeEngineReceiveMnyMap.put(projectId, obj.getBigDecimal("receiveMny"));
                    }
                }
                // 其他收款
                if (Long.valueOf("1275321354706132993").equals(obj.getLong("receiveType"))){
                    if(financeOtherReceiveMnyMap.get(projectId)!=null){
                        //已经存在，继续增加
                        BigDecimal sumMny = MathUtil.safeAdd(financeOtherReceiveMnyMap.get(projectId), obj.getBigDecimal("receiveMny"));
                        financeOtherReceiveMnyMap.put(projectId, sumMny);
                    }else{
                        financeOtherReceiveMnyMap.put(projectId, obj.getBigDecimal("receiveMny"));
                    }
                }
            }
        }

        // 开票
        if (CollectionUtils.isNotEmpty(openArray)) {
            for (int i = 0; i < openArray.size(); i++) {
                JSONObject obj = openArray.getJSONObject(i);
                Long projectId = this.getProjectId(obj);
                // 开票金额（含税）
                if(openInvoiceTaxMnyMap.get(projectId)!=null){
                    //已经存在，继续增加
                    BigDecimal sumMny = MathUtil.safeAdd(openInvoiceTaxMnyMap.get(projectId), obj.getBigDecimal("invoiceTaxMny"));
                    openInvoiceTaxMnyMap.put(projectId, sumMny);
                }else{
                    openInvoiceTaxMnyMap.put(projectId, obj.getBigDecimal("invoiceTaxMny"));
                }
                // 开票金额（不含税）
                if(openInvoiceMnyMap.get(projectId)!=null){
                    //已经存在，继续增加
                    BigDecimal sumMny = MathUtil.safeAdd(openInvoiceMnyMap.get(projectId), obj.getBigDecimal("invoiceMny"));
                    openInvoiceMnyMap.put(projectId, sumMny);
                }else{
                    openInvoiceMnyMap.put(projectId, obj.getBigDecimal("invoiceMny"));
                }
                // 开票税金
                if(openTaxMnyMap.get(projectId)!=null){
                    //已经存在，继续增加
                    BigDecimal sumMny = MathUtil.safeAdd(openTaxMnyMap.get(projectId), obj.getBigDecimal("taxMny"));
                    openTaxMnyMap.put(projectId, sumMny);
                }else{
                    openTaxMnyMap.put(projectId, obj.getBigDecimal("taxMny"));
                }
            }
        }

        // 收票
        if (CollectionUtils.isNotEmpty(invoiceArray)) {
            for (int i = 0; i < invoiceArray.size(); i++) {
                JSONObject obj = invoiceArray.getJSONObject(i);
                Long projectId = this.getProjectId(obj);
                // 专票
                if (Long.valueOf("1277537516768632833").equals(obj.getLong("invoiceType"))){

                    // 收票含税金额（专票）
                    if(receiveSpecialInvoiceTaxMnyMap.get(projectId)!=null){
                        //已经存在，继续增加
                        BigDecimal sumMny = MathUtil.safeAdd(receiveSpecialInvoiceTaxMnyMap.get(projectId), obj.getBigDecimal("invoiceTaxMny"));
                        receiveSpecialInvoiceTaxMnyMap.put(projectId, sumMny);
                    }else{
                        receiveSpecialInvoiceTaxMnyMap.put(projectId, obj.getBigDecimal("invoiceTaxMny"));
                    }
                    // 收票不含税金额（专票）
                    if(receiveSpecialInvoiceMnyMap.get(projectId)!=null){
                        //已经存在，继续增加
                        BigDecimal sumMny = MathUtil.safeAdd(receiveSpecialInvoiceMnyMap.get(projectId), obj.getBigDecimal("invoiceMny"));
                        receiveSpecialInvoiceMnyMap.put(projectId, sumMny);
                    }else{
                        receiveSpecialInvoiceMnyMap.put(projectId, obj.getBigDecimal("invoiceMny"));
                    }
                    // 收票税金（专票）
                    if(receiveSpecialTaxMnyMap.get(projectId)!=null){
                        //已经存在，继续增加
                        BigDecimal sumMny = MathUtil.safeAdd(receiveSpecialTaxMnyMap.get(projectId), obj.getBigDecimal("taxMny"));
                        receiveSpecialTaxMnyMap.put(projectId, sumMny);
                    }else{
                        receiveSpecialTaxMnyMap.put(projectId, obj.getBigDecimal("taxMny"));
                    }
                }
                // 普票
                if (Long.valueOf("1277537563879055362").equals(obj.getLong("invoiceType"))){
                    // 收票含税金额（普票）
                    if(receiveGeneralInvoiceTaxMnyMap.get(projectId)!=null){
                        //已经存在，继续增加
                        BigDecimal sumMny = MathUtil.safeAdd(receiveGeneralInvoiceTaxMnyMap.get(projectId), obj.getBigDecimal("invoiceTaxMny"));
                        receiveGeneralInvoiceTaxMnyMap.put(projectId, sumMny);
                    }else{
                        receiveGeneralInvoiceTaxMnyMap.put(projectId, obj.getBigDecimal("invoiceTaxMny"));
                    }
                    // 收票不含税金额（普票）
                    if(receiveGeneralInvoiceMnyMap.get(projectId)!=null){
                        //已经存在，继续增加
                        BigDecimal sumMny = MathUtil.safeAdd(receiveGeneralInvoiceMnyMap.get(projectId), obj.getBigDecimal("invoiceMny"));
                        receiveGeneralInvoiceMnyMap.put(projectId, sumMny);
                    }else{
                        receiveGeneralInvoiceMnyMap.put(projectId, obj.getBigDecimal("invoiceMny"));
                    }
                    // 收票税金（普票）
                    if(receiveGeneralTaxMnyMap.get(projectId)!=null){
                        //已经存在，继续增加
                        BigDecimal sumMny = MathUtil.safeAdd(receiveGeneralTaxMnyMap.get(projectId), obj.getBigDecimal("taxMny"));
                        receiveGeneralTaxMnyMap.put(projectId, sumMny);
                    }else{
                        receiveGeneralTaxMnyMap.put(projectId, obj.getBigDecimal("taxMny"));
                    }
                }
            }
        }
        
        Map<Long,JSONObject> result = new HashMap<>();
		for(Long projectId : projectIds){
			JSONObject resp = new JSONObject();
	        resp.put("receiveMoney", receiveMoneyMap.get(projectId));
	        resp.put("payMoney", payMoneyMap.get(projectId));
	        resp.put("incomeContractTaxMny", incomeContractTaxMnyMap.get(projectId));
	        resp.put("incomeContractMny", incomeContractMnyMap.get(projectId));
	        resp.put("incomeTaxRate", incomeTaxRateMap.get(projectId));
	        resp.put("financeEngineReceiveMny", financeEngineReceiveMnyMap.get(projectId));
	        resp.put("financeOtherReceiveMny", financeOtherReceiveMnyMap.get(projectId));
	        resp.put("openInvoiceTaxMny", openInvoiceTaxMnyMap.get(projectId));
	        resp.put("openInvoiceMny", openInvoiceMnyMap.get(projectId));
	        resp.put("openTaxMny", openTaxMnyMap.get(projectId));
	        resp.put("receiveSpecialInvoiceTaxMny", receiveSpecialInvoiceTaxMnyMap.get(projectId));
	        resp.put("receiveSpecialInvoiceMny", receiveSpecialInvoiceMnyMap.get(projectId));
	        resp.put("receiveSpecialTaxMny", receiveSpecialTaxMnyMap.get(projectId));
	        resp.put("receiveGeneralInvoiceTaxMny", receiveGeneralInvoiceTaxMnyMap.get(projectId));
	        resp.put("receiveGeneralInvoiceMny", receiveGeneralInvoiceMnyMap.get(projectId));
	        resp.put("receiveGeneralTaxMny", receiveGeneralTaxMnyMap.get(projectId));
	        result.put(projectId, resp);
		}
		
        long endTime = System.currentTimeMillis();    //获取结束时间
        logger.info("queryIncoemAndExpendByProjectId ---- 运行时间：" + (endTime - endTime2) + "ms");//输出程序运行时间
        return result;
    }

    /**
     * 获取项目主键
     * @param obj
     * @return
     */
    private Long getProjectId(JSONObject obj) {
        Long projectId = null;
        if(obj.getString("projectId").length()>20){
            projectId = obj.getJSONObject("projectId").getLong("id");
        }else{
            projectId = obj.getLong("projectId");
        }
        return projectId;
    }

    @SuppressWarnings({ "unchecked" })
	@Override
	public CommonResponse<JSONObject> queryIncoemAndExpendByProjectId(@RequestParam(value = "projectId") Long projectId, HttpServletRequest request){
        long startTime = System.currentTimeMillis();    //获取开始时间
        String authority = request.getHeader("authority");

        // 付款金额
        Map<String, Object> map = new HashMap<>();
        map.put("tenantId", InvocationInfoProxy.getTenantid());
        List<Long> projectIds = new ArrayList<>();
        projectIds.add(projectId);
        map.put("projectIds", projectIds);
        List<ProjectCapitalSetVO> payMoneyList = projectCapitalSetMapper.getProjectPayMny(map);
        BigDecimal payMoney = null;// 付款金额
        if(payMoneyList!=null&&payMoneyList.size()>0){
            payMoney = payMoneyList.get(0).getProjectIncome();
        }

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));//租户隔离
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));//单据状态已提交和审批通过
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);

        /** 收入合同 */
        QueryParam queryParam2 = Utils.deepCopy(queryParam);// 深拷贝
        queryParam2.getOrderMap().put("createTime", "desc");
        CommonResponse<JSONObject> incomeResp = incomeApi.getListByQueryParam(queryParam2);
        JSONArray jsonArray = new JSONArray();
        if (!incomeResp.isSuccess() || incomeResp.getData() == null) {
            logger.error("获取收入合同列表失败：{}", incomeResp.getMsg());
        } else {
            jsonArray = incomeResp.getData().getJSONArray("records");
        }
        /** 收款登记 */
        List<ReceiveEntity> receiveList = receiveService.queryList(queryParam);
        JSONArray receiveArray = JSONArray.parseArray(JSON.toJSONString(receiveList));
        /** 开票 */
        CommonResponse<JSONObject> openResp = invoiceApi.getOpenListByQueryParam(queryParam);
        JSONArray openArray = new JSONArray();
        if (!openResp.isSuccess() || openResp.getData() == null) {
            logger.error("获取开票列表失败：{}", openResp.getMsg());
        } else {
            openArray = openResp.getData().getJSONArray("records");
        }
        /** 收票 */
        QueryParam queryParam3 = Utils.deepCopy(queryParam);// 深拷贝
        queryParam3.getParams().put("dependOnProject", new Parameter(QueryParam.EQ, "1"));//属于项目
        CommonResponse<JSONObject> invoiceResp = invoiceApi.getReceiveListByQueryParam(queryParam3);
        JSONArray invoiceArray = new JSONArray();
        if (!invoiceResp.isSuccess() || invoiceResp.getData() == null) {
            logger.error("获取收票列表失败：{}", invoiceResp.getMsg());
        } else {
            invoiceArray = invoiceResp.getData().getJSONArray("records");
        }

        BigDecimal receiveMoney = null;// 收款登记金额
        BigDecimal incomeContractTaxMny = null;// 收入合同金额（含税）
        BigDecimal incomeContractMny = null;// 收入合同金额（不含税）
        BigDecimal incomeTaxRate = null;// 合同税率
        BigDecimal financeEngineReceiveMny = null;// 工程收款（含税）
        BigDecimal financeOtherReceiveMny = null;// 其他收款（含税）
        BigDecimal openInvoiceTaxMny = null;// 开票金额（含税）
        BigDecimal openInvoiceMny = null;// 开票金额（不含税）
        BigDecimal openTaxMny = null;// 开票税金
        BigDecimal receiveSpecialInvoiceTaxMny = null;// 收票含税金额（专票）
        BigDecimal receiveSpecialInvoiceMny = null;// 收票不含税金额（专票）
        BigDecimal receiveSpecialTaxMny = null;// 收票税金（专票）
        BigDecimal receiveGeneralInvoiceTaxMny = null;// 收票含税金额（普票）
        BigDecimal receiveGeneralInvoiceMny = null;// 收票不含税金额（普票）
        BigDecimal receiveGeneralTaxMny = null;// 收票税金（普票）
        // 取新签订收入合同的税率
        if (CollectionUtils.isNotEmpty(jsonArray)) {
            JSONObject obj1 = jsonArray.getJSONObject(0);
            incomeTaxRate = obj1.getBigDecimal("taxRate");
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject obj = jsonArray.getJSONObject(i);
                incomeContractTaxMny = MathUtil.safeAdd(incomeContractTaxMny, obj.getBigDecimal("contractTaxMny"));
                incomeContractMny = MathUtil.safeAdd(incomeContractMny, obj.getBigDecimal("incomeContractMny"));
            }
        }

        // 收款登记金额
        if (CollectionUtils.isNotEmpty(receiveArray)) {
            for (int i = 0; i < receiveArray.size(); i++) {
                JSONObject obj = receiveArray.getJSONObject(i);
                // 工程收款
                if (Long.valueOf("1275321308270993409").equals(obj.getLong("receiveType"))){
                    financeEngineReceiveMny = MathUtil.safeAdd(financeEngineReceiveMny, obj.getBigDecimal("receiveMny"));
                }
                // 其他收款
                if (Long.valueOf("1275321354706132993").equals(obj.getLong("receiveType"))){
                    financeOtherReceiveMny = MathUtil.safeAdd(financeOtherReceiveMny, obj.getBigDecimal("receiveMny"));
                }
                receiveMoney = MathUtil.safeAdd(receiveMoney, obj.getBigDecimal("receiveMny"));
            }
        }

        // 开票
        if (CollectionUtils.isNotEmpty(openArray)) {
            for (int i = 0; i < openArray.size(); i++) {
                JSONObject obj = openArray.getJSONObject(i);
                openInvoiceTaxMny = MathUtil.safeAdd(openInvoiceTaxMny, obj.getBigDecimal("invoiceTaxMny"));
                openInvoiceMny = MathUtil.safeAdd(openInvoiceMny, obj.getBigDecimal("invoiceMny"));
                openTaxMny = MathUtil.safeAdd(openTaxMny, obj.getBigDecimal("taxMny"));
            }
        }

        // 收票
        if (CollectionUtils.isNotEmpty(invoiceArray)) {
            for (int i = 0; i < invoiceArray.size(); i++) {
                JSONObject obj = invoiceArray.getJSONObject(i);
                // 专票
                if (Long.valueOf("1277537516768632833").equals(obj.getLong("invoiceType"))){
                    receiveSpecialInvoiceTaxMny = MathUtil.safeAdd(receiveSpecialInvoiceTaxMny, obj.getBigDecimal("invoiceTaxMny"));
                    receiveSpecialInvoiceMny = MathUtil.safeAdd(receiveSpecialInvoiceMny, obj.getBigDecimal("invoiceMny"));
                    receiveSpecialTaxMny = MathUtil.safeAdd(receiveSpecialTaxMny, obj.getBigDecimal("taxMny"));
                }
                // 普票
                if (Long.valueOf("1277537563879055362").equals(obj.getLong("invoiceType"))){
                    receiveGeneralInvoiceTaxMny = MathUtil.safeAdd(receiveGeneralInvoiceTaxMny, obj.getBigDecimal("invoiceTaxMny"));
                    receiveGeneralInvoiceMny = MathUtil.safeAdd(receiveGeneralInvoiceMny, obj.getBigDecimal("invoiceMny"));
                    receiveGeneralTaxMny = MathUtil.safeAdd(receiveGeneralTaxMny, obj.getBigDecimal("taxMny"));
                }
            }
        }

        JSONObject resp = new JSONObject();

        resp.put("receiveMoney", receiveMoney);
        resp.put("payMoney", payMoney);
        resp.put("incomeContractTaxMny", incomeContractTaxMny);
        resp.put("incomeContractMny", incomeContractMny);
        resp.put("incomeTaxRate", incomeTaxRate);
        resp.put("financeEngineReceiveMny", financeEngineReceiveMny);
        resp.put("financeOtherReceiveMny", financeOtherReceiveMny);
        resp.put("openInvoiceTaxMny", openInvoiceTaxMny);
        resp.put("openInvoiceMny", openInvoiceMny);
        resp.put("openTaxMny", openTaxMny);
        resp.put("receiveSpecialInvoiceTaxMny", receiveSpecialInvoiceTaxMny);
        resp.put("receiveSpecialInvoiceMny", receiveSpecialInvoiceMny);
        resp.put("receiveSpecialTaxMny", receiveSpecialTaxMny);
        resp.put("receiveGeneralInvoiceTaxMny", receiveGeneralInvoiceTaxMny);
        resp.put("receiveGeneralInvoiceMny", receiveGeneralInvoiceMny);
        resp.put("receiveGeneralTaxMny", receiveGeneralTaxMny);

        long endTime = System.currentTimeMillis();    //获取结束时间
        logger.info("queryIncoemAndExpendByProjectId ---- 运行时间：" + (endTime - startTime) + "ms");//输出程序运行时间

        return CommonResponse.success(resp);
    }

    /**
     *  汇总queryParam查询到的List<Entity>中的某一金额字段
     * @param resp
     * @param field
     * @return
     */
    private static BigDecimal getSumMny(CommonResponse<JSONObject> resp, String records, String field) {
        JSONArray jsonArray = new JSONArray();
        if (!resp.isSuccess() || resp.getData() == null) {
            logger.error("获取列表失败：{}", resp.getMsg());
        } else {
            logger.info("查询列表结果：{}", resp);
            jsonArray = resp.getData().getJSONArray(records);
        }
        BigDecimal sumMny = null;
        if (CollectionUtils.isNotEmpty(jsonArray)) {
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject obj = jsonArray.getJSONObject(i);
                sumMny = MathUtil.safeAdd(sumMny, obj.getBigDecimal(field));
            }
        }
        return sumMny;
    }

    /**
     * 汇总金额字段
     * @param json
     * @param field
     * @return
     */
    private static BigDecimal getSumMny(JSONObject json, String field) {
        JSONArray jsonArray = json.getJSONArray("records");
        if(CollectionUtils.isEmpty(jsonArray)){
            return null;
        }
        BigDecimal sumMny = null;
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject obj = jsonArray.getJSONObject(i);
            sumMny = MathUtil.safeAdd(sumMny, obj.getBigDecimal(field));
        }
        return sumMny;
    }

    /**
     * 使用Callable查询数据列表
     * @param threadPool
     * @param authority
     * @param url
     * @param queryParam
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     */
    private Future<JSONObject> excute(ExecutorService threadPool, String authority, String url, QueryParam queryParam) {
        Callable<JSONObject> callable = new CountCallable(
                RequestContextHolder.getRequestAttributes(), authority, BASE_HOST + url, queryParam, null);
        Future<JSONObject> future = threadPool.submit(callable);
        return future;
    }
    
    /**
     *  注入service使用Callable查询数据列表
     * @param threadPool
     * @param queryParam
     * @param service
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     */
    private Future<JSONObject> excute(ExecutorService threadPool, QueryParam queryParam, IBaseService service) {
        Callable<JSONObject> callable = new CountCallable(
                RequestContextHolder.getRequestAttributes(), null, null, queryParam, service);
        Future<JSONObject> future = threadPool.submit(callable);
        return future;
    }

    public static  BigDecimal roundTwoPre(BigDecimal src){
        return src == null ? new BigDecimal("0.00") : src.setScale(2, BigDecimal.ROUND_HALF_EVEN) ;
    }
}
