/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.utils.NumberToCN;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="payReimburse")
public class PayReimburseBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayReimburseService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPayRecordService recordService;
    @Autowired
    private IVoucherApi voucherApi;
    @Autowired
    private HttpServletRequest request;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        updateWrapper.set(PayReimburseEntity::getApproveTime, (Object)new Date());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        List listRec;
        PayReimburseEntity entity = (PayReimburseEntity)((Object)this.service.selectById(billId));
        if (Optional.ofNullable(entity.getCloseFlag()).orElse(false).booleanValue()) {
            BigDecimal applyMnyBeforeClose = entity.getApplyMnyBeforeClose();
            entity.setApplyMny(applyMnyBeforeClose);
            entity.setApplyMnyCn(NumberToCN.number2CN(applyMnyBeforeClose));
            entity.setCloseFlag(Boolean.FALSE);
            entity.setCloseState(null);
            entity.setCloseTime(null);
            entity.setCloseUser(null);
        }
        entity.setPayMny(null);
        entity.setPayStatus(1);
        entity.setApproveTime(null);
        this.service.saveOrUpdate((Object)entity);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        this.service.pullCost(billId);
        QueryWrapper recordQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId);
        List recordEntities = this.recordService.list((Wrapper)recordQueryWrapper);
        this.recordService.remove((Wrapper)recordQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)recordEntities) && CollectionUtils.isNotEmpty(listRec = recordEntities.stream().filter(t -> VoucherFlag.SUCCESS.equals(t.getVoucherFlag())).collect(Collectors.toList()))) {
            ExecutorService threadPool = Executors.newFixedThreadPool(listRec.size());
            String authority = this.request.getHeader("authority");
            if (authority == null) {
                this.logger.info("request-authority\u4e3a\u7a7a");
                authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
            }
            try {
                for (PayRecordEntity recordEntity : listRec) {
                    VoucherParams voucherParamsDed = VoucherParams.newInstanceByOrgId((String)"BT200529000000002", (Object)((Object)recordEntity), (SystemCodeEnum)SystemCodeEnum.FINANCE);
                    AccplatVoucherCallable voucherCallable = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this.recordService, voucherParamsDed, "del", RequestContextHolder.getRequestAttributes(), authority);
                    threadPool.submit(voucherCallable);
                }
            }
            catch (Exception e) {
                this.logger.error("\u62a5\u9500\u64a4\u56de\u51ed\u8bc1\u5f02\u5e38, ", (Throwable)e);
            }
            finally {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }
}

