package com.ejianc.business.finance.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ConstantTypeEnum {

    // 合同付款支付类型
    PRE_PAY_TYPE(Long.valueOf("1"), "预付款"),
    PROGRESS_PAY_TYPE(Long.valueOf("2"), "过程款"),
    OTHER_PAY_TYPE(Long.valueOf("3"), "其他"),
//    // 报销付款费用率类型
//    SERVE_FEE_TYPE(Long.valueOf("1269836169934196737"), "招待费"),
//    TRAVEL_FEE_TYPE(Long.valueOf("1269836232588709890"), "差旅费"),
//    TRRANSPORT_FEE_TYPE(Long.valueOf("1269836262896750593"), "运输费"),
//    MECHANICAL_FEE_TYPE(Long.valueOf("1269836304240005121"), "零星机械费"),
//    LABOUR_FEE_TYPE(Long.valueOf("1269836353325944833"), "人工费"),
//    OTHER_FEE_TYPE(Long.valueOf("1269836400872574978"), "其他费用"),
//    DETECT_FEE_TYPE(Long.valueOf("1403590772752326657"), "检测费"),
//    LIFE_FEE_TYPE(Long.valueOf("1403612649499471873"), "网络空调等起居费用"),
//    CERTIFICATE_FEE_TYPE(Long.valueOf("1403590921331351554"), "证书费"),
//    WATER_FEE_TYPE(Long.valueOf("1403613800454238210"), "水电费"),
//    // 收款类型
//    CONTRACT_RECEIVE_TYPE(Long.valueOf("1275321308270993409"), "工程合同收款"),
//    OTRAVEL_RECEIVE_TYPE(Long.valueOf("1275321354706132993"), "其他收款"),
    NULL(null, null),
    ;

    private final Long code;
    private final String name;
    private static Map<Integer, ConstantTypeEnum> enumMap = new HashMap();

    private ConstantTypeEnum(Long code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static ConstantTypeEnum getEnumByCode(Long code) {
        return (ConstantTypeEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map)EnumSet.allOf(ConstantTypeEnum.class).stream().collect(Collectors.toMap(ConstantTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
